/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.inliner;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.inliner.NopWhyAreYouNotInliningReporter;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporterImpl;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Set;

public abstract class WhyAreYouNotInliningReporter {
    public static WhyAreYouNotInliningReporter createFor(ProgramMethod callee, AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        if (appView.appInfo().isWhyAreYouNotInliningMethod((DexMethod)callee.getReference())) {
            return new WhyAreYouNotInliningReporterImpl(callee, context, appView.options().testing.whyAreYouNotInliningConsumer);
        }
        return NopWhyAreYouNotInliningReporter.getInstance();
    }

    public static void handleInvokeWithUnknownTarget(InvokeMethod invoke, AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        if (appView.appInfo().hasNoWhyAreYouNotInliningMethods()) {
            return;
        }
        ProgramMethodSet possibleProgramTargets = invoke.lookupProgramDispatchTargets(appView, context);
        if (possibleProgramTargets == null) {
            return;
        }
        for (ProgramMethod possibleTarget : possibleProgramTargets) {
            WhyAreYouNotInliningReporter.createFor(possibleTarget, appView, context).reportUnknownTarget();
        }
    }

    public abstract void reportCallerNotSameClass();

    public abstract void reportCallerNotSameNest();

    public abstract void reportCallerNotSamePackage();

    public abstract void reportCallerNotSubtype();

    public abstract void reportCallerHasUnknownApiLevel();

    public abstract void reportClasspathMethod();

    public abstract void reportInaccessible();

    public abstract void reportIncorrectArity(int var1, int var2);

    public abstract void reportInlineeDoesNotHaveCode();

    public abstract void reportInlineeNotInliningCandidate();

    public abstract void reportInlineeNotProcessed();

    public abstract void reportInlineeNotSimple();

    public abstract void reportInlineeHigherApiCall(ComputedApiLevel var1, ComputedApiLevel var2);

    public abstract void reportInlineeRefersToClassesNotInMainDex();

    public abstract void reportInliningAcrossFeatureSplit();

    public abstract void reportInstructionBudgetIsExceeded();

    public abstract void reportInvalidDoubleInliningCandidate();

    public abstract void reportInvalidInliningReason(Inliner.Reason var1, Set<Inliner.Reason> var2);

    public abstract void reportLibraryMethod();

    public abstract void reportMarkedAsNeverInline();

    public abstract void reportMustTriggerClassInitialization();

    public abstract void reportNoInliningIntoConstructorsWhenGeneratingClassFiles();

    public abstract void reportPinned();

    public abstract void reportPotentialExplosionInExceptionalControlFlowResolutionBlocks(int var1, int var2);

    public abstract void reportProcessedConcurrently();

    public abstract void reportReceiverDefinitelyNull();

    public abstract void reportReceiverMaybeNull();

    public abstract void reportRecursiveMethod();

    abstract void reportUnknownTarget();

    public abstract void reportUnsafeConstructorInliningDueToFinalFieldAssignment(InstancePut var1);

    public abstract void reportUnsafeConstructorInliningDueToIndirectConstructorCall(InvokeDirect var1);

    public abstract void reportUnsafeConstructorInliningDueToUninitializedObjectUse(Instruction var1);

    public abstract void reportWillExceedInstructionBudget(int var1, int var2);

    public abstract void reportWillExceedMaxInliningDepth(int var1, int var2);

    public abstract void reportWillExceedMonitorEnterValuesBudget(int var1, int var2);

    public abstract boolean unsetReasonHasBeenReportedFlag();
}

