/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.LibraryMethod;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.library.sideeffects.JavaLangObjectsSideEffectCollection;
import com.android.tools.r8.utils.BiPredicateUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public class LibraryMethodSideEffectModelCollection {
    private final Map<DexMethod, BiPredicate<DexMethod, List<Value>>> finalMethodsWithoutSideEffects;
    private final Set<DexMethod> unconditionalFinalMethodsWithoutSideEffects;
    private final Set<DexMethod> nonFinalMethodsWithoutSideEffects;

    public LibraryMethodSideEffectModelCollection(AppView<?> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        this.finalMethodsWithoutSideEffects = LibraryMethodSideEffectModelCollection.buildFinalMethodsWithoutSideEffects(appView, dexItemFactory);
        this.unconditionalFinalMethodsWithoutSideEffects = LibraryMethodSideEffectModelCollection.buildUnconditionalFinalMethodsWithoutSideEffects(dexItemFactory);
        this.nonFinalMethodsWithoutSideEffects = LibraryMethodSideEffectModelCollection.buildNonFinalMethodsWithoutSideEffects(dexItemFactory);
    }

    private static Map<DexMethod, BiPredicate<DexMethod, List<Value>>> buildFinalMethodsWithoutSideEffects(AppView<?> appView, DexItemFactory dexItemFactory) {
        ImmutableMap.Builder<DexMethod, BiPredicate<DexMethod, List>> builder = ImmutableMap.builder().put(dexItemFactory.byteMembers.byteValue, (method, arguments) -> ((Value)arguments.get(0)).isNeverNull()).put(dexItemFactory.objectsMethods.toStringWithObject, (method, arguments) -> !JavaLangObjectsSideEffectCollection.toStringMayHaveSideEffects(appView, arguments)).put(dexItemFactory.stringMembers.constructor, (method, arguments) -> ((Value)arguments.get(1)).isNeverNull()).put(dexItemFactory.stringMembers.valueOf, (method, arguments) -> !JavaLangObjectsSideEffectCollection.toStringMayHaveSideEffects(appView, arguments));
        LibraryMethodSideEffectModelCollection.putAll(builder, dexItemFactory.stringBufferMethods.constructorMethods, dexItemFactory.stringBufferMethods::constructorInvokeIsSideEffectFree);
        LibraryMethodSideEffectModelCollection.putAll(builder, dexItemFactory.stringBuilderMethods.constructorMethods, dexItemFactory.stringBuilderMethods::constructorInvokeIsSideEffectFree);
        return builder.build();
    }

    private static Set<DexMethod> buildUnconditionalFinalMethodsWithoutSideEffects(DexItemFactory dexItemFactory) {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(dexItemFactory.booleanMembers.toString)).add(dexItemFactory.byteMembers.toString)).add(dexItemFactory.byteMembers.valueOf)).add(dexItemFactory.classMethods.desiredAssertionStatus)).add(dexItemFactory.charMembers.toString)).add(dexItemFactory.doubleMembers.toString)).add(dexItemFactory.enumMembers.constructor)).add(dexItemFactory.floatMembers.toString)).add(dexItemFactory.integerMembers.toString)).add(dexItemFactory.longMembers.toString)).add(dexItemFactory.npeMethods.init)).add(dexItemFactory.npeMethods.initWithMessage)).add(dexItemFactory.recordMembers.constructor)).add(dexItemFactory.objectMembers.constructor)).add(dexItemFactory.objectMembers.getClass)).add(dexItemFactory.shortMembers.toString)).add(dexItemFactory.stringBufferMethods.toString)).add(dexItemFactory.stringBuilderMethods.toString)).add(dexItemFactory.stringMembers.length)).add(dexItemFactory.stringMembers.hashCode)).add(dexItemFactory.stringMembers.isEmpty)).add(dexItemFactory.stringMembers.toString)).add(dexItemFactory.stringMembers.trim)).addAll(dexItemFactory.classMethods.getNames)).addAll(dexItemFactory.boxedValueOfMethods())).build();
    }

    private static Set<DexMethod> buildNonFinalMethodsWithoutSideEffects(DexItemFactory dexItemFactory) {
        return ImmutableSet.of(dexItemFactory.objectMembers.equals, dexItemFactory.objectMembers.hashCode, dexItemFactory.objectMembers.toString);
    }

    private static <K, V> void putAll(ImmutableMap.Builder<K, V> builder, Iterable<K> keys2, V value) {
        for (K key : keys2) {
            builder.put(key, value);
        }
    }

    public void forEachSideEffectFreeFinalMethod(Consumer<DexMethod> consumer) {
        this.unconditionalFinalMethodsWithoutSideEffects.forEach(consumer);
    }

    public boolean isCallToSideEffectFreeFinalMethod(InvokeMethod invoke) {
        return this.isSideEffectFreeFinalMethod(invoke.getInvokedMethod(), invoke.arguments());
    }

    public boolean isSideEffectFreeFinalMethod(DexMethod method, List<Value> arguments) {
        return this.unconditionalFinalMethodsWithoutSideEffects.contains(method) || this.finalMethodsWithoutSideEffects.getOrDefault(method, BiPredicateUtils.alwaysFalse()).test(method, (DexMethod)((Object)arguments));
    }

    public boolean isSideEffectFree(InvokeMethod invoke, LibraryMethod singleTarget) {
        return this.isSideEffectFreeFinalMethod((DexMethod)singleTarget.getReference(), invoke.arguments()) || this.nonFinalMethodsWithoutSideEffects.contains(singleTarget.getReference());
    }
}

