/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.optimize.info.LibraryOptimizationInfoInitializerFeedback;
import com.android.tools.r8.ir.optimize.info.field.EmptyInstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoFactory;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.NonTrivialInstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.library.LibraryFieldSynthesis;
import java.util.BitSet;
import java.util.Set;

public class LibraryOptimizationInfoInitializer {
    private final AbstractValueFactory abstractValueFactory;
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final LibraryOptimizationInfoInitializerFeedback feedback = LibraryOptimizationInfoInitializerFeedback.getInstance();
    private final Set<DexType> modeledLibraryTypes = Sets.newIdentityHashSet();

    LibraryOptimizationInfoInitializer(AppView<?> appView) {
        this.abstractValueFactory = appView.abstractValueFactory();
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private void modelInstanceInitializers() {
        DexEncodedMethod objectConstructor = this.lookupMethod(this.dexItemFactory.objectMembers.constructor);
        if (objectConstructor != null) {
            EmptyInstanceFieldInitializationInfoCollection fieldInitializationInfos = EmptyInstanceFieldInitializationInfoCollection.getInstance();
            this.feedback.setInstanceInitializerInfoCollection(objectConstructor, InstanceInitializerInfoCollection.of(NonTrivialInstanceInitializerInfo.builder(fieldInitializationInfos).build()));
        }
        DexItemFactory.EnumMembers enumMembers = this.dexItemFactory.enumMembers;
        DexEncodedMethod enumConstructor = this.lookupMethod(enumMembers.constructor);
        if (enumConstructor != null) {
            LibraryFieldSynthesis.synthesizeEnumFields(this.appView);
            InstanceFieldInitializationInfoFactory factory = this.appView.instanceFieldInitializationInfoFactory();
            InstanceFieldInitializationInfoCollection fieldInitializationInfos = InstanceFieldInitializationInfoCollection.builder().recordInitializationInfo(enumMembers.nameField, (InstanceFieldInitializationInfo)factory.createArgumentInitializationInfo(1)).recordInitializationInfo(enumMembers.ordinalField, (InstanceFieldInitializationInfo)factory.createArgumentInitializationInfo(2)).build();
            this.feedback.setInstanceInitializerInfoCollection(enumConstructor, InstanceInitializerInfoCollection.of(NonTrivialInstanceInitializerInfo.builder(fieldInitializationInfos).setParent(this.dexItemFactory.objectMembers.constructor).build()));
        }
    }

    private void modelStaticFinalLibraryFields(Set<DexEncodedField> finalLibraryFields) {
        for (DexEncodedField field : finalLibraryFields) {
            if (!field.isStatic()) continue;
            this.feedback.recordLibraryFieldHasAbstractValue(field, this.abstractValueFactory.createSingleFieldValue((DexField)field.getReference(), ObjectState.empty()));
        }
    }

    private void modelLibraryMethodsNonNullParamOrThrow() {
        this.dexItemFactory.libraryMethodsNonNullParamOrThrow.forEach((method, nonNullParamOrThrow) -> {
            DexEncodedMethod definition = this.lookupMethod((DexMethod)method);
            if (definition != null) {
                assert (((int[])nonNullParamOrThrow).length > 0);
                int size = nonNullParamOrThrow[((int[])nonNullParamOrThrow).length - 1] + 1;
                BitSet bitSet = new BitSet(size);
                for (int argumentIndex : nonNullParamOrThrow) {
                    assert (argumentIndex < size);
                    bitSet.set(argumentIndex);
                }
                this.feedback.setNonNullParamOrThrow(definition, bitSet);
                if (definition.getOptimizationInfo().hasNonNullParamOnNormalExits()) {
                    definition.getOptimizationInfo().getNonNullParamOnNormalExits().or(bitSet);
                } else {
                    this.feedback.setNonNullParamOnNormalExits(definition, (BitSet)bitSet.clone());
                }
            }
        });
    }

    private void modelLibraryMethodsReturningNonNull() {
        for (DexMethod method : this.dexItemFactory.libraryMethodsReturningNonNull) {
            DexEncodedMethod definition = this.lookupMethod(method);
            if (definition == null) continue;
            assert (definition.getOptimizationInfo().getDynamicType().isUnknown() || definition.getOptimizationInfo().getDynamicType().isNotNullType());
            this.feedback.setDynamicReturnType(definition, this.appView, (DynamicType)DynamicType.definitelyNotNull());
        }
    }

    private void modelLibraryMethodsReturningReceiver() {
        for (DexMethod method : this.dexItemFactory.libraryMethodsReturningReceiver) {
            DexEncodedMethod definition = this.lookupMethod(method);
            if (definition == null) continue;
            this.feedback.methodReturnsArgument(definition, 0);
        }
    }

    private void modelLibraryMethodsWithoutSideEffects() {
        this.appView.getLibraryMethodSideEffectModelCollection().forEachSideEffectFreeFinalMethod(method -> {
            DexEncodedMethod definition = this.lookupMethod((DexMethod)method);
            if (definition != null) {
                this.feedback.methodMayNotHaveSideEffects(definition);
            }
        });
    }

    private void modelRequireNonNullMethods() {
        for (DexMethod requireNonNullMethod : this.dexItemFactory.objectsMethods.requireNonNullMethods()) {
            DexEncodedMethod definition = this.lookupMethod(requireNonNullMethod);
            if (definition == null) continue;
            this.feedback.methodReturnsArgument(definition, 0);
        }
    }

    private DexEncodedMethod lookupMethod(DexMethod method) {
        DexClass holder = this.appView.definitionForHolder(method);
        DexEncodedMethod definition = method.lookupOnClass(holder);
        if (definition != null) {
            this.modeledLibraryTypes.add(method.holder);
            return definition;
        }
        return null;
    }

    void run() {
        this.modelInstanceInitializers();
        this.modelLibraryMethodsNonNullParamOrThrow();
        this.modelLibraryMethodsReturningNonNull();
        this.modelLibraryMethodsReturningReceiver();
        this.modelLibraryMethodsWithoutSideEffects();
        this.modelRequireNonNullMethods();
    }

    Set<DexType> getModeledLibraryTypes() {
        return this.modeledLibraryTypes;
    }
}

