/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.library.StatelessLibraryMethodModelCollection;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Set;

public class ObjectsMethodOptimizer
extends StatelessLibraryMethodModelCollection {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final DexItemFactory.ObjectsMethods objectsMethods;
    private final InternalOptions options;

    ObjectsMethodOptimizer(AppView<?> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        this.appView = appView;
        this.dexItemFactory = dexItemFactory;
        this.objectsMethods = dexItemFactory.objectsMethods;
        this.options = appView.options();
    }

    private void optimizeEquals(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke) {
        Value aValue = invoke.getFirstArgument();
        Value bValue = invoke.getLastArgument();
        if (aValue.isAlwaysNull(this.appView)) {
            if (bValue.isAlwaysNull(this.appView)) {
                instructionIterator.replaceCurrentInstructionWithConstTrue(code);
            } else if (bValue.isNeverNull()) {
                instructionIterator.replaceCurrentInstructionWithConstFalse(code);
            } else if (this.options.canUseJavaUtilObjectsIsNull()) {
                instructionIterator.replaceCurrentInstruction(((InvokeStatic.Builder)((InvokeStatic.Builder)((InvokeStatic.Builder)InvokeStatic.builder().setMethod(this.objectsMethods.isNull)).setOutValue(invoke.outValue())).setSingleArgument(bValue)).build());
            }
        } else if (aValue.isNeverNull()) {
            instructionIterator.replaceCurrentInstruction(((InvokeVirtual.Builder)((InvokeVirtual.Builder)((InvokeVirtual.Builder)InvokeVirtual.builder().setMethod(this.dexItemFactory.objectMembers.equals)).setOutValue(invoke.outValue())).setArguments(ImmutableList.of(aValue, bValue))).build());
        }
    }

    private void optimizeHashCode(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke) {
        Value inValue = invoke.getFirstArgument();
        if (inValue.isAlwaysNull(this.appView)) {
            instructionIterator.replaceCurrentInstructionWithConstInt(code, 0);
        } else if (inValue.isNeverNull()) {
            instructionIterator.replaceCurrentInstruction(((InvokeVirtual.Builder)((InvokeVirtual.Builder)((InvokeVirtual.Builder)InvokeVirtual.builder().setMethod(this.dexItemFactory.objectMembers.hashCode)).setOutValue(invoke.outValue())).setSingleArgument(inValue)).build());
        }
    }

    private void optimizeIsNull(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke) {
        Value inValue = invoke.getFirstArgument();
        if (inValue.isAlwaysNull(this.appView)) {
            instructionIterator.replaceCurrentInstructionWithConstTrue(code);
        } else if (inValue.isNeverNull()) {
            instructionIterator.replaceCurrentInstructionWithConstFalse(code);
        }
    }

    private void optimizeNonNull(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke) {
        Value inValue = invoke.getFirstArgument();
        if (inValue.isAlwaysNull(this.appView)) {
            instructionIterator.replaceCurrentInstructionWithConstFalse(code);
        } else if (inValue.isNeverNull()) {
            instructionIterator.replaceCurrentInstructionWithConstTrue(code);
        }
    }

    private void optimizeRequireNonNull(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove, DexClassAndMethod singleTarget) {
        if (invoke.hasOutValue() && invoke.outValue().hasLocalInfo()) {
            return;
        }
        Value inValue = invoke.getFirstArgument();
        if (inValue.isNeverNull()) {
            if (invoke.hasOutValue()) {
                invoke.outValue().replaceUsers(inValue, affectedValues);
            }
            instructionIterator.removeOrReplaceByDebugLocalRead();
        } else if (inValue.isAlwaysNull(this.appView)) {
            if (singleTarget.getReference() == this.objectsMethods.requireNonNull) {
                if (this.appView.hasClassHierarchy()) {
                    instructionIterator.replaceCurrentInstructionWithThrowNull(this.appView.withClassHierarchy(), code, blockIterator, blocksToRemove, affectedValues);
                }
            } else if (singleTarget.getReference() == this.objectsMethods.requireNonNullElse) {
                if (invoke.getLastArgument().isNeverNull()) {
                    if (invoke.hasOutValue()) {
                        invoke.outValue().replaceUsers(invoke.getLastArgument(), affectedValues);
                    }
                    instructionIterator.removeOrReplaceByDebugLocalRead();
                }
            } else if (singleTarget.getReference() == this.objectsMethods.requireNonNullElseGet) {
                // empty if block
            }
        }
    }

    private void optimizeToStringWithObject(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke, Set<Value> affectedValues, DexClassAndMethod singleTarget) {
        Value object = invoke.getFirstArgument();
        TypeElement type = object.getType();
        if (type.isDefinitelyNull()) {
            if (singleTarget.getReference() == this.objectsMethods.toStringWithObject) {
                if (invoke.hasOutValue()) {
                    affectedValues.addAll(invoke.outValue().affectedValues());
                }
                instructionIterator.replaceCurrentInstructionWithConstString(this.appView, code, "null");
            } else {
                assert (singleTarget.getReference() == this.objectsMethods.toStringWithObjectAndNullDefault);
                if (invoke.hasOutValue()) {
                    invoke.outValue().replaceUsers(invoke.getLastArgument(), affectedValues);
                }
                instructionIterator.removeOrReplaceByDebugLocalRead();
            }
            return;
        }
        if (type.isDefinitelyNotNull() && type.isStringType(this.dexItemFactory)) {
            if (invoke.hasOutValue()) {
                affectedValues.addAll(invoke.outValue().affectedValues());
                invoke.outValue().replaceUsers(object);
            }
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    @Override
    public DexType getType() {
        return this.dexItemFactory.objectsType;
    }

    @Override
    public void optimize(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, DexClassAndMethod singleTarget, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove) {
        DexMethod singleTargetReference = (DexMethod)singleTarget.getReference();
        switch (singleTargetReference.getName().byteAt(0)) {
            case 101: {
                if (singleTargetReference != this.objectsMethods.equals) break;
                this.optimizeEquals(code, instructionIterator, invoke);
                break;
            }
            case 104: {
                if (singleTargetReference != this.objectsMethods.hashCode) break;
                this.optimizeHashCode(code, instructionIterator, invoke);
                break;
            }
            case 105: {
                if (singleTargetReference != this.objectsMethods.isNull) break;
                this.optimizeIsNull(code, instructionIterator, invoke);
                break;
            }
            case 110: {
                if (singleTargetReference != this.objectsMethods.nonNull) break;
                this.optimizeNonNull(code, instructionIterator, invoke);
                break;
            }
            case 114: {
                if (!this.objectsMethods.isRequireNonNullMethod(singleTargetReference)) break;
                this.optimizeRequireNonNull(code, blockIterator, instructionIterator, invoke, affectedValues, blocksToRemove, singleTarget);
                break;
            }
            case 116: {
                if (!this.objectsMethods.isToStringMethod(singleTargetReference)) break;
                this.optimizeToStringWithObject(code, instructionIterator, invoke, affectedValues, singleTarget);
                break;
            }
        }
    }
}

