/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.library.StatelessLibraryMethodModelCollection;
import java.util.Set;

public class StringMethodOptimizer
extends StatelessLibraryMethodModelCollection {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;

    StringMethodOptimizer(AppView<?> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private void optimizeEquals(IRCode code, InstructionListIterator instructionIterator, InvokeVirtual invoke) {
        if (((AppInfo)this.appView.appInfo()).hasLiveness()) {
            Value second;
            ProgramMethod context = code.context();
            Value first = invoke.getReceiver().getAliasedValue();
            if (this.isPrunedClassNameComparison(first, second = invoke.getArgument(1).getAliasedValue(), context) || this.isPrunedClassNameComparison(second, first, context)) {
                instructionIterator.replaceCurrentInstructionWithConstInt(code, 0);
            }
        }
    }

    private void optimizeValueOf(IRCode code, InstructionListIterator instructionIterator, InvokeStatic invoke, Set<Value> affectedValues) {
        Value object = invoke.getFirstArgument();
        TypeElement type = object.getType();
        if (type.isDefinitelyNull()) {
            instructionIterator.replaceCurrentInstructionWithConstString(this.appView, code, "null");
            if (invoke.hasOutValue()) {
                affectedValues.addAll(invoke.outValue().affectedValues());
            }
            return;
        }
        if (type.isDefinitelyNotNull() && type.isStringType(this.dexItemFactory)) {
            if (invoke.hasOutValue()) {
                affectedValues.addAll(invoke.outValue().affectedValues());
                invoke.outValue().replaceUsers(object);
            }
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    private boolean isPrunedClassNameComparison(Value classNameValue, Value constStringValue, ProgramMethod context) {
        if (classNameValue.isPhi() || constStringValue.isPhi()) {
            return false;
        }
        Instruction classNameDefinition = classNameValue.definition;
        if (!classNameDefinition.isInvokeVirtual()) {
            return false;
        }
        DexClassAndMethod singleTarget = classNameDefinition.asInvokeVirtual().lookupSingleTarget(this.appView, context);
        if (singleTarget == null || singleTarget.getReference() != this.dexItemFactory.classMethods.getName) {
            return false;
        }
        if (!constStringValue.definition.isDexItemBasedConstString()) {
            return false;
        }
        DexItemBasedConstString constString = constStringValue.definition.asDexItemBasedConstString();
        DexReference reference = constString.getItem();
        return reference.isDexType() && ((AppInfo)this.appView.appInfo()).withLiveness().wasPruned(reference.asDexType()) && !constString.getNameComputationInfo().needsToComputeName();
    }

    @Override
    public DexType getType() {
        return this.dexItemFactory.stringType;
    }

    @Override
    public void optimize(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, DexClassAndMethod singleTarget, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove) {
        DexMethod singleTargetReference = (DexMethod)singleTarget.getReference();
        if (singleTargetReference == this.dexItemFactory.stringMembers.equals) {
            this.optimizeEquals(code, instructionIterator, invoke.asInvokeVirtual());
        } else if (singleTargetReference == this.dexItemFactory.stringMembers.valueOf) {
            this.optimizeValueOf(code, instructionIterator, invoke.asInvokeStatic(), affectedValues);
        }
    }
}

