/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.membervaluepropagation.assume;

import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;

public class AssumeInfo {
    private final AssumeType type;
    private final ProguardMemberRule rule;

    public AssumeInfo(AssumeType type, ProguardMemberRule rule) {
        this.type = type;
        this.rule = rule;
    }

    public boolean hasReturnInfo() {
        return this.rule.hasReturnValue();
    }

    public ProguardMemberRuleReturnValue getReturnInfo() {
        return this.rule.getReturnValue();
    }

    public boolean isAssumeNoSideEffects() {
        return this.type == AssumeType.ASSUME_NO_SIDE_EFFECTS;
    }

    public boolean isAssumeValues() {
        return this.type == AssumeType.ASSUME_VALUES;
    }

    public AssumeInfo meet(AssumeInfo lookup) {
        return new AssumeInfo(this.type.meet(lookup.type), this.rule.hasReturnValue() ? this.rule : lookup.rule);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AssumeInfo)) {
            return false;
        }
        AssumeInfo assumeInfo = (AssumeInfo)other;
        return this.type == assumeInfo.type && this.rule == assumeInfo.rule;
    }

    public int hashCode() {
        return this.type.ordinal() * 31 + this.rule.hashCode();
    }

    public static enum AssumeType {
        ASSUME_NO_SIDE_EFFECTS,
        ASSUME_VALUES;


        AssumeType meet(AssumeType type) {
            return this == ASSUME_NO_SIDE_EFFECTS || type == ASSUME_NO_SIDE_EFFECTS ? ASSUME_NO_SIDE_EFFECTS : ASSUME_VALUES;
        }
    }
}

