/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.outliner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.optimize.OutlinerImpl;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class OutlineCollection {
    private final Map<OutlinerImpl.Outline, OutlinerImpl.Outline> canonicalization = new ConcurrentHashMap<OutlinerImpl.Outline, OutlinerImpl.Outline>();
    private GraphLens appliedGraphLens;
    private Map<DexMethod, List<OutlinerImpl.Outline>> outlines = new ConcurrentHashMap<DexMethod, List<OutlinerImpl.Outline>>();

    public OutlineCollection(GraphLens graphLensForPrimaryOptimizationPass) {
        this.appliedGraphLens = graphLensForPrimaryOptimizationPass;
    }

    private List<OutlinerImpl.Outline> rewriteOutlinesWithLens(List<OutlinerImpl.Outline> outlines, GraphLens currentGraphLens) {
        assert (currentGraphLens != this.appliedGraphLens);
        return ListUtils.mapOrElse(outlines, outline -> outline.rewrittenWithLens(currentGraphLens));
    }

    private Map<OutlinerImpl.Outline, List<ProgramMethod>> computeMethodsPerOutline(AppView<AppInfoWithLiveness> appView) {
        HashMap<OutlinerImpl.Outline, List<ProgramMethod>> methodsPerOutline = new HashMap<OutlinerImpl.Outline, List<ProgramMethod>>();
        this.outlines.forEach((reference, outlinesForMethod) -> {
            DexProgramClass holder;
            DexMethod rewrittenReference = appView.graphLens().getRenamedMethodSignature((DexMethod)reference, this.appliedGraphLens);
            ProgramMethod method = rewrittenReference.lookupOnProgramClass(holder = DexProgramClass.asProgramClassOrNull(appView.definitionFor(rewrittenReference.getHolderType())));
            if (method == null) {
                assert (false);
                return;
            }
            assert (!method.getOptimizationInfo().hasBeenInlinedIntoSingleCallSite());
            for (OutlinerImpl.Outline outline : outlinesForMethod) {
                ((List)methodsPerOutline.computeIfAbsent(outline, MapUtils.ignoreKey(ArrayList::new))).add(method);
            }
        });
        return methodsPerOutline;
    }

    private List<OutlinerImpl.Outline> canonicalize(List<OutlinerImpl.Outline> outlines) {
        ArrayList<OutlinerImpl.Outline> canonicalizedOutlines = new ArrayList<OutlinerImpl.Outline>(outlines.size());
        for (OutlinerImpl.Outline outline : outlines) {
            canonicalizedOutlines.add(this.canonicalize(outline));
        }
        return canonicalizedOutlines;
    }

    private OutlinerImpl.Outline canonicalize(OutlinerImpl.Outline outline) {
        return this.canonicalization.computeIfAbsent(outline, Function.identity());
    }

    public void remove(AppView<AppInfoWithLiveness> appView, ProgramMethod method) {
        assert (appView.graphLens() == this.appliedGraphLens);
        this.outlines.remove(method.getReference());
    }

    public void set(AppView<AppInfoWithLiveness> appView, ProgramMethod method, List<OutlinerImpl.Outline> outlinesForMethod) {
        assert (appView.graphLens() == this.appliedGraphLens);
        if (outlinesForMethod.isEmpty()) {
            this.outlines.remove(method.getReference());
        } else {
            this.outlines.put((DexMethod)method.getReference(), this.canonicalize(outlinesForMethod));
        }
    }

    public void rewriteWithLens(GraphLens currentGraphLens) {
        if (currentGraphLens == this.appliedGraphLens) {
            return;
        }
        ConcurrentHashMap<DexMethod, List<OutlinerImpl.Outline>> rewrittenOutlines = new ConcurrentHashMap<DexMethod, List<OutlinerImpl.Outline>>(this.outlines.size());
        this.outlines.forEach((method, outlinesForMethod) -> {
            DexMethod rewrittenMethod = currentGraphLens.getRenamedMethodSignature((DexMethod)method, this.appliedGraphLens);
            assert (!rewrittenOutlines.containsKey(rewrittenMethod));
            List<OutlinerImpl.Outline> rewrittenOutlinesForMethod = this.rewriteOutlinesWithLens((List<OutlinerImpl.Outline>)outlinesForMethod, currentGraphLens);
            if (!rewrittenOutlinesForMethod.isEmpty()) {
                rewrittenOutlines.put(rewrittenMethod, rewrittenOutlinesForMethod);
            }
        });
        this.outlines = rewrittenOutlines;
        this.appliedGraphLens = currentGraphLens;
    }

    public ProgramMethodSet computeMethodsSubjectToOutlining(AppView<AppInfoWithLiveness> appView) {
        ProgramMethodSet result = ProgramMethodSet.create();
        Map<OutlinerImpl.Outline, List<ProgramMethod>> methodsPerOutline = this.computeMethodsPerOutline(appView);
        for (List<ProgramMethod> methodsWithSameOutline : methodsPerOutline.values()) {
            if (methodsWithSameOutline.size() < appView.options().outline.threshold) continue;
            result.addAll(methodsWithSameOutline);
        }
        return result;
    }
}

