/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.string;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.AbstractState;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.AbstractTransferFunction;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.DataflowAnalysisResult;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.FailedTransferFunctionResult;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.IntraproceduralDataflowAnalysis;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.TransferFunctionResult;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.string.StringBuilderOptimizationConfiguration;
import com.android.tools.r8.utils.SetUtils;
import java.util.Set;

class StringBuilderAppendFlowAnalysis {
    StringBuilderAppendFlowAnalysis() {
    }

    static boolean hasAppendInstructionInLoop(Value builder, StringBuilderOptimizationConfiguration configuration) {
        IntraproceduralDataflowAnalysis<AbstractStateImpl> analysis = new IntraproceduralDataflowAnalysis<AbstractStateImpl>(AbstractStateImpl.bottom(), new TransferFunction(builder, configuration));
        DataflowAnalysisResult result = analysis.run(builder.definition.getBlock());
        return result.isFailedAnalysisResult();
    }

    private static class TransferFunction
    implements AbstractTransferFunction<AbstractStateImpl> {
        private final Value builder;
        private final StringBuilderOptimizationConfiguration configuration;

        private TransferFunction(Value builder, StringBuilderOptimizationConfiguration configuration) {
            this.builder = builder;
            this.configuration = configuration;
        }

        private TransferFunctionResult<AbstractStateImpl> apply(AbstractStateImpl state, InvokeMethod invoke) {
            if (this.isAppendOnBuilder(invoke)) {
                assert (invoke.isInvokeVirtual());
                InvokeVirtual appendInvoke = invoke.asInvokeVirtual();
                if (state.isAppendInstructionLive(appendInvoke)) {
                    return new FailedTransferFunctionResult<AbstractStateImpl>();
                }
                return state.addLiveAppendInstruction(appendInvoke);
            }
            if (this.isToStringOnBuilder(invoke)) {
                return AbstractStateImpl.bottom();
            }
            return state;
        }

        private boolean isAppendOnBuilder(InvokeMethod invoke) {
            DexMethod invokedMethod = invoke.getInvokedMethod();
            return this.configuration.isAppendMethod(invokedMethod) && invoke.getArgument(0).getAliasedValue() == this.builder;
        }

        private boolean isToStringOnBuilder(InvokeMethod invoke) {
            DexMethod invokedMethod = invoke.getInvokedMethod();
            return this.configuration.isToStringMethod(invokedMethod) && invoke.getArgument(0).getAliasedValue() == this.builder;
        }

        @Override
        public TransferFunctionResult<AbstractStateImpl> apply(Instruction instruction, AbstractStateImpl state) {
            if (instruction.isInvokeMethod()) {
                return this.apply(state, instruction.asInvokeMethod());
            }
            return state;
        }
    }

    private static class AbstractStateImpl
    extends AbstractState<AbstractStateImpl> {
        private static final AbstractStateImpl BOTTOM = new AbstractStateImpl();
        private final Set<InvokeVirtual> liveAppendInstructions;

        private AbstractStateImpl() {
            this(Sets.newIdentityHashSet());
        }

        private AbstractStateImpl(Set<InvokeVirtual> liveAppendInstructions) {
            this.liveAppendInstructions = liveAppendInstructions;
        }

        public static AbstractStateImpl bottom() {
            return BOTTOM;
        }

        private AbstractStateImpl addLiveAppendInstruction(InvokeVirtual invoke) {
            Set<InvokeVirtual> newLiveAppendInstructions = SetUtils.newIdentityHashSet(this.liveAppendInstructions);
            newLiveAppendInstructions.add(invoke);
            return new AbstractStateImpl(newLiveAppendInstructions);
        }

        private boolean isAppendInstructionLive(InvokeVirtual invoke) {
            return this.liveAppendInstructions.contains(invoke);
        }

        @Override
        public AbstractStateImpl asAbstractState() {
            return this;
        }

        @Override
        public AbstractStateImpl join(AbstractStateImpl state) {
            if (this.liveAppendInstructions.isEmpty()) {
                return state;
            }
            if (state.liveAppendInstructions.isEmpty()) {
                return this;
            }
            Set<InvokeVirtual> newLiveAppendInstructions = SetUtils.newIdentityHashSet(this.liveAppendInstructions, state.liveAppendInstructions);
            return new AbstractStateImpl(newLiveAppendInstructions);
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            AbstractStateImpl state = (AbstractStateImpl)other;
            return this.liveAppendInstructions.equals(state.liveAppendInstructions);
        }

        @Override
        public int hashCode() {
            return this.liveAppendInstructions.hashCode();
        }
    }
}

