/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.synthetic;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.synthetic.SyntheticSourceCode;
import com.android.tools.r8.utils.BooleanUtils;
import java.util.ArrayList;

public final class ForwardMethodSourceCode
extends SyntheticSourceCode {
    private final DexType targetReceiver;
    private final DexMethod target;
    private final Invoke.Type invokeType;
    private final boolean castResult;
    private final boolean isInterface;
    private final boolean extraNullParameter;

    public static Builder builder(DexMethod method) {
        return new Builder(method);
    }

    protected ForwardMethodSourceCode(DexType receiver, DexMethod method, DexMethod originalMethod, DexType targetReceiver, DexMethod target, Invoke.Type invokeType, Position callerPosition, boolean isInterface, boolean castResult, boolean extraNullParameter) {
        super(receiver, method, callerPosition, originalMethod);
        assert (targetReceiver == null == (invokeType == Invoke.Type.STATIC));
        this.target = target;
        this.targetReceiver = targetReceiver;
        this.invokeType = invokeType;
        this.isInterface = isInterface;
        this.castResult = castResult;
        this.extraNullParameter = extraNullParameter;
        assert (this.checkSignatures());
        switch (invokeType) {
            case DIRECT: 
            case STATIC: 
            case SUPER: 
            case INTERFACE: 
            case VIRTUAL: {
                break;
            }
            default: {
                throw new Unimplemented("Invoke type " + (Object)((Object)invokeType) + " is not yet supported.");
            }
        }
    }

    private boolean checkSignatures() {
        ArrayList<DexType> sourceParams = new ArrayList<DexType>();
        if (this.receiver != null) {
            sourceParams.add(this.receiver);
        }
        sourceParams.addAll(Lists.newArrayList(this.proto.parameters.values));
        if (this.extraNullParameter) {
            sourceParams.remove(sourceParams.size() - 1);
        }
        ArrayList<DexType> targetParams = new ArrayList<DexType>();
        if (this.targetReceiver != null) {
            targetParams.add(this.targetReceiver);
        }
        targetParams.addAll(Lists.newArrayList(this.target.proto.parameters.values));
        assert (sourceParams.size() == targetParams.size());
        for (int i = 0; i < sourceParams.size(); ++i) {
            DexType source = (DexType)sourceParams.get(i);
            DexType target = (DexType)targetParams.get(i);
            assert (source.isClassType() && target.isClassType() || source == target);
        }
        assert (this.proto.returnType == this.target.proto.returnType || this.castResult);
        return true;
    }

    @Override
    protected void prepareInstructions() {
        ArrayList<ValueType> argValueTypes = new ArrayList<ValueType>();
        ArrayList<Integer> argRegisters = new ArrayList<Integer>();
        if (this.receiver != null) {
            argValueTypes.add(ValueType.OBJECT);
            argRegisters.add(this.getReceiverRegister());
        }
        DexType[] accessorParams = this.proto.parameters.values;
        for (int i = 0; i < accessorParams.length - BooleanUtils.intValue(this.extraNullParameter); ++i) {
            argValueTypes.add(ValueType.fromDexType(accessorParams[i]));
            argRegisters.add(this.getParamRegister(i));
        }
        this.add(builder -> builder.addInvoke(this.invokeType, this.target, this.target.proto, argValueTypes, argRegisters, this.isInterface));
        if (this.proto.returnType.isVoidType()) {
            this.add(IRBuilder::addReturn);
        } else {
            ValueType valueType = ValueType.fromDexType(this.proto.returnType);
            int tempValue = this.nextRegister(valueType);
            this.add(builder -> builder.addMoveResult(tempValue));
            if (this.proto.returnType != this.target.proto.returnType) {
                this.add(builder -> builder.addCheckCast(tempValue, this.proto.returnType));
            }
            this.add(builder -> builder.addReturn(tempValue));
        }
    }

    public static class Builder {
        private DexType receiver;
        private DexMethod method;
        private DexMethod originalMethod;
        private DexType targetReceiver;
        private DexMethod target;
        private Invoke.Type invokeType;
        private boolean castResult;
        private boolean isInterface;
        private boolean extraNullParameter;

        public Builder(DexMethod method) {
            this.method = method;
            this.originalMethod = method;
        }

        public Builder setReceiver(DexType receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder setMethod(DexMethod method) {
            this.method = method;
            return this;
        }

        public Builder setOriginalMethod(DexMethod originalMethod) {
            this.originalMethod = originalMethod;
            return this;
        }

        public Builder setTargetReceiver(DexType targetReceiver) {
            this.targetReceiver = targetReceiver;
            return this;
        }

        public Builder setTarget(DexMethod target) {
            this.target = target;
            return this;
        }

        public Builder setInvokeType(Invoke.Type invokeType) {
            this.invokeType = invokeType;
            return this;
        }

        public Builder setCastResult() {
            this.castResult = true;
            return this;
        }

        public Builder setIsInterface(boolean isInterface) {
            this.isInterface = isInterface;
            return this;
        }

        public Builder setExtraNullParameter() {
            this.extraNullParameter = true;
            return this;
        }

        public ForwardMethodSourceCode build(ProgramMethod context, Position callerPosition) {
            return new ForwardMethodSourceCode(this.receiver, this.method, this.originalMethod, this.targetReceiver, this.target, this.invokeType, callerPosition, this.isInterface, this.castResult, this.extraNullParameter);
        }
    }
}

