/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.it.unimi.dsi.fastutil.floats;

import com.android.tools.r8.it.unimi.dsi.fastutil.HashCommon;
import com.android.tools.r8.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.floats.AbstractFloat2DoubleFunction;
import com.android.tools.r8.it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.floats.Float2DoubleMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.floats.FloatIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.floats.FloatSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractFloat2DoubleMap
extends AbstractFloat2DoubleFunction
implements Float2DoubleMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractFloat2DoubleMap() {
    }

    @Override
    public boolean containsValue(double v) {
        return this.values().contains(v);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object ov) {
        if (ov == null) {
            return false;
        }
        return this.containsValue((Double)ov);
    }

    @Override
    public boolean containsKey(float k) {
        ObjectIterator<Float2DoubleMap.Entry> i = this.float2DoubleEntrySet().iterator();
        while (i.hasNext()) {
            if (((Float2DoubleMap.Entry)i.next()).getFloatKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Double> m3) {
        int n = m3.size();
        Iterator<Map.Entry<? extends Float, ? extends Double>> i = m3.entrySet().iterator();
        if (m3 instanceof Float2DoubleMap) {
            while (n-- != 0) {
                Float2DoubleMap.Entry e = (Float2DoubleMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getDoubleValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Float, ? extends Double> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            @Override
            public boolean contains(float k) {
                return AbstractFloat2DoubleMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractFloat2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2DoubleMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new AbstractFloatIterator(){
                    final ObjectIterator<Map.Entry<Float, Double>> i;
                    {
                        this.i = AbstractFloat2DoubleMap.this.entrySet().iterator();
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2DoubleMap.Entry)this.i.next()).getFloatKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            @Override
            public boolean contains(double k) {
                return AbstractFloat2DoubleMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractFloat2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2DoubleMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new AbstractDoubleIterator(){
                    final ObjectIterator<Map.Entry<Float, Double>> i;
                    {
                        this.i = AbstractFloat2DoubleMap.this.entrySet().iterator();
                    }

                    @Override
                    @Deprecated
                    public double nextDouble() {
                        return ((Float2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    @Deprecated
    public ObjectSet<Map.Entry<Float, Double>> entrySet() {
        return this.float2DoubleEntrySet();
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h2 += ((Map.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Float2DoubleMap.Entry e = (Float2DoubleMap.Entry)i.next();
            s2.append(String.valueOf(e.getFloatKey()));
            s2.append("=>");
            s2.append(String.valueOf(e.getDoubleValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static class BasicEntry
    implements Float2DoubleMap.Entry {
        protected float key;
        protected double value;

        public BasicEntry(Float key, Double value) {
            this.key = key.floatValue();
            this.value = value;
        }

        public BasicEntry(float key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @Deprecated
        public Float getKey() {
            return Float.valueOf(this.key);
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        @Deprecated
        public Double getValue() {
            return this.value;
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double setValue(Double value) {
            return this.setValue((double)value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Float)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Double)) {
                return false;
            }
            return Float.floatToIntBits(this.key) == Float.floatToIntBits(((Float)e.getKey()).floatValue()) && this.value == (Double)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(this.key) ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

