/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmAnnotation;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmAnnotationArgument;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinAnnotationArgumentInfo;
import com.android.tools.r8.kotlin.KotlinTypeReference;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KotlinAnnotationInfo
implements EnqueuerMetadataTraceable {
    private static final List<KotlinAnnotationInfo> EMPTY_ANNOTATIONS = ImmutableList.of();
    private final KotlinTypeReference annotationType;
    private final Map<String, KotlinAnnotationArgumentInfo> arguments;

    private KotlinAnnotationInfo(KotlinTypeReference annotationType, Map<String, KotlinAnnotationArgumentInfo> arguments) {
        this.annotationType = annotationType;
        this.arguments = arguments;
    }

    static KotlinAnnotationInfo create(KmAnnotation annotation, DexItemFactory factory) {
        return new KotlinAnnotationInfo(KotlinTypeReference.fromBinaryName(annotation.getClassName(), factory, annotation.getClassName()), KotlinAnnotationArgumentInfo.create(annotation.getArguments(), factory));
    }

    static List<KotlinAnnotationInfo> create(List<KmAnnotation> annotations, DexItemFactory factory) {
        if (annotations.isEmpty()) {
            return EMPTY_ANNOTATIONS;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmAnnotation annotation : annotations) {
            builder.add(KotlinAnnotationInfo.create(annotation, factory));
        }
        return builder.build();
    }

    boolean rewrite(KmVisitorProviders.KmAnnotationVisitorProvider visitorProvider, AppView<?> appView, NamingLens namingLens) {
        BooleanBox rewritten = new BooleanBox(false);
        rewritten.or(this.annotationType.toRenamedDescriptorOrDefault(renamedDescriptor -> {
            if (renamedDescriptor == null) {
                rewritten.set(true);
                return;
            }
            String classifier = DescriptorUtils.descriptorToKotlinClassifier(renamedDescriptor);
            LinkedHashMap rewrittenArguments = new LinkedHashMap();
            this.arguments.forEach((key, arg) -> rewritten.or(arg.rewrite((KmAnnotationArgument rewrittenArg) -> {
                if (rewrittenArg != null) {
                    rewrittenArguments.put(key, rewrittenArg);
                }
            }, appView, namingLens)));
            visitorProvider.get(new KmAnnotation(classifier, rewrittenArguments));
        }, appView, namingLens, null));
        return rewritten.get();
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        this.annotationType.trace(definitionSupplier);
        this.arguments.forEach((ignored, arg) -> arg.trace(definitionSupplier));
    }
}

