/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmClass;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmType;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmClassExtensionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.kotlin.KotlinCompanionInfo;
import com.android.tools.r8.kotlin.KotlinConstructorInfo;
import com.android.tools.r8.kotlin.KotlinDeclarationContainerInfo;
import com.android.tools.r8.kotlin.KotlinJvmSignatureExtensionInformation;
import com.android.tools.r8.kotlin.KotlinLocalDelegatedPropertyInfo;
import com.android.tools.r8.kotlin.KotlinMetadataDiagnostic;
import com.android.tools.r8.kotlin.KotlinMetadataMembersTracker;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.kotlin.KotlinTypeInfo;
import com.android.tools.r8.kotlin.KotlinTypeParameterInfo;
import com.android.tools.r8.kotlin.KotlinTypeReference;
import com.android.tools.r8.kotlin.KotlinVersionRequirementInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.Reporter;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class KotlinClassInfo
implements KotlinClassLevelInfo {
    private final int flags;
    private final String name;
    private final boolean nameCanBeSynthesizedFromClassOrAnonymousObjectOrigin;
    private final String moduleName;
    private final List<KotlinConstructorInfo> constructorsWithNoBacking;
    private final KotlinDeclarationContainerInfo declarationContainerInfo;
    private final List<KotlinTypeParameterInfo> typeParameters;
    private final List<KotlinTypeInfo> superTypes;
    private final List<KotlinTypeReference> sealedSubClasses;
    private final List<KotlinTypeReference> nestedClasses;
    private final List<String> enumEntries;
    private final KotlinVersionRequirementInfo versionRequirements;
    private final KotlinTypeReference anonymousObjectOrigin;
    private final String packageName;
    private final KotlinLocalDelegatedPropertyInfo localDelegatedProperties;
    private final int[] metadataVersion;
    private final String inlineClassUnderlyingPropertyName;
    private final KotlinTypeInfo inlineClassUnderlyingType;
    private final int jvmFlags;
    private final KotlinMetadataMembersTracker originalMembersWithKotlinInfo;

    private KotlinClassInfo(int flags, String name, boolean nameCanBeSynthesizedFromClassOrAnonymousObjectOrigin, String moduleName, KotlinDeclarationContainerInfo declarationContainerInfo, List<KotlinTypeParameterInfo> typeParameters, List<KotlinConstructorInfo> constructorsWithNoBacking, List<KotlinTypeInfo> superTypes, List<KotlinTypeReference> sealedSubClasses, List<KotlinTypeReference> nestedClasses, List<String> enumEntries, KotlinVersionRequirementInfo versionRequirements, KotlinTypeReference anonymousObjectOrigin, String packageName, KotlinLocalDelegatedPropertyInfo localDelegatedProperties, int[] metadataVersion, String inlineClassUnderlyingPropertyName, KotlinTypeInfo inlineClassUnderlyingType, KotlinMetadataMembersTracker originalMembersWithKotlinInfo, int jvmFlags) {
        this.flags = flags;
        this.name = name;
        this.nameCanBeSynthesizedFromClassOrAnonymousObjectOrigin = nameCanBeSynthesizedFromClassOrAnonymousObjectOrigin;
        this.moduleName = moduleName;
        this.declarationContainerInfo = declarationContainerInfo;
        this.typeParameters = typeParameters;
        this.constructorsWithNoBacking = constructorsWithNoBacking;
        this.superTypes = superTypes;
        this.sealedSubClasses = sealedSubClasses;
        this.nestedClasses = nestedClasses;
        this.enumEntries = enumEntries;
        this.versionRequirements = versionRequirements;
        this.anonymousObjectOrigin = anonymousObjectOrigin;
        this.packageName = packageName;
        this.localDelegatedProperties = localDelegatedProperties;
        this.metadataVersion = metadataVersion;
        this.inlineClassUnderlyingPropertyName = inlineClassUnderlyingPropertyName;
        this.inlineClassUnderlyingType = inlineClassUnderlyingType;
        this.originalMembersWithKotlinInfo = originalMembersWithKotlinInfo;
        this.jvmFlags = jvmFlags;
    }

    public static KotlinClassInfo create(KotlinClassMetadata.Class metadata, String packageName, int[] metadataVersion, DexClass hostClass, AppView<?> appView, Consumer<DexEncodedMethod> keepByteCode) {
        DexItemFactory factory = appView.dexItemFactory();
        Reporter reporter = appView.reporter();
        KmClass kmClass = metadata.toKmClass();
        KotlinJvmSignatureExtensionInformation extensionInformation = KotlinJvmSignatureExtensionInformation.readInformationFromMessage(metadata, appView.options());
        HashMap<String, DexEncodedField> fieldMap = new HashMap<String, DexEncodedField>();
        for (DexEncodedField dexEncodedField : hostClass.fields()) {
            fieldMap.put(KotlinMetadataUtils.toJvmFieldSignature((DexField)dexEncodedField.getReference()).asString(), dexEncodedField);
        }
        HashMap<String, DexEncodedMethod> methodMap = new HashMap<String, DexEncodedMethod>();
        for (DexEncodedMethod method : hostClass.methods()) {
            methodMap.put(KotlinMetadataUtils.toJvmMethodSignature((DexMethod)method.getReference()).asString(), method);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int constructorIndex = 0;
        KotlinMetadataMembersTracker originalMembersWithKotlinInfo = new KotlinMetadataMembersTracker(appView);
        for (KmConstructor kmConstructor : kmClass.getConstructors()) {
            DexEncodedMethod method;
            boolean readConstructorSignature = extensionInformation.hasJvmMethodSignatureExtensionForConstructor(constructorIndex++);
            KotlinConstructorInfo constructorInfo = KotlinConstructorInfo.create(kmConstructor, factory, reporter, readConstructorSignature);
            JvmMethodSignature signature = JvmExtensionsKt.getSignature(kmConstructor);
            if (signature != null && (method = (DexEncodedMethod)methodMap.get(signature.asString())) != null) {
                method.setKotlinMemberInfo(constructorInfo);
                originalMembersWithKotlinInfo.add((DexMember<?, ?>)method.getReference());
                continue;
            }
            builder.add(constructorInfo);
        }
        KotlinDeclarationContainerInfo container = KotlinDeclarationContainerInfo.create(kmClass, methodMap, fieldMap, factory, reporter, keepByteCode, extensionInformation, originalMembersWithKotlinInfo);
        KotlinClassInfo.setCompanionObject(kmClass, hostClass, reporter);
        KotlinTypeReference anonymousObjectOrigin = KotlinClassInfo.getAnonymousObjectOrigin(kmClass, factory);
        boolean nameCanBeDeducedFromClassOrOrigin = kmClass.name.equals(KotlinMetadataUtils.getKotlinClassName(hostClass, hostClass.getType().toDescriptorString())) || anonymousObjectOrigin != null && kmClass.name.equals(anonymousObjectOrigin.toKotlinClassifier(true));
        return new KotlinClassInfo(kmClass.getFlags(), kmClass.name, nameCanBeDeducedFromClassOrOrigin, JvmExtensionsKt.getModuleName(kmClass), container, KotlinTypeParameterInfo.create(kmClass.getTypeParameters(), factory, reporter), (List<KotlinConstructorInfo>)((Object)builder.build()), KotlinClassInfo.getSuperTypes(kmClass.getSupertypes(), factory, reporter), KotlinClassInfo.getSealedSubClasses(kmClass.getSealedSubclasses(), factory), KotlinClassInfo.getNestedClasses(hostClass, kmClass.getNestedClasses(), factory), kmClass.getEnumEntries(), KotlinVersionRequirementInfo.create(kmClass.getVersionRequirements()), anonymousObjectOrigin, packageName, KotlinLocalDelegatedPropertyInfo.create(JvmExtensionsKt.getLocalDelegatedProperties(kmClass), factory, reporter), metadataVersion, kmClass.getInlineClassUnderlyingPropertyName(), KotlinTypeInfo.create(kmClass.getInlineClassUnderlyingType(), factory, reporter), originalMembersWithKotlinInfo, JvmExtensionsKt.getJvmFlags(kmClass));
    }

    private static KotlinTypeReference getAnonymousObjectOrigin(KmClass kmClass, DexItemFactory factory) {
        String anonymousObjectOriginName = JvmExtensionsKt.getAnonymousObjectOriginName(kmClass);
        if (anonymousObjectOriginName != null) {
            return KotlinTypeReference.fromBinaryName(anonymousObjectOriginName, factory, anonymousObjectOriginName);
        }
        return null;
    }

    private static List<KotlinTypeReference> getNestedClasses(DexClass clazz, List<String> nestedClasses, DexItemFactory factory) {
        ImmutableList.Builder nestedTypes = ImmutableList.builder();
        for (String nestedClass : nestedClasses) {
            String binaryName = clazz.type.toBinaryName() + '$' + nestedClass;
            nestedTypes.add(KotlinTypeReference.fromBinaryName(binaryName, factory, nestedClass));
        }
        return nestedTypes.build();
    }

    private static List<KotlinTypeReference> getSealedSubClasses(List<String> sealedSubclasses, DexItemFactory factory) {
        ImmutableList.Builder sealedTypes = ImmutableList.builder();
        for (String sealedSubClass : sealedSubclasses) {
            String binaryName = sealedSubClass.replace('.', '$');
            sealedTypes.add(KotlinTypeReference.fromBinaryName(binaryName, factory, sealedSubClass));
        }
        return sealedTypes.build();
    }

    private static List<KotlinTypeInfo> getSuperTypes(List<KmType> superTypes, DexItemFactory factory, Reporter reporter) {
        ImmutableList.Builder superTypeInfos = ImmutableList.builder();
        for (KmType superType : superTypes) {
            superTypeInfos.add(KotlinTypeInfo.create(superType, factory, reporter));
        }
        return superTypeInfos.build();
    }

    private static void setCompanionObject(KmClass kmClass, DexClass hostClass, Reporter reporter) {
        String companionObjectName = kmClass.getCompanionObject();
        if (companionObjectName == null) {
            return;
        }
        for (DexEncodedField field : hostClass.fields()) {
            if (!((DexField)field.getReference()).name.toString().equals(companionObjectName)) continue;
            field.setKotlinMemberInfo(new KotlinCompanionInfo(companionObjectName));
            return;
        }
        reporter.warning(KotlinMetadataDiagnostic.missingCompanionObject(hostClass, companionObjectName));
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public KotlinClassInfo asClass() {
        return this;
    }

    @Override
    public Pair<KotlinClassHeader, Boolean> rewrite(DexClass clazz, AppView<?> appView, NamingLens namingLens) {
        boolean rewritten;
        KmClass kmClass = new KmClass();
        kmClass.setFlags(this.flags);
        DexString originalDescriptor = clazz.type.descriptor;
        DexString rewrittenDescriptor = namingLens.lookupDescriptor(clazz.type);
        boolean bl = rewritten = !originalDescriptor.equals(rewrittenDescriptor);
        if (!this.nameCanBeSynthesizedFromClassOrAnonymousObjectOrigin) {
            kmClass.setName(this.name);
        } else {
            Object rewrittenName = null;
            if (this.anonymousObjectOrigin != null && this.name.equals(this.anonymousObjectOrigin.toKotlinClassifier(true))) {
                Box box = new Box();
                this.anonymousObjectOrigin.toRenamedBinaryNameOrDefault(box::set, appView, namingLens, null);
                if (box.isSet()) {
                    rewrittenName = "." + (String)box.get();
                }
            }
            if (rewrittenName == null) {
                rewrittenName = KotlinMetadataUtils.getKotlinClassName(clazz, rewrittenDescriptor.toString());
            }
            kmClass.setName((String)rewrittenName);
            rewritten |= !this.name.equals(rewrittenName);
        }
        for (DexEncodedField dexEncodedField : clazz.fields()) {
            if (!dexEncodedField.getKotlinInfo().isCompanion()) continue;
            rewritten |= dexEncodedField.getKotlinInfo().asCompanion().rewrite(kmClass, (DexField)dexEncodedField.getReference(), namingLens);
        }
        for (KotlinConstructorInfo kotlinConstructorInfo : this.constructorsWithNoBacking) {
            rewritten |= kotlinConstructorInfo.rewrite(kmClass, null, appView, namingLens);
        }
        KotlinMetadataMembersTracker rewrittenReferences = new KotlinMetadataMembersTracker(appView);
        for (DexEncodedMethod method : clazz.methods()) {
            if (!method.getKotlinInfo().isConstructor()) continue;
            KotlinConstructorInfo constructorInfo = method.getKotlinInfo().asConstructor();
            rewritten |= constructorInfo.rewrite(kmClass, method, appView, namingLens);
            rewrittenReferences.add((DexMember<?, ?>)method.getReference());
        }
        rewritten |= this.declarationContainerInfo.rewrite(kmClass::visitFunction, kmClass::visitProperty, kmClass::visitTypeAlias, clazz, appView, namingLens, rewrittenReferences);
        for (KotlinTypeParameterInfo typeParameter : this.typeParameters) {
            rewritten |= typeParameter.rewrite(kmClass::visitTypeParameter, appView, namingLens);
        }
        for (KotlinTypeInfo superType : this.superTypes) {
            if (clazz.getType() != superType.rewriteType(appView.graphLens())) {
                rewritten |= superType.rewrite(kmClass::visitSupertype, appView, namingLens);
                continue;
            }
            rewritten = true;
        }
        for (KotlinTypeReference nestedClass : this.nestedClasses) {
            Box nestedDescriptorBox = new Box();
            boolean nestedClassRewritten = nestedClass.toRenamedBinaryNameOrDefault(nestedDescriptorBox::set, appView, namingLens, null);
            if (nestedDescriptorBox.isSet()) {
                if (nestedClassRewritten) {
                    String nestedDescriptor = (String)nestedDescriptorBox.get();
                    int innerClassIndex = nestedDescriptor.lastIndexOf(36);
                    kmClass.visitNestedClass(nestedDescriptor.substring(innerClassIndex + 1));
                } else {
                    kmClass.visitNestedClass(nestedClass.getOriginalName());
                }
            }
            rewritten |= nestedClassRewritten;
        }
        for (KotlinTypeReference sealedSubClass : this.sealedSubClasses) {
            rewritten |= sealedSubClass.toRenamedBinaryNameOrDefault(sealedName -> {
                if (sealedName != null) {
                    kmClass.visitSealedSubclass(sealedName.replace('$', '.'));
                }
            }, appView, namingLens, null);
        }
        kmClass.getEnumEntries().addAll(this.enumEntries);
        rewritten |= this.versionRequirements.rewrite(kmClass::visitVersionRequirement);
        if (this.inlineClassUnderlyingPropertyName != null && this.inlineClassUnderlyingType != null) {
            kmClass.setInlineClassUnderlyingPropertyName(this.inlineClassUnderlyingPropertyName);
            rewritten |= this.inlineClassUnderlyingType.rewrite(kmClass::visitInlineClassUnderlyingType, appView, namingLens);
        }
        JvmClassExtensionVisitor jvmClassExtensionVisitor = (JvmClassExtensionVisitor)kmClass.visitExtensions(JvmClassExtensionVisitor.TYPE);
        jvmClassExtensionVisitor.visitJvmFlags(this.jvmFlags);
        jvmClassExtensionVisitor.visitModuleName(this.moduleName);
        if (this.anonymousObjectOrigin != null) {
            rewritten |= this.anonymousObjectOrigin.toRenamedBinaryNameOrDefault(renamedAnon -> {
                if (renamedAnon != null) {
                    extensionVisitor.visitAnonymousObjectOriginName((String)renamedAnon);
                }
            }, appView, namingLens, null);
        }
        jvmClassExtensionVisitor.visitEnd();
        KotlinClassMetadata.Class.Writer writer = new KotlinClassMetadata.Class.Writer();
        kmClass.accept(writer);
        return Pair.create(writer.write().getHeader(), (rewritten |= this.localDelegatedProperties.rewrite(jvmClassExtensionVisitor::visitLocalDelegatedProperty, appView, namingLens)) || !this.originalMembersWithKotlinInfo.isEqual(rewrittenReferences, appView));
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public int[] getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.constructorsWithNoBacking, constructor -> constructor::trace, definitionSupplier);
        this.declarationContainerInfo.trace(definitionSupplier);
        FunctionUtils.forEachApply(this.typeParameters, param -> param::trace, definitionSupplier);
        FunctionUtils.forEachApply(this.superTypes, type -> type::trace, definitionSupplier);
        FunctionUtils.forEachApply(this.sealedSubClasses, sealedClass -> sealedClass::trace, definitionSupplier);
        FunctionUtils.forEachApply(this.nestedClasses, nested -> nested::trace, definitionSupplier);
        this.localDelegatedProperties.trace(definitionSupplier);
        if (this.anonymousObjectOrigin != null) {
            this.anonymousObjectOrigin.trace(definitionSupplier);
        }
    }
}

