/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.jetbrains.kotlinx.metadata.InconsistentKotlinMetadataException;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.kotlin.KotlinClassInfo;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.kotlin.KotlinFileFacadeInfo;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.kotlin.KotlinMultiFileClassFacadeInfo;
import com.android.tools.r8.kotlin.KotlinMultiFileClassPartInfo;
import com.android.tools.r8.kotlin.KotlinSyntheticClassInfo;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;

public final class KotlinClassMetadataReader {
    private static final int SYNTHETIC_CLASS_KIND = 3;

    public static KotlinClassLevelInfo getKotlinInfo(DexClass clazz, AppView<?> appView, Consumer<DexEncodedMethod> keepByteCode) {
        DexAnnotation meta = clazz.annotations().getFirstMatching(appView.dexItemFactory().kotlinMetadataType);
        return meta != null ? KotlinClassMetadataReader.getKotlinInfo(clazz, appView, keepByteCode, meta) : KotlinMetadataUtils.getNoKotlinInfo();
    }

    public static KotlinClassLevelInfo getKotlinInfo(DexClass clazz, AppView<?> appView, Consumer<DexEncodedMethod> keepByteCode, DexAnnotation annotation) {
        try {
            Kotlin kotlin = appView.dexItemFactory().kotlin;
            KotlinClassMetadata kMetadata = KotlinClassMetadataReader.toKotlinClassMetadata(kotlin, annotation.annotation);
            return KotlinClassMetadataReader.createKotlinInfo(kotlin, clazz, kMetadata, appView, keepByteCode);
        }
        catch (InconsistentKotlinMetadataException | MetadataError | ClassCastException e) {
            appView.reporter().info(new StringDiagnostic("Class " + clazz.type.toSourceString() + " has malformed kotlin.Metadata: " + e.getMessage()));
            return KotlinMetadataUtils.getInvalidKotlinInfo();
        }
        catch (Throwable e) {
            appView.reporter().info(new StringDiagnostic("Unexpected error while reading " + clazz.type.toSourceString() + "'s kotlin.Metadata: " + e.getMessage()));
            return KotlinMetadataUtils.getNoKotlinInfo();
        }
    }

    public static boolean isLambda(AppView<?> appView, DexClass clazz) {
        KotlinClassMetadata kMetadata;
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        Kotlin kotlin = dexItemFactory.kotlin;
        KotlinSyntheticClassInfo.Flavour flavour = KotlinSyntheticClassInfo.getFlavour(clazz, kotlin);
        if (flavour == KotlinSyntheticClassInfo.Flavour.Unclassified) {
            return false;
        }
        DexAnnotation metadataAnnotation = clazz.annotations().getFirstMatching(dexItemFactory.kotlinMetadataType);
        if (metadataAnnotation == null) {
            return false;
        }
        Map<DexString, DexAnnotationElement> elementMap = KotlinClassMetadataReader.toElementMap(metadataAnnotation.annotation);
        if (KotlinClassMetadataReader.getKind(kotlin, elementMap) == 3 && (kMetadata = KotlinClassMetadataReader.toKotlinClassMetadata(kotlin, elementMap)) instanceof KotlinClassMetadata.SyntheticClass) {
            return ((KotlinClassMetadata.SyntheticClass)kMetadata).isLambda();
        }
        assert (KotlinClassMetadataReader.toKotlinClassMetadata(kotlin, elementMap) instanceof KotlinClassMetadata.SyntheticClass == (KotlinClassMetadataReader.getKind(kotlin, elementMap) == 3)) : "Synthetic class kinds should agree";
        return false;
    }

    public static boolean hasKotlinClassMetadataAnnotation(DexClass clazz, DexDefinitionSupplier definitionSupplier) {
        return clazz.annotations().getFirstMatching(definitionSupplier.dexItemFactory().kotlinMetadataType) != null;
    }

    public static KotlinClassMetadata toKotlinClassMetadata(Kotlin kotlin, DexEncodedAnnotation metadataAnnotation) {
        return KotlinClassMetadataReader.toKotlinClassMetadata(kotlin, KotlinClassMetadataReader.toElementMap(metadataAnnotation));
    }

    private static Map<DexString, DexAnnotationElement> toElementMap(DexEncodedAnnotation metadataAnnotation) {
        IdentityHashMap<DexString, DexAnnotationElement> elementMap = new IdentityHashMap<DexString, DexAnnotationElement>();
        for (DexAnnotationElement element : metadataAnnotation.elements) {
            elementMap.put(element.name, element);
        }
        return elementMap;
    }

    private static KotlinClassMetadata toKotlinClassMetadata(Kotlin kotlin, Map<DexString, DexAnnotationElement> elementMap) {
        int k = KotlinClassMetadataReader.getKind(kotlin, elementMap);
        DexAnnotationElement metadataVersion = elementMap.get(kotlin.metadata.metadataVersion);
        int[] mv = metadataVersion == null ? null : KotlinClassMetadataReader.getUnboxedIntArray(metadataVersion.value, "mv");
        DexAnnotationElement bytecodeVersion = elementMap.get(kotlin.metadata.bytecodeVersion);
        int[] bv = bytecodeVersion == null ? null : KotlinClassMetadataReader.getUnboxedIntArray(bytecodeVersion.value, "bv");
        DexAnnotationElement data1 = elementMap.get(kotlin.metadata.data1);
        String[] d1 = data1 == null ? null : KotlinClassMetadataReader.getUnboxedStringArray(data1.value, "d1");
        DexAnnotationElement data2 = elementMap.get(kotlin.metadata.data2);
        String[] d2 = data2 == null ? null : KotlinClassMetadataReader.getUnboxedStringArray(data2.value, "d2");
        DexAnnotationElement extraString = elementMap.get(kotlin.metadata.extraString);
        String xs = extraString == null ? null : KotlinClassMetadataReader.getUnboxedString(extraString.value, "xs");
        DexAnnotationElement packageName = elementMap.get(kotlin.metadata.packageName);
        String pn = packageName == null ? null : KotlinClassMetadataReader.getUnboxedString(packageName.value, "pn");
        DexAnnotationElement extraInt = elementMap.get(kotlin.metadata.extraInt);
        Integer xi = extraInt == null ? null : (Integer)extraInt.value.getBoxedValue();
        KotlinClassHeader header = new KotlinClassHeader(k, mv, bv, d1, d2, xs, pn, xi);
        return KotlinClassMetadata.read(header);
    }

    private static int getKind(Kotlin kotlin, Map<DexString, DexAnnotationElement> elementMap) {
        DexAnnotationElement kind = elementMap.get(kotlin.metadata.kind);
        if (kind == null) {
            throw new MetadataError("element 'k' is missing.");
        }
        return (Integer)kind.value.getBoxedValue();
    }

    public static KotlinClassLevelInfo createKotlinInfo(Kotlin kotlin, DexClass clazz, KotlinClassMetadata kMetadata, AppView<?> appView, Consumer<DexEncodedMethod> keepByteCode) {
        String packageName = kMetadata.getHeader().getPackageName();
        int[] metadataVersion = kMetadata.getHeader().getMetadataVersion();
        if (kMetadata instanceof KotlinClassMetadata.Class) {
            return KotlinClassInfo.create((KotlinClassMetadata.Class)kMetadata, packageName, metadataVersion, clazz, appView, keepByteCode);
        }
        if (kMetadata instanceof KotlinClassMetadata.FileFacade) {
            return KotlinFileFacadeInfo.create((KotlinClassMetadata.FileFacade)kMetadata, packageName, metadataVersion, clazz, appView, keepByteCode);
        }
        if (kMetadata instanceof KotlinClassMetadata.MultiFileClassFacade) {
            return KotlinMultiFileClassFacadeInfo.create((KotlinClassMetadata.MultiFileClassFacade)kMetadata, packageName, metadataVersion, appView.dexItemFactory());
        }
        if (kMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
            return KotlinMultiFileClassPartInfo.create((KotlinClassMetadata.MultiFileClassPart)kMetadata, packageName, metadataVersion, clazz, appView, keepByteCode);
        }
        if (kMetadata instanceof KotlinClassMetadata.SyntheticClass) {
            return KotlinSyntheticClassInfo.create((KotlinClassMetadata.SyntheticClass)kMetadata, packageName, metadataVersion, clazz, kotlin, appView);
        }
        throw new MetadataError("unsupported 'k' value: " + kMetadata.getHeader().getKind());
    }

    private static int[] getUnboxedIntArray(DexValue v, String elementName) {
        if (!v.isDexValueArray()) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        DexValue.DexValueArray intArrayValue = v.asDexValueArray();
        DexValue[] values2 = intArrayValue.getValues();
        int[] result = new int[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            result[i] = (Integer)values2[i].getBoxedValue();
        }
        return result;
    }

    private static String[] getUnboxedStringArray(DexValue v, String elementName) {
        if (!v.isDexValueArray()) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        DexValue.DexValueArray stringArrayValue = v.asDexValueArray();
        DexValue[] values2 = stringArrayValue.getValues();
        String[] result = new String[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            result[i] = KotlinClassMetadataReader.getUnboxedString(values2[i], elementName + "[" + i + "]");
        }
        return result;
    }

    private static String getUnboxedString(DexValue v, String elementName) {
        if (!v.isDexValueString()) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        return ((DexString)v.asDexValueString().getValue()).toString();
    }

    public static class MetadataError
    extends RuntimeException {
        private MetadataError(String cause) {
            super(cause);
        }
    }
}

