/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstantValue;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffectExpression;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffectExpressionVisitor;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinTypeInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinEffectExpressionInfo
implements EnqueuerMetadataTraceable {
    private static final List<KotlinEffectExpressionInfo> NO_EXPRESSIONS = ImmutableList.of();
    private static final KotlinEffectExpressionInfo NO_EXPRESSION = new KotlinEffectExpressionInfo(0, 0, null, null, NO_EXPRESSIONS, NO_EXPRESSIONS);
    private final int flags;
    private final Integer parameterIndex;
    private final KmConstantValue constantValue;
    private final KotlinTypeInfo isInstanceType;
    private final List<KotlinEffectExpressionInfo> andArguments;
    private final List<KotlinEffectExpressionInfo> orArguments;

    private KotlinEffectExpressionInfo(int flags, Integer parameterIndex, KmConstantValue constantValue, KotlinTypeInfo isInstanceType, List<KotlinEffectExpressionInfo> andArguments, List<KotlinEffectExpressionInfo> orArguments) {
        this.flags = flags;
        this.parameterIndex = parameterIndex;
        this.constantValue = constantValue;
        this.isInstanceType = isInstanceType;
        this.andArguments = andArguments;
        this.orArguments = orArguments;
    }

    static KotlinEffectExpressionInfo create(KmEffectExpression effectExpression, DexItemFactory factory, Reporter reporter) {
        if (effectExpression == null) {
            return NO_EXPRESSION;
        }
        return new KotlinEffectExpressionInfo(effectExpression.getFlags(), effectExpression.getParameterIndex(), effectExpression.getConstantValue(), KotlinTypeInfo.create(effectExpression.isInstanceType(), factory, reporter), KotlinEffectExpressionInfo.create(effectExpression.getAndArguments(), factory, reporter), KotlinEffectExpressionInfo.create(effectExpression.getOrArguments(), factory, reporter));
    }

    static List<KotlinEffectExpressionInfo> create(List<KmEffectExpression> effectExpressions, DexItemFactory factory, Reporter reporter) {
        if (effectExpressions.isEmpty()) {
            return NO_EXPRESSIONS;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmEffectExpression effectExpression : effectExpressions) {
            builder.add(KotlinEffectExpressionInfo.create(effectExpression, factory, reporter));
        }
        return builder.build();
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        if (this == NO_EXPRESSION) {
            return;
        }
        if (this.isInstanceType != null) {
            this.isInstanceType.trace(definitionSupplier);
        }
        FunctionUtils.forEachApply(this.andArguments, arg -> arg::trace, definitionSupplier);
        FunctionUtils.forEachApply(this.orArguments, arg -> arg::trace, definitionSupplier);
    }

    boolean rewrite(KmVisitorProviders.KmEffectExpressionVisitorProvider provider, AppView<?> appView, NamingLens namingLens) {
        if (this == NO_EXPRESSION) {
            return false;
        }
        KmEffectExpressionVisitor visitor = provider.get();
        visitor.visit(this.flags, this.parameterIndex);
        if (this.constantValue != null) {
            visitor.visitConstantValue(this.constantValue.getValue());
        }
        boolean rewritten = false;
        if (this.isInstanceType != null) {
            rewritten |= this.isInstanceType.rewrite(visitor::visitIsInstanceType, appView, namingLens);
        }
        for (KotlinEffectExpressionInfo andArgument : this.andArguments) {
            rewritten |= andArgument.rewrite(visitor::visitAndArgument, appView, namingLens);
        }
        for (KotlinEffectExpressionInfo orArgument : this.orArguments) {
            rewritten |= orArgument.rewrite(visitor::visitAndArgument, appView, namingLens);
        }
        visitor.visitEnd();
        return rewritten;
    }
}

