/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffect;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffectInvocationKind;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffectType;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffectVisitor;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinEffectExpressionInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinEffectInfo
implements EnqueuerMetadataTraceable {
    private final KmEffectType type;
    private final KmEffectInvocationKind invocationKind;
    private final List<KotlinEffectExpressionInfo> constructorArguments;
    private final KotlinEffectExpressionInfo conclusion;

    public KotlinEffectInfo(KmEffectType type, KmEffectInvocationKind invocationKind, List<KotlinEffectExpressionInfo> constructorArguments, KotlinEffectExpressionInfo conclusion) {
        this.type = type;
        this.invocationKind = invocationKind;
        this.constructorArguments = constructorArguments;
        this.conclusion = conclusion;
    }

    static KotlinEffectInfo create(KmEffect effect, DexItemFactory factory, Reporter reporter) {
        return new KotlinEffectInfo(effect.getType(), effect.getInvocationKind(), KotlinEffectExpressionInfo.create(effect.getConstructorArguments(), factory, reporter), KotlinEffectExpressionInfo.create(effect.getConclusion(), factory, reporter));
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.constructorArguments, arg -> arg::trace, definitionSupplier);
        this.conclusion.trace(definitionSupplier);
    }

    boolean rewrite(KmVisitorProviders.KmEffectVisitorProvider visitorProvider, AppView<?> appView, NamingLens namingLens) {
        KmEffectVisitor kmEffectVisitor = visitorProvider.get(this.type, this.invocationKind);
        boolean rewritten = this.conclusion.rewrite(kmEffectVisitor::visitConclusionOfConditionalEffect, appView, namingLens);
        for (KotlinEffectExpressionInfo constructorArgument : this.constructorArguments) {
            rewritten |= constructorArgument.rewrite(kmEffectVisitor::visitConstructorArgument, appView, namingLens);
        }
        kmEffectVisitor.visitEnd();
        return rewritten;
    }
}

