/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.utils.StringUtils;

public class KotlinMetadataDiagnostic
implements Diagnostic {
    private final Origin origin;
    private final Position position;
    private final String message;

    public KotlinMetadataDiagnostic(Origin origin, Position position, String message) {
        this.origin = origin;
        this.position = position;
        this.message = message;
    }

    static KotlinMetadataDiagnostic missingCompanionObject(DexClass clazz, String companionObjectName) {
        return new KotlinMetadataDiagnostic(clazz.getOrigin(), Position.UNKNOWN, "The companion object " + companionObjectName + " could not be found in class " + clazz.type.getName());
    }

    static KotlinMetadataDiagnostic unknownClassifier(String classifier) {
        return new KotlinMetadataDiagnostic(Origin.unknown(), Position.UNKNOWN, "The classifier " + classifier + " is unknown and cannot be parsed");
    }

    static KotlinMetadataDiagnostic invalidMethodDescriptor(String nameAndDescriptor) {
        return new KotlinMetadataDiagnostic(Origin.unknown(), Position.UNKNOWN, "Invalid descriptor (deserialized from Kotlin @Metadata): " + nameAndDescriptor);
    }

    static KotlinMetadataDiagnostic unexpectedErrorWhenRewriting(DexType type, Throwable t) {
        return new KotlinMetadataDiagnostic(Origin.unknown(), Position.UNKNOWN, "Unexpected error during rewriting of Kotlin metadata for class '" + type.toSourceString() + "':" + StringUtils.LINE_SEPARATOR + StringUtils.stacktraceAsString(t));
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getDiagnosticMessage() {
        return this.message;
    }
}

