/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.kotlin.KotlinClassMetadataReader;
import com.android.tools.r8.kotlin.KotlinMetadataDiagnostic;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.kotlin.KotlinMetadataWriter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class KotlinMetadataRewriter {
    private static final int[] METADATA_VERSION_1_4 = new int[]{1, 4, 0};
    private final AppView<?> appView;
    private final NamingLens lens;
    private final DexItemFactory factory;
    private final Kotlin kotlin;

    public KotlinMetadataRewriter(AppView<?> appView, NamingLens lens) {
        this.appView = appView;
        this.lens = lens;
        this.factory = appView.dexItemFactory();
        this.kotlin = this.factory.kotlin;
    }

    private static boolean isNotKotlinMetadata(DexAnnotation annotation, DexType kotlinMetadataType) {
        return annotation.annotation.type != kotlinMetadataType;
    }

    private void writeKotlinInfoToAnnotation(DexClass clazz, KotlinClassLevelInfo kotlinInfo, DexAnnotation oldMeta, WriteMetadataFieldInfo writeMetadataFieldInfo) {
        try {
            Pair<KotlinClassHeader, Boolean> kotlinClassHeader = kotlinInfo.rewrite(clazz, this.appView, this.lens);
            if (!kotlinClassHeader.getSecond().booleanValue() && this.appView.options().testing.keepMetadataInR8IfNotRewritten) {
                assert (this.appView.checkForTesting(() -> this.verifyRewrittenMetadataIsEquivalent(clazz.annotations().getFirstMatching(this.factory.kotlinMetadataType), this.createKotlinMetadataAnnotation((KotlinClassHeader)kotlinClassHeader.getFirst(), kotlinInfo.getPackageName(), this.getMaxVersion(METADATA_VERSION_1_4, kotlinInfo.getMetadataVersion()), writeMetadataFieldInfo))));
                return;
            }
            DexAnnotation newMeta = this.createKotlinMetadataAnnotation(kotlinClassHeader.getFirst(), kotlinInfo.getPackageName(), this.getMaxVersion(METADATA_VERSION_1_4, kotlinInfo.getMetadataVersion()), writeMetadataFieldInfo);
            clazz.setAnnotations(clazz.annotations().rewrite(anno -> anno == oldMeta ? newMeta : anno));
        }
        catch (Throwable t) {
            assert (this.appView.checkForTesting(() -> {
                throw this.appView.options().reporter.fatalError(KotlinMetadataDiagnostic.unexpectedErrorWhenRewriting(clazz.type, t));
            }));
            this.appView.options().reporter.warning(KotlinMetadataDiagnostic.unexpectedErrorWhenRewriting(clazz.type, t));
        }
    }

    private boolean verifyRewrittenMetadataIsEquivalent(DexAnnotation original, DexAnnotation rewritten) {
        String originalMetadata = KotlinMetadataWriter.kotlinMetadataToString("", KotlinClassMetadataReader.toKotlinClassMetadata(this.kotlin, original.annotation));
        String rewrittenMetadata = KotlinMetadataWriter.kotlinMetadataToString("", KotlinClassMetadataReader.toKotlinClassMetadata(this.kotlin, rewritten.annotation));
        assert (originalMetadata.equals(rewrittenMetadata)) : "The metadata should be equivalent";
        return true;
    }

    private boolean kotlinMetadataFieldExists(DexClass kotlinMetadata, AppView<?> appView, DexString fieldName) {
        if (!((AppInfo)appView.appInfo()).hasLiveness()) {
            return true;
        }
        if (kotlinMetadata == null || kotlinMetadata.isNotProgramClass()) {
            return true;
        }
        return kotlinMetadata.methods(method -> ((DexMethod)method.getReference()).name == fieldName).iterator().hasNext();
    }

    private DexAnnotation createKotlinMetadataAnnotation(KotlinClassHeader header, String packageName, int[] metadataVersion, WriteMetadataFieldInfo writeMetadataFieldInfo) {
        ArrayList<DexAnnotationElement> elements = new ArrayList<DexAnnotationElement>();
        if (writeMetadataFieldInfo.writeMetadataVersion) {
            elements.add(new DexAnnotationElement(this.kotlin.metadata.metadataVersion, this.createIntArray(metadataVersion)));
        }
        if (writeMetadataFieldInfo.writeByteCodeVersion) {
            elements.add(new DexAnnotationElement(this.kotlin.metadata.bytecodeVersion, this.createIntArray(header.getBytecodeVersion())));
        }
        if (writeMetadataFieldInfo.writeKind) {
            elements.add(new DexAnnotationElement(this.kotlin.metadata.kind, DexValue.DexValueInt.create(header.getKind())));
        }
        if (writeMetadataFieldInfo.writeData1) {
            elements.add(new DexAnnotationElement(this.kotlin.metadata.data1, this.createStringArray(header.getData1())));
        }
        if (writeMetadataFieldInfo.writeData2) {
            elements.add(new DexAnnotationElement(this.kotlin.metadata.data2, this.createStringArray(header.getData2())));
        }
        if (writeMetadataFieldInfo.writePackageName && packageName != null && !packageName.isEmpty()) {
            elements.add(new DexAnnotationElement(this.kotlin.metadata.packageName, new DexValue.DexValueString(this.factory.createString(packageName))));
        }
        if (writeMetadataFieldInfo.writeExtraString && !header.getExtraString().isEmpty()) {
            elements.add(new DexAnnotationElement(this.kotlin.metadata.extraString, new DexValue.DexValueString(this.factory.createString(header.getExtraString()))));
        }
        if (writeMetadataFieldInfo.writeExtraInt && header.getExtraInt() != 0) {
            elements.add(new DexAnnotationElement(this.kotlin.metadata.extraInt, DexValue.DexValueInt.create(header.getExtraInt())));
        }
        DexEncodedAnnotation encodedAnnotation = new DexEncodedAnnotation(this.factory.kotlinMetadataType, elements.toArray(DexAnnotationElement.EMPTY_ARRAY));
        return new DexAnnotation(1, encodedAnnotation);
    }

    private DexValue.DexValueArray createIntArray(int[] data2) {
        DexValue[] values2 = new DexValue[data2.length];
        for (int i = 0; i < data2.length; ++i) {
            values2[i] = DexValue.DexValueInt.create(data2[i]);
        }
        return new DexValue.DexValueArray(values2);
    }

    private DexValue.DexValueArray createStringArray(String[] data2) {
        DexValue[] values2 = new DexValue[data2.length];
        for (int i = 0; i < data2.length; ++i) {
            values2[i] = new DexValue.DexValueString(this.factory.createString(data2[i]));
        }
        return new DexValue.DexValueArray(values2);
    }

    private int[] getMaxVersion(int[] one, int[] other) {
        int patchOther;
        assert (one.length == 2 || one.length == 3);
        assert (other.length == 2 || other.length == 3);
        if (one[0] != other[0]) {
            return one[0] > other[0] ? one : other;
        }
        if (one[1] != other[1]) {
            return one[1] > other[1] ? one : other;
        }
        int patchOne = one.length >= 3 ? one[2] : 0;
        int n = patchOther = other.length >= 3 ? other[2] : 0;
        if (patchOne != patchOther) {
            return patchOne > patchOther ? one : other;
        }
        return one;
    }

    public void runForR8(ExecutorService executorService) throws ExecutionException {
        DexType rewrittenMetadataType = this.appView.graphLens().lookupClassType(this.factory.kotlinMetadataType);
        DexClass kotlinMetadata = this.appView.definitionFor(rewrittenMetadataType);
        WriteMetadataFieldInfo writeMetadataFieldInfo = new WriteMetadataFieldInfo(this.kotlinMetadataFieldExists(kotlinMetadata, this.appView, this.kotlin.metadata.kind), this.kotlinMetadataFieldExists(kotlinMetadata, this.appView, this.kotlin.metadata.metadataVersion), this.kotlinMetadataFieldExists(kotlinMetadata, this.appView, this.kotlin.metadata.bytecodeVersion), this.kotlinMetadataFieldExists(kotlinMetadata, this.appView, this.kotlin.metadata.data1), this.kotlinMetadataFieldExists(kotlinMetadata, this.appView, this.kotlin.metadata.data2), this.kotlinMetadataFieldExists(kotlinMetadata, this.appView, this.kotlin.metadata.extraString), this.kotlinMetadataFieldExists(kotlinMetadata, this.appView, this.kotlin.metadata.packageName), this.kotlinMetadataFieldExists(kotlinMetadata, this.appView, this.kotlin.metadata.extraInt));
        ThreadUtils.processItems(((AppInfo)this.appView.appInfo()).classes(), clazz -> {
            KotlinClassLevelInfo kotlinInfo = clazz.getKotlinInfo();
            if (kotlinInfo == KotlinMetadataUtils.getInvalidKotlinInfo()) {
                return;
            }
            DexAnnotation oldMeta = clazz.annotations().getFirstMatching(rewrittenMetadataType);
            if (oldMeta == null || kotlinInfo == KotlinMetadataUtils.getNoKotlinInfo() || ((AppInfo)this.appView.appInfo()).hasLiveness() && !this.appView.withLiveness().appInfo().isPinned(clazz.type)) {
                if (oldMeta != null) {
                    clazz.setAnnotations(clazz.annotations().keepIf(anno -> KotlinMetadataRewriter.isNotKotlinMetadata(anno, rewrittenMetadataType)));
                }
                return;
            }
            this.writeKotlinInfoToAnnotation((DexClass)clazz, kotlinInfo, oldMeta, writeMetadataFieldInfo);
        }, executorService);
    }

    public void runForD8(ExecutorService executorService) throws ExecutionException {
        if (this.lens.isIdentityLens()) {
            return;
        }
        WriteMetadataFieldInfo writeMetadataFieldInfo = WriteMetadataFieldInfo.rewriteAll();
        ThreadUtils.processItems(((AppInfo)this.appView.appInfo()).classes(), clazz -> {
            DexAnnotation metadata = clazz.annotations().getFirstMatching(this.factory.kotlinMetadataType);
            if (metadata == null) {
                return;
            }
            KotlinClassLevelInfo kotlinInfo = KotlinClassMetadataReader.getKotlinInfo(clazz, this.appView, ConsumerUtils.emptyConsumer(), metadata);
            if (kotlinInfo == KotlinMetadataUtils.getNoKotlinInfo()) {
                return;
            }
            this.writeKotlinInfoToAnnotation((DexClass)clazz, kotlinInfo, metadata, writeMetadataFieldInfo);
        }, executorService);
    }

    private static final class WriteMetadataFieldInfo {
        final boolean writeKind;
        final boolean writeMetadataVersion;
        final boolean writeByteCodeVersion;
        final boolean writeData1;
        final boolean writeData2;
        final boolean writeExtraString;
        final boolean writePackageName;
        final boolean writeExtraInt;

        private WriteMetadataFieldInfo(boolean writeKind, boolean writeMetadataVersion, boolean writeByteCodeVersion, boolean writeData1, boolean writeData2, boolean writeExtraString, boolean writePackageName, boolean writeExtraInt) {
            this.writeKind = writeKind;
            this.writeMetadataVersion = writeMetadataVersion;
            this.writeByteCodeVersion = writeByteCodeVersion;
            this.writeData1 = writeData1;
            this.writeData2 = writeData2;
            this.writeExtraString = writeExtraString;
            this.writePackageName = writePackageName;
            this.writeExtraInt = writeExtraInt;
        }

        private static WriteMetadataFieldInfo rewriteAll() {
            return new WriteMetadataFieldInfo(true, true, true, true, true, true, true, true);
        }
    }
}

