/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.errors.InvalidDescriptorException;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmExtensionType;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmPropertyExtensionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmPropertyVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmFieldSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.kotlin.KotlinFieldLevelInfo;
import com.android.tools.r8.kotlin.KotlinMethodLevelInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Pair;

public class KotlinMetadataUtils {
    private static final NoKotlinInfo NO_KOTLIN_INFO = new NoKotlinInfo("NO_KOTLIN_INFO");
    private static final NoKotlinInfo INVALID_KOTLIN_INFO = new NoKotlinInfo("INVALID_KOTLIN_INFO");

    public static NoKotlinInfo getNoKotlinInfo() {
        return NO_KOTLIN_INFO;
    }

    public static NoKotlinInfo getInvalidKotlinInfo() {
        return INVALID_KOTLIN_INFO;
    }

    static JvmFieldSignature toJvmFieldSignature(DexField field) {
        return new JvmFieldSignature(field.name.toString(), field.type.toDescriptorString());
    }

    static JvmMethodSignature toJvmMethodSignature(DexMethod method) {
        StringBuilder descBuilder = new StringBuilder();
        descBuilder.append("(");
        for (DexType argType : method.proto.parameters.values) {
            descBuilder.append(argType.toDescriptorString());
        }
        descBuilder.append(")");
        descBuilder.append(method.proto.returnType.toDescriptorString());
        return new JvmMethodSignature(method.name.toString(), descBuilder.toString());
    }

    static JvmMethodSignature toDefaultJvmMethodSignature(JvmMethodSignature methodSignature, int intArguments) {
        return new JvmMethodSignature(methodSignature.getName() + "$default", methodSignature.getDesc().replace(")", Strings.repeat("I", intArguments) + "Ljava/lang/Object;)"));
    }

    static boolean isValidMethodDescriptor(String methodDescriptor) {
        try {
            String[] argDescriptors;
            for (String argDescriptor : argDescriptors = DescriptorUtils.getArgumentTypeDescriptors(methodDescriptor)) {
                if (argDescriptor.charAt(0) != 'L' || DescriptorUtils.isClassDescriptor(argDescriptor)) continue;
                return false;
            }
            return true;
        }
        catch (InvalidDescriptorException e) {
            return false;
        }
    }

    public static boolean mayProcessKotlinMetadata(AppView<?> appView) {
        DexClass kotlinMetadata = ((AppInfo)appView.appInfo()).definitionForWithoutExistenceAssert(appView.dexItemFactory().kotlinMetadataType);
        if (kotlinMetadata == null || kotlinMetadata.isNotProgramClass()) {
            return true;
        }
        ProguardConfiguration proguardConfiguration = appView.options().getProguardConfiguration();
        if (proguardConfiguration != null && proguardConfiguration.getRules() != null) {
            for (ProguardConfigurationRule rule : proguardConfiguration.getRules()) {
                if (!KotlinMetadataUtils.canBeKotlinMetadataKeepRule(rule, appView.options().itemFactory)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean canBeKotlinMetadataKeepRule(ProguardConfigurationRule rule, DexItemFactory factory) {
        if (rule.isProguardIfRule()) {
            return KotlinMetadataUtils.canBeKotlinMetadataKeepRule(rule.asProguardIfRule().getSubsequentRule(), factory);
        }
        if (!rule.isProguardKeepRule()) {
            return false;
        }
        ProguardKeepRule proguardKeepRule = rule.asProguardKeepRule();
        if (proguardKeepRule.getType() == ProguardKeepRuleType.KEEP_CLASS_MEMBERS) {
            return false;
        }
        if (proguardKeepRule.getModifiers().allowsShrinking) {
            return false;
        }
        return proguardKeepRule.getClassNames().matches(factory.kotlinMetadataType);
    }

    static String getKotlinClassName(DexClass clazz, String descriptor) {
        InnerClassAttribute innerClassAttribute = clazz.getInnerClassAttributeForThisClass();
        if (innerClassAttribute != null && innerClassAttribute.getOuter() != null) {
            return DescriptorUtils.descriptorToKotlinClassifier(descriptor);
        }
        if (clazz.isLocalClass() || clazz.isAnonymousClass()) {
            return KotlinMetadataUtils.getKotlinLocalOrAnonymousNameFromDescriptor(descriptor, true);
        }
        return DescriptorUtils.getBinaryNameFromDescriptor(descriptor);
    }

    static String getKotlinLocalOrAnonymousNameFromDescriptor(String descriptor, boolean isLocalOrAnonymous) {
        if (isLocalOrAnonymous) {
            return "." + DescriptorUtils.getBinaryNameFromDescriptor(descriptor);
        }
        return DescriptorUtils.descriptorToKotlinClassifier(descriptor);
    }

    static class KmPropertyProcessor {
        private JvmFieldSignature fieldSignature = null;
        private JvmMethodSignature getterSignature = null;
        private JvmMethodSignature setterSignature = null;

        KmPropertyProcessor(KmProperty kmProperty) {
            kmProperty.accept(new KmPropertyVisitor(){

                @Override
                public KmPropertyExtensionVisitor visitExtensions(KmExtensionType type) {
                    if (type != JvmPropertyExtensionVisitor.TYPE) {
                        return null;
                    }
                    return new JvmPropertyExtensionVisitor(){

                        @Override
                        public void visit(int flags, JvmFieldSignature fieldDesc, JvmMethodSignature getterDesc, JvmMethodSignature setterDesc) {
                            assert (fieldSignature == null) : KmPropertyProcessor.access$100(this).asString();
                            fieldSignature = fieldDesc;
                            assert (getterSignature == null) : KmPropertyProcessor.access$200(this).asString();
                            getterSignature = getterDesc;
                            assert (setterSignature == null) : KmPropertyProcessor.access$300(this).asString();
                            setterSignature = setterDesc;
                        }
                    };
                }
            });
        }

        JvmFieldSignature fieldSignature() {
            return this.fieldSignature;
        }

        JvmMethodSignature getterSignature() {
            return this.getterSignature;
        }

        JvmMethodSignature setterSignature() {
            return this.setterSignature;
        }
    }

    private static class NoKotlinInfo
    implements KotlinClassLevelInfo,
    KotlinFieldLevelInfo,
    KotlinMethodLevelInfo {
        private final String name;

        private NoKotlinInfo(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Pair<KotlinClassHeader, Boolean> rewrite(DexClass clazz, AppView<?> appView, NamingLens namingLens) {
            throw new Unreachable("Should never be called");
        }

        @Override
        public String getPackageName() {
            throw new Unreachable("Should never be called");
        }

        @Override
        public int[] getMetadataVersion() {
            throw new Unreachable("Should never be called");
        }

        @Override
        public boolean isNoKotlinInformation() {
            return true;
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
        }
    }
}

