/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.jetbrains.kotlinx.metadata.InconsistentKotlinMetadataException;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmAnnotation;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmAnnotationArgument;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmClass;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmContract;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmDeclarationContainer;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffect;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffectExpression;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFlexibleTypeUpperBound;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunction;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmLambda;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmPackage;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmType;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeAlias;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeParameter;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeProjection;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmValueParameter;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmVersionRequirement;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmFieldSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.kotlin.KotlinClassMetadataReader;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.StringUtils;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class KotlinMetadataWriter {
    static final String INDENT = "  ";

    public static void writeKotlinMetadataAnnotation(String prefix, DexAnnotation annotation, PrintStream ps, Kotlin kotlin) {
        assert (annotation.annotation.type == kotlin.factory.kotlinMetadataType);
        try {
            KotlinClassMetadata kMetadata = KotlinClassMetadataReader.toKotlinClassMetadata(kotlin, annotation.annotation);
            ps.println(KotlinMetadataWriter.kotlinMetadataToString(prefix, kMetadata));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String kotlinMetadataToString(String prefix, KotlinClassMetadata kMetadata) {
        if (kMetadata instanceof KotlinClassMetadata.Class) {
            return KotlinMetadataWriter.kotlinClassMetadataToString((KotlinClassMetadata.Class)kMetadata, prefix);
        }
        if (kMetadata instanceof KotlinClassMetadata.FileFacade) {
            return KotlinMetadataWriter.kotlinFileFacadeMetadataToString((KotlinClassMetadata.FileFacade)kMetadata, prefix);
        }
        if (kMetadata instanceof KotlinClassMetadata.MultiFileClassFacade) {
            return KotlinMetadataWriter.kotlinMultiFileClassFacadeMetadataString((KotlinClassMetadata.MultiFileClassFacade)kMetadata, prefix);
        }
        if (kMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
            return KotlinMetadataWriter.kotlinMultiFileClassPartToString((KotlinClassMetadata.MultiFileClassPart)kMetadata, prefix);
        }
        if (kMetadata instanceof KotlinClassMetadata.SyntheticClass) {
            return KotlinMetadataWriter.kotlinSyntheticClassToString((KotlinClassMetadata.SyntheticClass)kMetadata, prefix);
        }
        throw new Unreachable("An error would be thrown before in createKotlinInfo");
    }

    private static String kotlinClassMetadataToString(KotlinClassMetadata.Class kMetadata, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        KotlinMetadataWriter.appendKmSection(indent, "Metadata.Class", sb, newIndent -> KotlinMetadataWriter.appendKmClass(newIndent, sb, kMetadata.toKmClass()));
        return sb.toString();
    }

    private static String kotlinFileFacadeMetadataToString(KotlinClassMetadata.FileFacade kMetadata, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        KotlinMetadataWriter.appendKmSection(indent, "Metadata.FileFacade", sb, newIndent -> KotlinMetadataWriter.appendKmPackage(newIndent, sb, kMetadata.toKmPackage()));
        return sb.toString();
    }

    private static String kotlinMultiFileClassFacadeMetadataString(KotlinClassMetadata.MultiFileClassFacade kMetadata, String indent) {
        return indent + "MetaData.MultiFileClassFacade(" + StringUtils.join(", ", kMetadata.getPartClassNames()) + ")";
    }

    private static String kotlinMultiFileClassPartToString(KotlinClassMetadata.MultiFileClassPart kMetadata, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        KotlinMetadataWriter.appendKmSection(indent, "Metadata.MultiFileClassPart", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "facadeClassName", sb, kMetadata.getFacadeClassName());
            KotlinMetadataWriter.appendKmPackage(newIndent, sb, kMetadata.toKmPackage());
        });
        return sb.toString();
    }

    private static String kotlinSyntheticClassToString(KotlinClassMetadata.SyntheticClass kMetadata, String indent) {
        StringBuilder sb = new StringBuilder(indent);
        KotlinMetadataWriter.appendKmSection(indent, "Metadata.SyntheticClass", sb, newIndent -> {
            try {
                KmLambda kmLambda = kMetadata.toKmLambda();
                if (kmLambda != null) {
                    KotlinMetadataWriter.appendKeyValue(newIndent, "function", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmFunction(nextIndent, sb, kmLambda.function));
                } else {
                    KotlinMetadataWriter.appendKeyValue(newIndent, "function", sb, "null");
                }
            }
            catch (InconsistentKotlinMetadataException ex) {
                KotlinMetadataWriter.appendKeyValue(newIndent, "function", sb, ex.getMessage());
            }
        });
        return sb.toString();
    }

    private static <T> void appendKmHelper(String key, StringBuilder sb, Action appendContent, String start, String end) {
        sb.append(key);
        sb.append(start);
        appendContent.execute();
        sb.append(end);
    }

    public static <T> void appendKmSection(String indent, String typeDescription, StringBuilder sb, Consumer<String> appendContent) {
        KotlinMetadataWriter.appendKmHelper(typeDescription, sb, () -> appendContent.accept(indent + INDENT), "{" + StringUtils.LINE_SEPARATOR, indent + "}");
    }

    private static <T> void appendKmList(String indent, String typeDescription, StringBuilder sb, Collection<T> items, BiConsumer<String, T> appendItem) {
        if (items.isEmpty()) {
            sb.append(typeDescription).append("[]");
            return;
        }
        KotlinMetadataWriter.appendKmHelper(typeDescription, sb, () -> {
            for (Object kmItem : items) {
                sb.append(indent).append(INDENT);
                appendItem.accept(indent + INDENT, kmItem);
                sb.append(StringUtils.LINE_SEPARATOR);
            }
        }, "[" + StringUtils.LINE_SEPARATOR, indent + "]");
    }

    private static void appendKeyValue(String indent, String key, StringBuilder sb, Consumer<String> appendValue) {
        sb.append(indent);
        KotlinMetadataWriter.appendKmHelper(key, sb, () -> appendValue.accept(indent), ": ", "," + StringUtils.LINE_SEPARATOR);
    }

    public static void appendKeyValue(String indent, String key, StringBuilder sb, String value) {
        sb.append(indent);
        KotlinMetadataWriter.appendKmHelper(key, sb, () -> sb.append(value), ": ", "," + StringUtils.LINE_SEPARATOR);
    }

    private static void appendKmDeclarationContainer(String indent, StringBuilder sb, KmDeclarationContainer container) {
        KotlinMetadataWriter.appendKeyValue(indent, "functions", sb, (String newIndent) -> KotlinMetadataWriter.appendKmList(newIndent, "KmFunction", sb, container.getFunctions().stream().sorted(Comparator.comparing(kmFunction -> JvmExtensionsKt.getSignature(kmFunction).asString())).collect(Collectors.toList()), (nextIndent, kmFunction) -> KotlinMetadataWriter.appendKmFunction(nextIndent, sb, kmFunction)));
        KotlinMetadataWriter.appendKeyValue(indent, "properties", sb, (String newIndent) -> KotlinMetadataWriter.appendKmList(newIndent, "KmProperty", sb, container.getProperties().stream().sorted(Comparator.comparing(kmProperty -> {
            JvmMethodSignature signature = JvmExtensionsKt.getGetterSignature(kmProperty);
            if (signature != null) {
                return signature.asString();
            }
            signature = JvmExtensionsKt.getSetterSignature(kmProperty);
            if (signature != null) {
                return signature.asString();
            }
            JvmFieldSignature fieldSignature = JvmExtensionsKt.getFieldSignature(kmProperty);
            if (fieldSignature != null) {
                return fieldSignature.asString();
            }
            return kmProperty.getName();
        })).collect(Collectors.toList()), (nextIndent, kmProperty) -> KotlinMetadataWriter.appendKmProperty(nextIndent, sb, kmProperty)));
        KotlinMetadataWriter.appendKeyValue(indent, "typeAliases", sb, (String newIndent) -> KotlinMetadataWriter.appendKmList(newIndent, "KmTypeAlias", sb, container.getTypeAliases().stream().sorted(Comparator.comparing(KmTypeAlias::getName)).collect(Collectors.toList()), (nextIndent, kmTypeAlias) -> KotlinMetadataWriter.appendTypeAlias(nextIndent, sb, kmTypeAlias)));
    }

    public static void appendKmPackage(String indent, StringBuilder sb, KmPackage kmPackage) {
        KotlinMetadataWriter.appendKmDeclarationContainer(indent, sb, kmPackage);
        KotlinMetadataWriter.appendKeyValue(indent, "moduleName", sb, JvmExtensionsKt.getModuleName(kmPackage));
        KotlinMetadataWriter.appendKeyValue(indent, "localDelegatedProperties", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmProperty", sb, JvmExtensionsKt.getLocalDelegatedProperties(kmPackage), (nextNextIndent, kmProperty) -> KotlinMetadataWriter.appendKmProperty(nextNextIndent, sb, kmProperty)));
    }

    public static void appendKmClass(String indent, StringBuilder sb, KmClass kmClass) {
        KotlinMetadataWriter.appendKeyValue(indent, "flags", sb, kmClass.getFlags() + "");
        KotlinMetadataWriter.appendKeyValue(indent, "jvmFlags", sb, JvmExtensionsKt.getJvmFlags(kmClass) + "");
        KotlinMetadataWriter.appendKeyValue(indent, "name", sb, kmClass.getName());
        KotlinMetadataWriter.appendKeyValue(indent, "typeParameters", sb, (String newIndent) -> KotlinMetadataWriter.appendTypeParameters(newIndent, sb, kmClass.getTypeParameters()));
        KotlinMetadataWriter.appendKeyValue(indent, "superTypes", sb, (String newIndent) -> KotlinMetadataWriter.appendKmList(newIndent, "KmType", sb, kmClass.getSupertypes(), (nextIndent, kmType) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, kmType)));
        if (kmClass.getInlineClassUnderlyingPropertyName() != null) {
            KotlinMetadataWriter.appendKeyValue(indent, "inlineClassUnderlyingPropertyName", sb, kmClass.getInlineClassUnderlyingPropertyName());
        }
        if (kmClass.getInlineClassUnderlyingType() != null) {
            KotlinMetadataWriter.appendKeyValue(indent, "inlineClassUnderlyingType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, kmClass.getInlineClassUnderlyingType()));
        }
        String companionObject = kmClass.getCompanionObject();
        KotlinMetadataWriter.appendKeyValue(indent, "enumEntries", sb, "[" + StringUtils.join(",", kmClass.getEnumEntries()) + "]");
        KotlinMetadataWriter.appendKeyValue(indent, "companionObject", sb, companionObject == null ? "null" : companionObject);
        KotlinMetadataWriter.appendKeyValue(indent, "sealedSubclasses", sb, "[" + StringUtils.join(",", kmClass.getSealedSubclasses()) + "]");
        KotlinMetadataWriter.appendKeyValue(indent, "nestedClasses", sb, "[" + StringUtils.join(",", kmClass.getNestedClasses()) + "]");
        KotlinMetadataWriter.appendKeyValue(indent, "anonymousObjectOriginName", sb, JvmExtensionsKt.getAnonymousObjectOriginName(kmClass));
        KotlinMetadataWriter.appendKeyValue(indent, "moduleName", sb, JvmExtensionsKt.getModuleName(kmClass));
        KotlinMetadataWriter.appendKeyValue(indent, "localDelegatedProperties", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmProperty", sb, JvmExtensionsKt.getLocalDelegatedProperties(kmClass), (nextNextIndent, kmProperty) -> KotlinMetadataWriter.appendKmProperty(nextNextIndent, sb, kmProperty)));
        KotlinMetadataWriter.appendKmVersionRequirement(indent, sb, kmClass.getVersionRequirements());
        KotlinMetadataWriter.appendKeyValue(indent, "constructors", sb, (String newIndent) -> KotlinMetadataWriter.appendKmList(newIndent, "KmConstructor", sb, kmClass.getConstructors().stream().sorted(Comparator.comparing(kmConstructor -> JvmExtensionsKt.getSignature(kmConstructor).asString())).collect(Collectors.toList()), (nextIndent, constructor) -> KotlinMetadataWriter.appendKmConstructor(nextIndent, sb, constructor)));
        KotlinMetadataWriter.appendKmDeclarationContainer(indent, sb, kmClass);
    }

    private static void appendKmConstructor(String indent, StringBuilder sb, KmConstructor constructor) {
        KotlinMetadataWriter.appendKmSection(indent, "KmConstructor", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "flags", sb, constructor.getFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "valueParameters", sb, (String nextIndent) -> KotlinMetadataWriter.appendValueParameters(nextIndent, sb, constructor.getValueParameters()));
            JvmMethodSignature signature = JvmExtensionsKt.getSignature(constructor);
            KotlinMetadataWriter.appendKeyValue(newIndent, "signature", sb, signature != null ? signature.asString() : "null");
            KotlinMetadataWriter.appendKmVersionRequirement(newIndent, sb, constructor.getVersionRequirements());
        });
    }

    public static void appendKmFunction(String indent, StringBuilder sb, KmFunction function) {
        KotlinMetadataWriter.appendKmSection(indent, "KmFunction", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "flags", sb, function.getFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "name", sb, function.getName());
            KotlinMetadataWriter.appendKeyValue(newIndent, "receiverParameterType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, function.getReceiverParameterType()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "returnType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, function.getReturnType()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "typeParameters", sb, (String nextIndent) -> KotlinMetadataWriter.appendTypeParameters(nextIndent, sb, function.getTypeParameters()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "valueParameters", sb, (String nextIndent) -> KotlinMetadataWriter.appendValueParameters(nextIndent, sb, function.getValueParameters()));
            KotlinMetadataWriter.appendKmVersionRequirement(newIndent, sb, function.getVersionRequirements());
            KmContract contract = function.getContract();
            if (contract == null) {
                KotlinMetadataWriter.appendKeyValue(newIndent, "contract", sb, "null");
            } else {
                KotlinMetadataWriter.appendKeyValue(newIndent, "contract", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmContract(nextIndent, sb, contract));
            }
            JvmMethodSignature signature = JvmExtensionsKt.getSignature(function);
            KotlinMetadataWriter.appendKeyValue(newIndent, "signature", sb, signature != null ? signature.asString() : "null");
            KotlinMetadataWriter.appendKeyValue(newIndent, "lambdaClassOriginName", sb, JvmExtensionsKt.getLambdaClassOriginName(function));
        });
    }

    private static void appendKmProperty(String indent, StringBuilder sb, KmProperty kmProperty) {
        KotlinMetadataWriter.appendKmSection(indent, "KmProperty", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "flags", sb, kmProperty.getFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "name", sb, kmProperty.getName());
            KotlinMetadataWriter.appendKeyValue(newIndent, "receiverParameterType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, kmProperty.getReceiverParameterType()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "returnType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, kmProperty.getReturnType()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "typeParameters", sb, (String nextIndent) -> KotlinMetadataWriter.appendTypeParameters(nextIndent, sb, kmProperty.getTypeParameters()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "getterFlags", sb, kmProperty.getGetterFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "setterFlags", sb, kmProperty.getSetterFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "setterParameter", sb, (String nextIndent) -> KotlinMetadataWriter.appendValueParameter(nextIndent, sb, kmProperty.getSetterParameter()));
            KotlinMetadataWriter.appendKmVersionRequirement(newIndent, sb, kmProperty.getVersionRequirements());
            KotlinMetadataWriter.appendKeyValue(newIndent, "jvmFlags", sb, JvmExtensionsKt.getJvmFlags(kmProperty) + "");
            JvmFieldSignature fieldSignature = JvmExtensionsKt.getFieldSignature(kmProperty);
            KotlinMetadataWriter.appendKeyValue(newIndent, "fieldSignature", sb, fieldSignature != null ? fieldSignature.asString() : "null");
            JvmMethodSignature getterSignature = JvmExtensionsKt.getGetterSignature(kmProperty);
            KotlinMetadataWriter.appendKeyValue(newIndent, "getterSignature", sb, getterSignature != null ? getterSignature.asString() : "null");
            JvmMethodSignature setterSignature = JvmExtensionsKt.getSetterSignature(kmProperty);
            KotlinMetadataWriter.appendKeyValue(newIndent, "setterSignature", sb, setterSignature != null ? setterSignature.asString() : "null");
            JvmMethodSignature syntheticMethodForAnnotations = JvmExtensionsKt.getSyntheticMethodForAnnotations(kmProperty);
            KotlinMetadataWriter.appendKeyValue(newIndent, "syntheticMethodForAnnotations", sb, syntheticMethodForAnnotations != null ? syntheticMethodForAnnotations.asString() : "null");
            JvmMethodSignature syntheticMethodForDelegate = JvmExtensionsKt.getSyntheticMethodForAnnotations(kmProperty);
            KotlinMetadataWriter.appendKeyValue(newIndent, "syntheticMethodForDelegate", sb, syntheticMethodForDelegate != null ? syntheticMethodForDelegate.asString() : "null");
        });
    }

    private static void appendKmType(String indent, StringBuilder sb, KmType kmType) {
        if (kmType == null) {
            sb.append("null");
            return;
        }
        KotlinMetadataWriter.appendKmSection(indent, "KmType", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "flags", sb, kmType.getFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "classifier", sb, kmType.classifier.toString());
            KotlinMetadataWriter.appendKeyValue(newIndent, "arguments", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmTypeProjection", sb, kmType.getArguments(), (nextNextIndent, kmTypeProjection) -> KotlinMetadataWriter.appendKmTypeProjection(nextNextIndent, sb, kmTypeProjection)));
            KotlinMetadataWriter.appendKeyValue(newIndent, "abbreviatedType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(newIndent, sb, kmType.getAbbreviatedType()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "outerType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(newIndent, sb, kmType.getOuterType()));
            KmFlexibleTypeUpperBound flexibleTypeUpperBound = kmType.getFlexibleTypeUpperBound();
            if (flexibleTypeUpperBound != null) {
                KotlinMetadataWriter.appendKeyValue(newIndent, "flexibleTypeUpperBound", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmSection(newIndent, "FlexibleTypeUpperBound", sb, nextNextIndent -> {
                    KotlinMetadataWriter.appendKeyValue(nextNextIndent, "typeFlexibilityId", sb, flexibleTypeUpperBound.getTypeFlexibilityId());
                    KotlinMetadataWriter.appendKeyValue(nextNextIndent, "type", sb, (String nextNextNextIndent) -> KotlinMetadataWriter.appendKmType(nextNextNextIndent, sb, flexibleTypeUpperBound.getType()));
                }));
            }
            KotlinMetadataWriter.appendKeyValue(newIndent, "raw", sb, JvmExtensionsKt.isRaw(kmType) + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "annotations", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmAnnotion", sb, JvmExtensionsKt.getAnnotations(kmType), (nextNextIndent, kmAnnotation) -> KotlinMetadataWriter.appendKmAnnotation(nextNextIndent, sb, kmAnnotation)));
        });
    }

    private static void appendKmTypeProjection(String indent, StringBuilder sb, KmTypeProjection projection) {
        KotlinMetadataWriter.appendKmSection(indent, "KmTypeProjection", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "type", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, projection.getType()));
            if (projection.getVariance() != null) {
                KotlinMetadataWriter.appendKeyValue(newIndent, "variance", sb, projection.getVariance().name());
            }
        });
    }

    private static void appendValueParameters(String indent, StringBuilder sb, List<KmValueParameter> valueParameters) {
        KotlinMetadataWriter.appendKmList(indent, "KmValueParameter", sb, valueParameters, (newIndent, parameter) -> KotlinMetadataWriter.appendValueParameter(newIndent, sb, parameter));
    }

    private static void appendValueParameter(String indent, StringBuilder sb, KmValueParameter valueParameter) {
        if (valueParameter == null) {
            sb.append("null");
            return;
        }
        KotlinMetadataWriter.appendKmSection(indent, "KmValueParameter", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "flags", sb, valueParameter.getFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "name", sb, valueParameter.getName());
            KotlinMetadataWriter.appendKeyValue(newIndent, "type", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, valueParameter.getType()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "varargElementType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, valueParameter.getVarargElementType()));
        });
    }

    private static void appendTypeParameters(String indent, StringBuilder sb, List<KmTypeParameter> typeParameters) {
        KotlinMetadataWriter.appendKmList(indent, "KmTypeParameter", sb, typeParameters, (newIndent, parameter) -> KotlinMetadataWriter.appendTypeParameter(newIndent, sb, parameter));
    }

    private static void appendTypeParameter(String indent, StringBuilder sb, KmTypeParameter typeParameter) {
        KotlinMetadataWriter.appendKmSection(indent, "KmTypeParameter", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "id", sb, typeParameter.getId() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "flags", sb, typeParameter.getFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "name", sb, typeParameter.getName());
            KotlinMetadataWriter.appendKeyValue(newIndent, "variance", sb, typeParameter.getVariance().name());
            KotlinMetadataWriter.appendKeyValue(newIndent, "upperBounds", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmType", sb, typeParameter.getUpperBounds(), (nextNextIndent, kmType) -> KotlinMetadataWriter.appendKmType(nextNextIndent, sb, kmType)));
            KotlinMetadataWriter.appendKeyValue(newIndent, "extensions", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmAnnotion", sb, JvmExtensionsKt.getAnnotations(typeParameter), (nextNextIndent, kmAnnotation) -> KotlinMetadataWriter.appendKmAnnotation(nextNextIndent, sb, kmAnnotation)));
        });
    }

    private static void appendTypeAlias(String indent, StringBuilder sb, KmTypeAlias kmTypeAlias) {
        KotlinMetadataWriter.appendKmSection(indent, "KmTypeAlias", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "annotations", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmAnnotation", sb, kmTypeAlias.getAnnotations(), (nextNextIndent, kmAnnotation) -> KotlinMetadataWriter.appendKmAnnotation(nextNextIndent, sb, kmAnnotation)));
            KotlinMetadataWriter.appendKeyValue(newIndent, "expandedType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, kmTypeAlias.expandedType));
            KotlinMetadataWriter.appendKeyValue(newIndent, "flags", sb, kmTypeAlias.getFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "name", sb, kmTypeAlias.getName());
            KotlinMetadataWriter.appendKeyValue(newIndent, "typeParameters", sb, (String nextIndent) -> KotlinMetadataWriter.appendTypeParameters(nextIndent, sb, kmTypeAlias.getTypeParameters()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "underlyingType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, kmTypeAlias.underlyingType));
            KotlinMetadataWriter.appendKmVersionRequirement(newIndent, sb, kmTypeAlias.getVersionRequirements());
        });
    }

    private static void appendKmAnnotation(String indent, StringBuilder sb, KmAnnotation kmAnnotation) {
        KotlinMetadataWriter.appendKmSection(indent, "KmAnnotation", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "className", sb, kmAnnotation.getClassName());
            KotlinMetadataWriter.appendKeyValue(newIndent, "arguments", sb, (String nextIndent) -> {
                Map<String, KmAnnotationArgument> arguments = kmAnnotation.getArguments();
                KotlinMetadataWriter.appendKmList(nextIndent, "{ key: String, value: KmAnnotationArgument<?> }", sb, arguments.keySet(), (nextNextIndent, key) -> KotlinMetadataWriter.appendKmSection(nextNextIndent, "", sb, nextNextNextIndent -> KotlinMetadataWriter.appendKeyValue(nextNextNextIndent, key, sb, (String nextNextNextNextIndent) -> KotlinMetadataWriter.appendKmArgument(nextNextNextIndent, sb, (KmAnnotationArgument)arguments.get(key)))));
            });
        });
    }

    private static void appendKmArgument(String indent, StringBuilder sb, KmAnnotationArgument annotationArgument) {
        if (annotationArgument instanceof KmAnnotationArgument.ArrayValue) {
            List<KmAnnotationArgument> value = ((KmAnnotationArgument.ArrayValue)annotationArgument).getElements();
            KotlinMetadataWriter.appendKmList(indent, "ArrayValue", sb, value, (newIndent, annoArg) -> KotlinMetadataWriter.appendKmArgument(newIndent, sb, annoArg));
        } else {
            sb.append(annotationArgument.toString());
        }
    }

    private static void appendKmVersionRequirement(String indent, StringBuilder sb, List<KmVersionRequirement> kmVersionRequirements) {
        KotlinMetadataWriter.appendKeyValue(indent, "versionRequirements", sb, (String newIndent) -> KotlinMetadataWriter.appendKmList(newIndent, "KmVersionRequirement", sb, kmVersionRequirements, (nextIndent, kmVersionRequirement) -> KotlinMetadataWriter.appendKmSection(nextIndent, "KmVersionRequirement", sb, nextNextIndent -> {
            KotlinMetadataWriter.appendKeyValue(nextNextIndent, "kind", sb, kmVersionRequirement.kind.name());
            KotlinMetadataWriter.appendKeyValue(nextNextIndent, "level", sb, kmVersionRequirement.level.name());
            KotlinMetadataWriter.appendKeyValue(nextNextIndent, "errorCode", sb, kmVersionRequirement.getErrorCode() == null ? "null" : kmVersionRequirement.getErrorCode().toString());
            KotlinMetadataWriter.appendKeyValue(nextNextIndent, "message", sb, kmVersionRequirement.getMessage());
            KotlinMetadataWriter.appendKeyValue(nextNextIndent, "version", sb, kmVersionRequirement.getVersion().toString());
        })));
    }

    private static void appendKmContract(String indent, StringBuilder sb, KmContract contract) {
        KotlinMetadataWriter.appendKmSection(indent, "KmContract", sb, newIndent -> KotlinMetadataWriter.appendKeyValue(newIndent, "effects", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmEffect", sb, contract.getEffects(), (nextNextIndent, effect) -> KotlinMetadataWriter.appendKmEffect(nextNextIndent, sb, effect))));
    }

    private static void appendKmEffect(String indent, StringBuilder sb, KmEffect effect) {
        KotlinMetadataWriter.appendKmSection(indent, "KmEffect", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "type", sb, effect.getType().toString());
            KotlinMetadataWriter.appendKeyValue(newIndent, "invocationKind", sb, effect.getInvocationKind() == null ? "null" : effect.getInvocationKind().toString());
            KotlinMetadataWriter.appendKeyValue(newIndent, "constructorArguments", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmEffectExpression", sb, effect.getConstructorArguments(), (nextNextIndent, expression) -> KotlinMetadataWriter.appendKmEffectExpression(nextNextIndent, sb, expression)));
            KmEffectExpression conclusion = effect.getConclusion();
            if (conclusion == null) {
                KotlinMetadataWriter.appendKeyValue(newIndent, "conclusion", sb, "null");
            } else {
                KotlinMetadataWriter.appendKeyValue(newIndent, "conclusion", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmEffectExpression(nextIndent, sb, conclusion));
            }
        });
    }

    private static void appendKmEffectExpression(String indent, StringBuilder sb, KmEffectExpression expression) {
        KotlinMetadataWriter.appendKmSection(indent, "KmEffectExpression", sb, newIndent -> {
            KotlinMetadataWriter.appendKeyValue(newIndent, "flags", sb, expression.getFlags() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "foo", sb, expression.getParameterIndex() == null ? "null" : expression.getParameterIndex() + "");
            KotlinMetadataWriter.appendKeyValue(newIndent, "constantValue", sb, expression.getConstantValue() == null ? "null" : expression.getConstantValue().toString());
            KotlinMetadataWriter.appendKeyValue(newIndent, "isInstanceType", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmType(nextIndent, sb, expression.isInstanceType()));
            KotlinMetadataWriter.appendKeyValue(newIndent, "andArguments", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmEffectExpression", sb, expression.getAndArguments(), (nextNextIndent, expr) -> KotlinMetadataWriter.appendKmEffectExpression(nextNextIndent, sb, expr)));
            KotlinMetadataWriter.appendKeyValue(newIndent, "orArguments", sb, (String nextIndent) -> KotlinMetadataWriter.appendKmList(nextIndent, "KmEffectExpression", sb, expression.getOrArguments(), (nextNextIndent, expr) -> KotlinMetadataWriter.appendKmEffectExpression(nextNextIndent, sb, expr)));
        });
    }
}

