/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.kotlin.KotlinTypeReference;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.List;

public class KotlinMultiFileClassFacadeInfo
implements KotlinClassLevelInfo {
    private final List<KotlinTypeReference> partClassNames;
    private final String packageName;
    private final int[] metadataVersion;

    private KotlinMultiFileClassFacadeInfo(List<KotlinTypeReference> partClassNames, String packageName, int[] metadataVersion) {
        this.partClassNames = partClassNames;
        this.packageName = packageName;
        this.metadataVersion = metadataVersion;
    }

    static KotlinMultiFileClassFacadeInfo create(KotlinClassMetadata.MultiFileClassFacade kmMultiFileClassFacade, String packageName, int[] metadataVersion, DexItemFactory factory) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String partClassName : kmMultiFileClassFacade.getPartClassNames()) {
            builder.add(KotlinTypeReference.fromBinaryName(partClassName, factory, partClassName));
        }
        return new KotlinMultiFileClassFacadeInfo((List<KotlinTypeReference>)((Object)builder.build()), packageName, metadataVersion);
    }

    @Override
    public boolean isMultiFileFacade() {
        return true;
    }

    @Override
    public KotlinMultiFileClassFacadeInfo asMultiFileFacade() {
        return this;
    }

    @Override
    public Pair<KotlinClassHeader, Boolean> rewrite(DexClass clazz, AppView<?> appView, NamingLens namingLens) {
        ArrayList<String> partClassNameStrings = new ArrayList<String>(this.partClassNames.size());
        boolean rewritten = false;
        for (KotlinTypeReference partClassName : this.partClassNames) {
            rewritten |= partClassName.toRenamedBinaryNameOrDefault(binaryName -> {
                if (binaryName != null) {
                    partClassNameStrings.add((String)binaryName);
                }
            }, appView, namingLens, null);
        }
        KotlinClassMetadata.MultiFileClassFacade.Writer writer = new KotlinClassMetadata.MultiFileClassFacade.Writer();
        return Pair.create(writer.write(partClassNameStrings).getHeader(), rewritten);
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public int[] getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.partClassNames, type -> type::trace, definitionSupplier);
    }
}

