/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmPackage;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmPackageExtensionVisitor;
import com.android.tools.r8.kotlin.KotlinDeclarationContainerInfo;
import com.android.tools.r8.kotlin.KotlinJvmSignatureExtensionInformation;
import com.android.tools.r8.kotlin.KotlinLocalDelegatedPropertyInfo;
import com.android.tools.r8.kotlin.KotlinMetadataMembersTracker;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import java.util.HashMap;
import java.util.function.Consumer;

public class KotlinPackageInfo
implements EnqueuerMetadataTraceable {
    private final String moduleName;
    private final KotlinDeclarationContainerInfo containerInfo;
    private final KotlinLocalDelegatedPropertyInfo localDelegatedProperties;
    private final KotlinMetadataMembersTracker originalMembersWithKotlinInfo;

    private KotlinPackageInfo(String moduleName, KotlinDeclarationContainerInfo containerInfo, KotlinLocalDelegatedPropertyInfo localDelegatedProperties, KotlinMetadataMembersTracker originalMembersWithKotlinInfo) {
        this.moduleName = moduleName;
        this.containerInfo = containerInfo;
        this.localDelegatedProperties = localDelegatedProperties;
        this.originalMembersWithKotlinInfo = originalMembersWithKotlinInfo;
    }

    public static KotlinPackageInfo create(KmPackage kmPackage, DexClass clazz, AppView<?> appView, Consumer<DexEncodedMethod> keepByteCode, KotlinJvmSignatureExtensionInformation extensionInformation) {
        HashMap<String, DexEncodedField> fieldMap = new HashMap<String, DexEncodedField>();
        for (DexEncodedField dexEncodedField : clazz.fields()) {
            fieldMap.put(KotlinMetadataUtils.toJvmFieldSignature((DexField)dexEncodedField.getReference()).asString(), dexEncodedField);
        }
        HashMap<String, DexEncodedMethod> methodMap = new HashMap<String, DexEncodedMethod>();
        for (DexEncodedMethod method : clazz.methods()) {
            methodMap.put(KotlinMetadataUtils.toJvmMethodSignature((DexMethod)method.getReference()).asString(), method);
        }
        KotlinMetadataMembersTracker kotlinMetadataMembersTracker = new KotlinMetadataMembersTracker(appView);
        return new KotlinPackageInfo(JvmExtensionsKt.getModuleName(kmPackage), KotlinDeclarationContainerInfo.create(kmPackage, methodMap, fieldMap, appView.dexItemFactory(), appView.reporter(), keepByteCode, extensionInformation, kotlinMetadataMembersTracker), KotlinLocalDelegatedPropertyInfo.create(JvmExtensionsKt.getLocalDelegatedProperties(kmPackage), appView.dexItemFactory(), appView.reporter()), kotlinMetadataMembersTracker);
    }

    boolean rewrite(KmPackage kmPackage, DexClass clazz, AppView<?> appView, NamingLens namingLens) {
        KotlinMetadataMembersTracker rewrittenReferences = new KotlinMetadataMembersTracker(appView);
        boolean rewritten = this.containerInfo.rewrite(kmPackage::visitFunction, kmPackage::visitProperty, kmPackage::visitTypeAlias, clazz, appView, namingLens, rewrittenReferences);
        JvmPackageExtensionVisitor extensionVisitor = (JvmPackageExtensionVisitor)kmPackage.visitExtensions(JvmPackageExtensionVisitor.TYPE);
        extensionVisitor.visitModuleName(this.moduleName);
        extensionVisitor.visitEnd();
        return (rewritten |= this.localDelegatedProperties.rewrite(extensionVisitor::visitLocalDelegatedProperty, appView, namingLens)) || !this.originalMembersWithKotlinInfo.isEqual(rewrittenReferences, appView);
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        this.containerInfo.trace(definitionSupplier);
        this.localDelegatedProperties.trace(definitionSupplier);
    }
}

