/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmPropertyVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmFieldSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinFieldLevelInfo;
import com.android.tools.r8.kotlin.KotlinJvmFieldSignatureInfo;
import com.android.tools.r8.kotlin.KotlinJvmMethodSignatureInfo;
import com.android.tools.r8.kotlin.KotlinMethodLevelInfo;
import com.android.tools.r8.kotlin.KotlinTypeInfo;
import com.android.tools.r8.kotlin.KotlinTypeParameterInfo;
import com.android.tools.r8.kotlin.KotlinValueParameterInfo;
import com.android.tools.r8.kotlin.KotlinVersionRequirementInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinPropertyInfo
implements KotlinFieldLevelInfo,
KotlinMethodLevelInfo {
    private final int flags;
    private final int getterFlags;
    private final int setterFlags;
    private final String name;
    private final KotlinTypeInfo returnType;
    private final KotlinTypeInfo receiverParameterType;
    private final KotlinValueParameterInfo setterParameter;
    private final List<KotlinTypeParameterInfo> typeParameters;
    private final KotlinVersionRequirementInfo versionRequirements;
    private final int jvmFlags;
    private final KotlinJvmFieldSignatureInfo fieldSignature;
    private final KotlinJvmMethodSignatureInfo getterSignature;
    private final KotlinJvmMethodSignatureInfo setterSignature;
    private final KotlinJvmMethodSignatureInfo syntheticMethodForAnnotations;
    private final KotlinJvmMethodSignatureInfo syntheticMethodForDelegate;

    private KotlinPropertyInfo(int flags, int getterFlags, int setterFlags, String name, KotlinTypeInfo returnType, KotlinTypeInfo receiverParameterType, KotlinValueParameterInfo setterParameter, List<KotlinTypeParameterInfo> typeParameters, KotlinVersionRequirementInfo versionRequirements, int jvmFlags, KotlinJvmFieldSignatureInfo fieldSignature, KotlinJvmMethodSignatureInfo getterSignature, KotlinJvmMethodSignatureInfo setterSignature, KotlinJvmMethodSignatureInfo syntheticMethodForAnnotations, KotlinJvmMethodSignatureInfo syntheticMethodForDelegate) {
        this.flags = flags;
        this.getterFlags = getterFlags;
        this.setterFlags = setterFlags;
        this.name = name;
        this.returnType = returnType;
        this.receiverParameterType = receiverParameterType;
        this.setterParameter = setterParameter;
        this.typeParameters = typeParameters;
        this.versionRequirements = versionRequirements;
        this.jvmFlags = jvmFlags;
        this.fieldSignature = fieldSignature;
        this.getterSignature = getterSignature;
        this.setterSignature = setterSignature;
        this.syntheticMethodForAnnotations = syntheticMethodForAnnotations;
        this.syntheticMethodForDelegate = syntheticMethodForDelegate;
    }

    public static KotlinPropertyInfo create(KmProperty kmProperty, DexItemFactory factory, Reporter reporter) {
        return new KotlinPropertyInfo(kmProperty.getFlags(), kmProperty.getGetterFlags(), kmProperty.getSetterFlags(), kmProperty.getName(), KotlinTypeInfo.create(kmProperty.getReturnType(), factory, reporter), KotlinTypeInfo.create(kmProperty.getReceiverParameterType(), factory, reporter), KotlinValueParameterInfo.create(kmProperty.getSetterParameter(), factory, reporter), KotlinTypeParameterInfo.create(kmProperty.getTypeParameters(), factory, reporter), KotlinVersionRequirementInfo.create(kmProperty.getVersionRequirements()), JvmExtensionsKt.getJvmFlags(kmProperty), KotlinJvmFieldSignatureInfo.create(JvmExtensionsKt.getFieldSignature(kmProperty), factory), KotlinJvmMethodSignatureInfo.create(JvmExtensionsKt.getGetterSignature(kmProperty), factory), KotlinJvmMethodSignatureInfo.create(JvmExtensionsKt.getSetterSignature(kmProperty), factory), KotlinJvmMethodSignatureInfo.create(JvmExtensionsKt.getSyntheticMethodForAnnotations(kmProperty), factory), KotlinJvmMethodSignatureInfo.create(JvmExtensionsKt.getSyntheticMethodForDelegate(kmProperty), factory));
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public KotlinPropertyInfo asProperty() {
        return this;
    }

    public KotlinJvmFieldSignatureInfo getFieldSignature() {
        return this.fieldSignature;
    }

    public KotlinJvmMethodSignatureInfo getGetterSignature() {
        return this.getterSignature;
    }

    public KotlinJvmMethodSignatureInfo getSetterSignature() {
        return this.setterSignature;
    }

    boolean rewrite(KmVisitorProviders.KmPropertyVisitorProvider visitorProvider, DexEncodedField field, DexEncodedMethod getter, DexEncodedMethod setter, AppView<?> appView, NamingLens namingLens) {
        KmPropertyVisitor kmProperty = visitorProvider.get(this.flags, this.name, this.getterFlags, this.setterFlags);
        boolean rewritten = false;
        if (this.returnType != null) {
            rewritten = this.returnType.rewrite(kmProperty::visitReturnType, appView, namingLens);
        }
        if (this.receiverParameterType != null) {
            rewritten |= this.receiverParameterType.rewrite(kmProperty::visitReceiverParameterType, appView, namingLens);
        }
        if (this.setterParameter != null) {
            rewritten |= this.setterParameter.rewrite(kmProperty::visitSetterParameter, appView, namingLens);
        }
        for (KotlinTypeParameterInfo typeParameter : this.typeParameters) {
            rewritten |= typeParameter.rewrite(kmProperty::visitTypeParameter, appView, namingLens);
        }
        rewritten |= this.versionRequirements.rewrite(kmProperty::visitVersionRequirement);
        JvmPropertyExtensionVisitor extensionVisitor = (JvmPropertyExtensionVisitor)kmProperty.visitExtensions(JvmPropertyExtensionVisitor.TYPE);
        if (extensionVisitor != null) {
            Box rewrittenFieldSignature = new Box();
            if (this.fieldSignature != null) {
                rewritten |= this.fieldSignature.rewrite(rewrittenFieldSignature::set, field, appView, namingLens);
            }
            Box rewrittenGetterSignature = new Box();
            if (this.getterSignature != null) {
                rewritten |= this.getterSignature.rewrite(rewrittenGetterSignature::set, getter, appView, namingLens);
            }
            Box rewrittenSetterSignature = new Box();
            if (this.setterSignature != null) {
                rewritten |= this.setterSignature.rewrite(rewrittenSetterSignature::set, setter, appView, namingLens);
            }
            extensionVisitor.visit(this.jvmFlags, (JvmFieldSignature)rewrittenFieldSignature.get(), (JvmMethodSignature)rewrittenGetterSignature.get(), (JvmMethodSignature)rewrittenSetterSignature.get());
            if (this.syntheticMethodForAnnotations != null) {
                rewritten |= this.syntheticMethodForAnnotations.rewrite(extensionVisitor::visitSyntheticMethodForAnnotations, null, appView, namingLens);
            }
            if (this.syntheticMethodForDelegate != null) {
                rewritten |= this.syntheticMethodForDelegate.rewrite(extensionVisitor::visitSyntheticMethodForDelegate, null, appView, namingLens);
            }
        }
        return rewritten;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        if (this.returnType != null) {
            this.returnType.trace(definitionSupplier);
        }
        if (this.receiverParameterType != null) {
            this.receiverParameterType.trace(definitionSupplier);
        }
        if (this.setterParameter != null) {
            this.setterParameter.trace(definitionSupplier);
        }
        FunctionUtils.forEachApply(this.typeParameters, param -> param::trace, definitionSupplier);
        if (this.fieldSignature != null) {
            this.fieldSignature.trace(definitionSupplier);
        }
        if (this.getterSignature != null) {
            this.getterSignature.trace(definitionSupplier);
        }
        if (this.setterSignature != null) {
            this.setterSignature.trace(definitionSupplier);
        }
        if (this.syntheticMethodForAnnotations != null) {
            this.syntheticMethodForAnnotations.trace(definitionSupplier);
        }
        if (this.syntheticMethodForDelegate != null) {
            this.syntheticMethodForDelegate.trace(definitionSupplier);
        }
    }
}

