/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeAlias;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeAliasVisitor;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinAnnotationInfo;
import com.android.tools.r8.kotlin.KotlinTypeInfo;
import com.android.tools.r8.kotlin.KotlinTypeParameterInfo;
import com.android.tools.r8.kotlin.KotlinVersionRequirementInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinTypeAliasInfo
implements EnqueuerMetadataTraceable {
    private final int flags;
    private final String name;
    private final KotlinTypeInfo underlyingType;
    private final KotlinTypeInfo expandedType;
    private final List<KotlinTypeParameterInfo> typeParameters;
    private final List<KotlinAnnotationInfo> annotations;
    private final KotlinVersionRequirementInfo versionRequirements;

    private KotlinTypeAliasInfo(int flags, String name, KotlinTypeInfo underlyingType, KotlinTypeInfo expandedType, List<KotlinTypeParameterInfo> typeParameters, List<KotlinAnnotationInfo> annotations, KotlinVersionRequirementInfo versionRequirements) {
        this.flags = flags;
        this.name = name;
        assert (underlyingType != null);
        assert (expandedType != null);
        this.underlyingType = underlyingType;
        this.expandedType = expandedType;
        this.typeParameters = typeParameters;
        this.annotations = annotations;
        this.versionRequirements = versionRequirements;
    }

    public static KotlinTypeAliasInfo create(KmTypeAlias alias, DexItemFactory factory, Reporter reporter) {
        return new KotlinTypeAliasInfo(alias.getFlags(), alias.getName(), KotlinTypeInfo.create(alias.underlyingType, factory, reporter), KotlinTypeInfo.create(alias.expandedType, factory, reporter), KotlinTypeParameterInfo.create(alias.getTypeParameters(), factory, reporter), KotlinAnnotationInfo.create(alias.getAnnotations(), factory), KotlinVersionRequirementInfo.create(alias.getVersionRequirements()));
    }

    boolean rewrite(KmVisitorProviders.KmTypeAliasVisitorProvider visitorProvider, AppView<?> appView, NamingLens namingLens) {
        KmTypeAliasVisitor kmTypeAliasVisitor = visitorProvider.get(this.flags, this.name);
        boolean rewritten = this.underlyingType.rewrite(kmTypeAliasVisitor::visitUnderlyingType, appView, namingLens);
        rewritten |= this.expandedType.rewrite(kmTypeAliasVisitor::visitExpandedType, appView, namingLens);
        for (KotlinTypeParameterInfo typeParameter : this.typeParameters) {
            rewritten |= typeParameter.rewrite(kmTypeAliasVisitor::visitTypeParameter, appView, namingLens);
        }
        for (KotlinAnnotationInfo annotation : this.annotations) {
            rewritten |= annotation.rewrite(kmTypeAliasVisitor::visitAnnotation, appView, namingLens);
        }
        return rewritten |= this.versionRequirements.rewrite(kmTypeAliasVisitor::visitVersionRequirement);
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        this.underlyingType.trace(definitionSupplier);
        this.expandedType.trace(definitionSupplier);
        FunctionUtils.forEachApply(this.typeParameters, typeParam -> typeParam::trace, definitionSupplier);
        FunctionUtils.forEachApply(this.annotations, annotation -> annotation::trace, definitionSupplier);
    }
}

