/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmType;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeProjection;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmTypeExtensionVisitor;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinAnnotationInfo;
import com.android.tools.r8.kotlin.KotlinClassifierInfo;
import com.android.tools.r8.kotlin.KotlinFlexibleTypeUpperBoundInfo;
import com.android.tools.r8.kotlin.KotlinTypeProjectionInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinTypeInfo
implements EnqueuerMetadataTraceable {
    private static final List<KotlinTypeProjectionInfo> EMPTY_ARGUMENTS = ImmutableList.of();
    private final int flags;
    private final KotlinClassifierInfo classifier;
    private final KotlinTypeInfo abbreviatedType;
    private final KotlinTypeInfo outerType;
    private final List<KotlinTypeProjectionInfo> arguments;
    private final List<KotlinAnnotationInfo> annotations;
    private final KotlinFlexibleTypeUpperBoundInfo flexibleTypeUpperBound;
    private final boolean isRaw;

    KotlinTypeInfo(int flags, KotlinClassifierInfo classifier, KotlinTypeInfo abbreviatedType, KotlinTypeInfo outerType, List<KotlinTypeProjectionInfo> arguments, List<KotlinAnnotationInfo> annotations, KotlinFlexibleTypeUpperBoundInfo flexibleTypeUpperBound, boolean isRaw) {
        this.flags = flags;
        this.classifier = classifier;
        this.abbreviatedType = abbreviatedType;
        this.outerType = outerType;
        this.arguments = arguments;
        this.annotations = annotations;
        this.flexibleTypeUpperBound = flexibleTypeUpperBound;
        this.isRaw = isRaw;
    }

    static KotlinTypeInfo create(KmType kmType, DexItemFactory factory, Reporter reporter) {
        if (kmType == null) {
            return null;
        }
        return new KotlinTypeInfo(kmType.getFlags(), KotlinClassifierInfo.create(kmType.classifier, factory, reporter), KotlinTypeInfo.create(kmType.getAbbreviatedType(), factory, reporter), KotlinTypeInfo.create(kmType.getOuterType(), factory, reporter), KotlinTypeInfo.getArguments(kmType.getArguments(), factory, reporter), KotlinAnnotationInfo.create(JvmExtensionsKt.getAnnotations(kmType), factory), KotlinFlexibleTypeUpperBoundInfo.create(kmType.getFlexibleTypeUpperBound(), factory, reporter), JvmExtensionsKt.isRaw(kmType));
    }

    static List<KotlinTypeProjectionInfo> getArguments(List<KmTypeProjection> projections, DexItemFactory factory, Reporter reporter) {
        if (projections.isEmpty()) {
            return EMPTY_ARGUMENTS;
        }
        ImmutableList.Builder arguments = ImmutableList.builder();
        for (KmTypeProjection projection : projections) {
            arguments.add(KotlinTypeProjectionInfo.create(projection, factory, reporter));
        }
        return arguments.build();
    }

    boolean rewrite(KmVisitorProviders.KmTypeVisitorProvider visitorProvider, AppView<?> appView, NamingLens namingLens) {
        KmTypeVisitor kmTypeVisitor = visitorProvider.get(this.flags);
        boolean rewritten = this.classifier.rewrite(kmTypeVisitor, appView, namingLens);
        if (this.abbreviatedType != null) {
            rewritten |= this.abbreviatedType.rewrite(kmTypeVisitor::visitAbbreviatedType, appView, namingLens);
        }
        if (this.outerType != null) {
            rewritten |= this.outerType.rewrite(kmTypeVisitor::visitOuterType, appView, namingLens);
        }
        for (KotlinTypeProjectionInfo argument : this.arguments) {
            rewritten |= argument.rewrite(kmTypeVisitor::visitArgument, kmTypeVisitor::visitStarProjection, appView, namingLens);
        }
        rewritten |= this.flexibleTypeUpperBound.rewrite(kmTypeVisitor::visitFlexibleTypeUpperBound, appView, namingLens);
        if (this.annotations.isEmpty() && !this.isRaw) {
            return rewritten;
        }
        JvmTypeExtensionVisitor extensionVisitor = (JvmTypeExtensionVisitor)kmTypeVisitor.visitExtensions(JvmTypeExtensionVisitor.TYPE);
        if (extensionVisitor != null) {
            for (KotlinAnnotationInfo annotation : this.annotations) {
                rewritten |= annotation.rewrite(extensionVisitor::visitAnnotation, appView, namingLens);
            }
            extensionVisitor.visit(this.isRaw);
        }
        return rewritten;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        this.classifier.trace(definitionSupplier);
        if (this.abbreviatedType != null) {
            this.abbreviatedType.trace(definitionSupplier);
        }
        if (this.outerType != null) {
            this.outerType.trace(definitionSupplier);
        }
        FunctionUtils.forEachApply(this.arguments, argument -> argument::trace, definitionSupplier);
        this.flexibleTypeUpperBound.trace(definitionSupplier);
        FunctionUtils.forEachApply(this.annotations, annotation -> annotation::trace, definitionSupplier);
    }

    public DexType rewriteType(GraphLens graphLens) {
        return this.classifier.rewriteType(graphLens);
    }
}

