/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmType;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeParameter;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeParameterVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmVariance;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmTypeParameterExtensionVisitor;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinAnnotationInfo;
import com.android.tools.r8.kotlin.KotlinTypeInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinTypeParameterInfo
implements EnqueuerMetadataTraceable {
    private static final List<KotlinTypeParameterInfo> EMPTY_TYPE_PARAMETERS = ImmutableList.of();
    private static final List<KotlinTypeInfo> EMPTY_UPPER_BOUNDS = ImmutableList.of();
    private final int flags;
    private final int id;
    private final String name;
    private final KmVariance variance;
    private final List<KotlinTypeInfo> originalUpperBounds;
    private final List<KotlinAnnotationInfo> annotations;

    private KotlinTypeParameterInfo(int flags, int id, String name, KmVariance variance, List<KotlinTypeInfo> originalUpperBounds, List<KotlinAnnotationInfo> annotations) {
        this.flags = flags;
        this.id = id;
        this.name = name;
        this.variance = variance;
        this.originalUpperBounds = originalUpperBounds;
        this.annotations = annotations;
    }

    private static KotlinTypeParameterInfo create(KmTypeParameter kmTypeParameter, DexItemFactory factory, Reporter reporter) {
        return new KotlinTypeParameterInfo(kmTypeParameter.getFlags(), kmTypeParameter.getId(), kmTypeParameter.getName(), kmTypeParameter.getVariance(), KotlinTypeParameterInfo.getUpperBounds(kmTypeParameter.getUpperBounds(), factory, reporter), KotlinAnnotationInfo.create(JvmExtensionsKt.getAnnotations(kmTypeParameter), factory));
    }

    static List<KotlinTypeParameterInfo> create(List<KmTypeParameter> kmTypeParameters, DexItemFactory factory, Reporter reporter) {
        if (kmTypeParameters.isEmpty()) {
            return EMPTY_TYPE_PARAMETERS;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmTypeParameter kmTypeParameter : kmTypeParameters) {
            builder.add(KotlinTypeParameterInfo.create(kmTypeParameter, factory, reporter));
        }
        return builder.build();
    }

    private static List<KotlinTypeInfo> getUpperBounds(List<KmType> upperBounds, DexItemFactory factory, Reporter reporter) {
        if (upperBounds.isEmpty()) {
            return EMPTY_UPPER_BOUNDS;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmType upperBound : upperBounds) {
            builder.add(KotlinTypeInfo.create(upperBound, factory, reporter));
        }
        return builder.build();
    }

    boolean rewrite(KmVisitorProviders.KmTypeParameterVisitorProvider visitorProvider, AppView<?> appView, NamingLens namingLens) {
        KmTypeParameterVisitor kmTypeParameterVisitor = visitorProvider.get(this.flags, this.name, this.id, this.variance);
        boolean rewritten = false;
        for (KotlinTypeInfo originalUpperBound : this.originalUpperBounds) {
            rewritten |= originalUpperBound.rewrite(kmTypeParameterVisitor::visitUpperBound, appView, namingLens);
        }
        if (this.annotations.isEmpty()) {
            return rewritten;
        }
        JvmTypeParameterExtensionVisitor extensionVisitor = (JvmTypeParameterExtensionVisitor)kmTypeParameterVisitor.visitExtensions(JvmTypeParameterExtensionVisitor.TYPE);
        if (extensionVisitor != null) {
            for (KotlinAnnotationInfo annotation : this.annotations) {
                rewritten |= annotation.rewrite(extensionVisitor::visitAnnotation, appView, namingLens);
            }
        }
        return rewritten;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.originalUpperBounds, upperBound -> upperBound::trace, definitionSupplier);
        FunctionUtils.forEachApply(this.annotations, annotation -> annotation::trace, definitionSupplier);
    }
}

