/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmVersion;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmVersionRequirement;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmVersionRequirementLevel;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmVersionRequirementVersionKind;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmVersionRequirementVisitor;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import java.util.List;

class KotlinVersionRequirementInfo {
    private static final KotlinVersionRequirementInfo NO_VERSION_REQUIREMENTS = new KotlinVersionRequirementInfo(ImmutableList.of());
    private final List<KotlinVersionRequirementPoint> versionRequirements;

    private KotlinVersionRequirementInfo(List<KotlinVersionRequirementPoint> versionRequirements) {
        this.versionRequirements = versionRequirements;
    }

    static KotlinVersionRequirementInfo create(List<KmVersionRequirement> kmVersionRequirements) {
        if (kmVersionRequirements.isEmpty()) {
            return NO_VERSION_REQUIREMENTS;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmVersionRequirement kmVersionRequirement : kmVersionRequirements) {
            builder.add(KotlinVersionRequirementPoint.create(kmVersionRequirement));
        }
        return new KotlinVersionRequirementInfo((List<KotlinVersionRequirementPoint>)((Object)builder.build()));
    }

    boolean rewrite(KmVisitorProviders.KmVersionRequirementVisitorProvider visitorProvider) {
        if (this == NO_VERSION_REQUIREMENTS) {
            return false;
        }
        for (KotlinVersionRequirementPoint versionRequirement : this.versionRequirements) {
            versionRequirement.rewrite(visitorProvider.get());
        }
        return false;
    }

    private static class KotlinVersionRequirementPoint {
        private final Integer errorCode;
        private final KmVersionRequirementVersionKind kind;
        private final KmVersionRequirementLevel level;
        private final String message;
        private final KmVersion version;

        private KotlinVersionRequirementPoint(KmVersionRequirementVersionKind kind, KmVersionRequirementLevel level, Integer errorCode, String message, KmVersion version) {
            this.errorCode = errorCode;
            this.kind = kind;
            this.level = level;
            this.message = message;
            this.version = version;
        }

        private static KotlinVersionRequirementPoint create(KmVersionRequirement kmVersionRequirement) {
            return new KotlinVersionRequirementPoint(kmVersionRequirement.kind, kmVersionRequirement.level, kmVersionRequirement.getErrorCode(), kmVersionRequirement.getMessage(), kmVersionRequirement.version);
        }

        private void rewrite(KmVersionRequirementVisitor visitor) {
            visitor.visit(this.kind, this.level, this.errorCode, this.message);
            visitor.visitVersion(this.version.getMajor(), this.version.getMinor(), this.version.getPatch());
            visitor.visitEnd();
        }
    }
}

