/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.naming.mappinginformation.OutlineCallsiteMappingInformation;
import com.android.tools.r8.naming.mappinginformation.RewriteFrameMappingInformation;
import com.android.tools.r8.utils.ChainableStringConsumer;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ClassNamingForNameMapper
implements ClassNaming {
    public final String originalName;
    public final String renamedName;
    private final ImmutableMap<MemberNaming.MethodSignature, MemberNaming> methodMembers;
    private final ImmutableMap<MemberNaming.FieldSignature, MemberNaming> fieldMembers;
    public final Map<String, MappedRangesOfName> mappedRangesByRenamedName;
    public final Map<String, List<MemberNaming>> mappedFieldNamingsByName;
    private final List<MappingInformation> additionalMappingInfo;

    static Builder builder(String renamedName, String originalName) {
        return new Builder(renamedName, originalName);
    }

    private ClassNamingForNameMapper(String renamedName, String originalName, Map<MemberNaming.MethodSignature, MemberNaming> methodMembers, Map<MemberNaming.FieldSignature, MemberNaming> fieldMembers, Map<String, MappedRangesOfName> mappedRangesByRenamedName, Map<String, List<MemberNaming>> mappedFieldNamingsByName, List<MappingInformation> additionalMappingInfo) {
        this.renamedName = renamedName;
        this.originalName = originalName;
        this.methodMembers = ImmutableMap.copyOf(methodMembers);
        this.fieldMembers = ImmutableMap.copyOf(fieldMembers);
        this.mappedRangesByRenamedName = mappedRangesByRenamedName;
        this.mappedFieldNamingsByName = mappedFieldNamingsByName;
        this.additionalMappingInfo = additionalMappingInfo;
    }

    public List<MappingInformation> getAdditionalMappingInfo() {
        return Collections.unmodifiableList(this.additionalMappingInfo);
    }

    public MappedRangesOfName getMappedRangesForRenamedName(String renamedName) {
        return this.mappedRangesByRenamedName.get(renamedName);
    }

    @Override
    public MemberNaming lookup(MemberNaming.Signature renamedSignature) {
        if (renamedSignature.kind() == MemberNaming.Signature.SignatureKind.METHOD) {
            assert (renamedSignature instanceof MemberNaming.MethodSignature);
            return this.methodMembers.get(renamedSignature);
        }
        assert (renamedSignature.kind() == MemberNaming.Signature.SignatureKind.FIELD);
        assert (renamedSignature instanceof MemberNaming.FieldSignature);
        return this.fieldMembers.get(renamedSignature);
    }

    @Override
    public MemberNaming lookupByOriginalSignature(MemberNaming.Signature original) {
        if (original.kind() == MemberNaming.Signature.SignatureKind.METHOD) {
            for (MemberNaming memberNaming : this.methodMembers.values()) {
                if (!memberNaming.signature.equals(original)) continue;
                return memberNaming;
            }
            return null;
        }
        assert (original.kind() == MemberNaming.Signature.SignatureKind.FIELD);
        for (MemberNaming memberNaming : this.fieldMembers.values()) {
            if (!memberNaming.signature.equals(original)) continue;
            return memberNaming;
        }
        return null;
    }

    public List<MemberNaming> lookupByOriginalName(String originalName) {
        ArrayList<MemberNaming> result = new ArrayList<MemberNaming>();
        for (MemberNaming naming : this.methodMembers.values()) {
            if (!naming.signature.name.equals(originalName)) continue;
            result.add(naming);
        }
        for (MemberNaming naming : this.fieldMembers.values()) {
            if (!naming.signature.name.equals(originalName)) continue;
            result.add(naming);
        }
        return result;
    }

    @Override
    public <T extends Throwable> void forAllMemberNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        this.forAllFieldNaming(consumer);
        this.forAllMethodNaming(consumer);
    }

    @Override
    public <T extends Throwable> void forAllFieldNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        for (MemberNaming naming : this.fieldMembers.values()) {
            consumer.accept(naming);
        }
    }

    public Collection<MemberNaming> allFieldNamings() {
        return this.fieldMembers.values();
    }

    @Override
    public <T extends Throwable> void forAllMethodNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        for (MemberNaming naming : this.methodMembers.values()) {
            consumer.accept(naming);
        }
    }

    public Collection<MemberNaming> allMethodNamings() {
        return this.methodMembers.values();
    }

    void write(ChainableStringConsumer consumer) {
        consumer.accept(this.originalName).accept(" -> ").accept(this.renamedName).accept(":\n");
        this.additionalMappingInfo.forEach(info -> consumer.accept("# " + info.serialize()).accept("\n"));
        this.forAllFieldNaming(m3 -> consumer.accept("    ").accept(m3.toString()).accept("\n"));
        ArrayList<MappedRange> mappedRangesSorted = new ArrayList<MappedRange>();
        for (MappedRangesOfName ranges : this.mappedRangesByRenamedName.values()) {
            mappedRangesSorted.addAll(ranges.mappedRanges);
        }
        mappedRangesSorted.sort(Comparator.comparingInt(range -> ((MappedRange)range).sequenceNumber));
        for (MappedRange range2 : mappedRangesSorted) {
            consumer.accept("    ").accept(range2.toString()).accept("\n");
            for (MappingInformation info2 : range2.additionalMappingInfo) {
                consumer.accept("      # ").accept(info2.serialize()).accept("\n");
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.write(ChainableStringConsumer.wrap(builder::append));
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassNamingForNameMapper)) {
            return false;
        }
        ClassNamingForNameMapper that = (ClassNamingForNameMapper)o;
        return this.originalName.equals(that.originalName) && this.renamedName.equals(that.renamedName) && this.methodMembers.equals(that.methodMembers) && this.fieldMembers.equals(that.fieldMembers) && this.mappedRangesByRenamedName.equals(that.mappedRangesByRenamedName);
    }

    public int hashCode() {
        int result = this.originalName.hashCode();
        result = 31 * result + this.renamedName.hashCode();
        result = 31 * result + this.methodMembers.hashCode();
        result = 31 * result + this.fieldMembers.hashCode();
        result = 31 * result + this.mappedRangesByRenamedName.hashCode();
        return result;
    }

    public static class MappedRange {
        private static int nextSequenceNumber = 0;
        public final Range minifiedRange;
        public final MemberNaming.MethodSignature signature;
        public final Range originalRange;
        public final String renamedName;
        private final int sequenceNumber = this.getNextSequenceNumber();
        private List<MappingInformation> additionalMappingInfo = new ArrayList<MappingInformation>();

        private synchronized int getNextSequenceNumber() {
            return nextSequenceNumber++;
        }

        private MappedRange(Range minifiedRange, MemberNaming.MethodSignature signature, Range originalRange, String renamedName) {
            this.minifiedRange = minifiedRange;
            this.signature = signature;
            this.originalRange = originalRange;
            this.renamedName = renamedName;
        }

        public void addMappingInformation(MappingInformation info, Consumer<MappingInformation> onProhibitedAddition) {
            for (MappingInformation existing : this.additionalMappingInfo) {
                if (existing.allowOther(info)) continue;
                onProhibitedAddition.accept(existing);
                return;
            }
            this.additionalMappingInfo.add(info);
        }

        public boolean isCompilerSynthesized() {
            for (MappingInformation info : this.additionalMappingInfo) {
                if (!info.isCompilerSynthesizedMappingInformation() && !info.isOutlineMappingInformation()) continue;
                return true;
            }
            return false;
        }

        public boolean isOutlineFrame() {
            for (MappingInformation info : this.additionalMappingInfo) {
                if (!info.isOutlineMappingInformation()) continue;
                return true;
            }
            return false;
        }

        public <T> List<T> filter(Predicate<MappingInformation> predicate, Function<MappingInformation, T> mapper) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (MappingInformation mappingInformation : this.additionalMappingInfo) {
                if (!predicate.test(mappingInformation)) continue;
                builder.add(mapper.apply(mappingInformation));
            }
            return builder.build();
        }

        public List<OutlineCallsiteMappingInformation> getOutlineCallsiteInformation() {
            return this.filter(MappingInformation::isOutlineCallsiteInformation, MappingInformation::asOutlineCallsiteInformation);
        }

        public List<RewriteFrameMappingInformation> getRewriteFrameMappingInformation() {
            return this.filter(MappingInformation::isRewriteFrameMappingInformation, MappingInformation::asRewriteFrameMappingInformation);
        }

        public int getOriginalLineNumber(int lineNumberAfterMinification) {
            if (this.minifiedRange == null) {
                return lineNumberAfterMinification;
            }
            assert (this.minifiedRange.contains(lineNumberAfterMinification));
            if (this.originalRange == null) {
                return lineNumberAfterMinification;
            }
            if (this.originalRange.to == this.originalRange.from) {
                return this.originalRange.to;
            }
            return this.originalRange.from + lineNumberAfterMinification - this.minifiedRange.from;
        }

        public int getFirstLineNumberOfOriginalRange() {
            if (this.originalRange == null) {
                return 0;
            }
            return this.originalRange.from;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.minifiedRange != null) {
                builder.append(this.minifiedRange).append(':');
            }
            builder.append(this.signature);
            if (this.originalRange != null && !this.originalRange.equals(this.minifiedRange)) {
                builder.append(":").append(this.originalRange);
            }
            builder.append(" -> ").append(this.renamedName);
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappedRange)) {
                return false;
            }
            MappedRange that = (MappedRange)o;
            return Objects.equals(this.minifiedRange, that.minifiedRange) && Objects.equals(this.originalRange, that.originalRange) && this.signature.equals(that.signature) && this.renamedName.equals(that.renamedName);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.minifiedRange);
            result = 31 * result + Objects.hashCode(this.originalRange);
            result = 31 * result + this.signature.hashCode();
            result = 31 * result + this.renamedName.hashCode();
            return result;
        }

        public List<MappingInformation> getAdditionalMappingInfo() {
            return this.additionalMappingInfo;
        }
    }

    public static class MappedRangesOfName {
        private final List<MappedRange> mappedRanges;

        public MappedRangesOfName(List<MappedRange> mappedRanges) {
            this.mappedRanges = mappedRanges;
        }

        public MappedRange firstRangeForLine(int line) {
            MappedRange bestRange = null;
            for (MappedRange range : this.mappedRanges) {
                if (range.minifiedRange == null) {
                    if (bestRange != null) continue;
                    bestRange = range;
                    continue;
                }
                if (!range.minifiedRange.contains(line)) continue;
                return range;
            }
            return bestRange;
        }

        public List<MappedRange> allRangesForLine(int line) {
            return this.allRangesForLine(line, true);
        }

        public List<MappedRange> allRangesForLine(int line, boolean takeFirstWithNoLineRange) {
            MappedRange noLineRange = null;
            for (int i = 0; i < this.mappedRanges.size(); ++i) {
                int j;
                MappedRange rangeI = this.mappedRanges.get(i);
                if (rangeI.minifiedRange == null) {
                    if (noLineRange != null || !takeFirstWithNoLineRange) continue;
                    noLineRange = rangeI;
                    continue;
                }
                if (!rangeI.minifiedRange.contains(line)) continue;
                for (j = i + 1; j < this.mappedRanges.size() && Objects.equals(this.mappedRanges.get((int)j).minifiedRange, rangeI.minifiedRange); ++j) {
                }
                return this.mappedRanges.subList(i, j);
            }
            return noLineRange == null ? Collections.emptyList() : Collections.singletonList(noLineRange);
        }

        public List<MappedRange> getMappedRanges() {
            return this.mappedRanges;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappedRangesOfName that = (MappedRangesOfName)o;
            return this.mappedRanges.equals(that.mappedRanges);
        }

        public int hashCode() {
            return this.mappedRanges.hashCode();
        }
    }

    public static class Builder
    extends ClassNaming.Builder {
        private final String originalName;
        private final String renamedName;
        private final Map<MemberNaming.MethodSignature, MemberNaming> methodMembers = Maps.newHashMap();
        private final Map<MemberNaming.FieldSignature, MemberNaming> fieldMembers = Maps.newHashMap();
        private final Map<String, List<MappedRange>> mappedRangesByName = Maps.newHashMap();
        private final Map<String, List<MemberNaming>> mappedFieldNamingsByName = Maps.newHashMap();
        private final List<MappingInformation> additionalMappingInfo = new ArrayList<MappingInformation>();

        private Builder(String renamedName, String originalName) {
            this.originalName = originalName;
            this.renamedName = renamedName;
        }

        @Override
        public ClassNaming.Builder addMemberEntry(MemberNaming entry) {
            if (entry.isMethodNaming()) {
                this.methodMembers.put(entry.getRenamedSignature().asMethodSignature(), entry);
            } else {
                this.fieldMembers.put(entry.getRenamedSignature().asFieldSignature(), entry);
                this.mappedFieldNamingsByName.computeIfAbsent(entry.getRenamedName(), m3 -> new ArrayList()).add(entry);
            }
            return this;
        }

        @Override
        public ClassNamingForNameMapper build() {
            Map<String, MappedRangesOfName> map;
            if (this.mappedRangesByName.isEmpty()) {
                map = Collections.emptyMap();
            } else {
                map = new HashMap(this.mappedRangesByName.size());
                for (Map.Entry<String, List<MappedRange>> entry : this.mappedRangesByName.entrySet()) {
                    map.put(entry.getKey(), new MappedRangesOfName(entry.getValue()));
                }
            }
            return new ClassNamingForNameMapper(this.renamedName, this.originalName, this.methodMembers, this.fieldMembers, map, this.mappedFieldNamingsByName, this.additionalMappingInfo);
        }

        @Override
        public MappedRange addMappedRange(Range minifiedRange, MemberNaming.MethodSignature originalSignature, Range originalRange, String renamedName) {
            MappedRange range = new MappedRange(minifiedRange, originalSignature, originalRange, renamedName);
            this.mappedRangesByName.computeIfAbsent(renamedName, k -> new ArrayList()).add(range);
            return range;
        }

        @Override
        public void addMappingInformation(MappingInformation info, Consumer<MappingInformation> onProhibitedAddition) {
            for (MappingInformation existing : this.additionalMappingInfo) {
                if (existing.allowOther(info)) continue;
                onProhibitedAddition.accept(existing);
                return;
            }
            this.additionalMappingInfo.add(info);
        }
    }
}

