/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;

public class DictionaryReader
implements AutoCloseable {
    private final BufferedReader reader;
    private final Path path;

    public DictionaryReader(Path path) throws IOException {
        this.path = path;
        this.reader = Files.newBufferedReader(path);
    }

    public static ImmutableList<String> readAllNames(Path path, Reporter reporter) {
        if (path != null) {
            ImmutableList.Builder namesBuilder;
            block16: {
                HashSet<String> seenNames = new HashSet<String>();
                namesBuilder = new ImmutableList.Builder();
                try {
                    DictionaryReader reader;
                    block15: {
                        reader = new DictionaryReader(path);
                        Throwable throwable = null;
                        try {
                            String name = reader.readName(reporter);
                            while (!name.isEmpty()) {
                                if (!seenNames.add(name)) {
                                    reporter.error(new StringDiagnostic("Duplicate entry for '" + name + "' in dictionary", new PathOrigin(path)));
                                }
                                namesBuilder.add(name);
                                name = reader.readName(reporter);
                            }
                            if (throwable == null) break block15;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    reader.close();
                                }
                                throw throwable3;
                            }
                        }
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        break block16;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    reporter.error(new ExceptionDiagnostic(e, new PathOrigin(path)));
                }
            }
            return namesBuilder.build();
        }
        return ImmutableList.of();
    }

    public String readName(Reporter reporter) throws IOException {
        int readCharAsInt;
        assert (this.reader != null);
        StringBuilder name = new StringBuilder();
        int lineNumber = 1;
        while ((readCharAsInt = this.reader.read()) != -1) {
            boolean isValidEndOfLineInput;
            char readChar = (char)readCharAsInt;
            if (name.length() != 0 && Character.isJavaIdentifierPart(readChar) || name.length() == 0 && Character.isJavaIdentifierStart(readChar)) {
                name.append(readChar);
                continue;
            }
            boolean isCommentChar = readChar == '#';
            boolean bl = isValidEndOfLineInput = readChar == '\n' || readChar == '\r';
            if (isCommentChar || isValidEndOfLineInput) {
                if (isCommentChar) {
                    this.reader.readLine();
                }
                ++lineNumber;
            }
            if (isValidEndOfLineInput && name.length() != 0) {
                return name.toString();
            }
            name = new StringBuilder();
            if (isValidEndOfLineInput) continue;
            reporter.info(new StringDiagnostic("Invalid character in dictionary '" + readChar + "'", new PathOrigin(this.path), new TextPosition(0L, lineNumber, -1)));
            this.reader.readLine();
            ++lineNumber;
        }
        return name.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

