/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.DexItemBasedConstString;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.records.RecordCfToCfRewriter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

class IdentifierMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final ProguardClassFilter adaptClassStrings;
    private final RecordCfToCfRewriter recordCfToCfRewriter;
    private final NamingLens lens;

    IdentifierMinifier(AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        this.appView = appView;
        this.adaptClassStrings = appView.options().getProguardConfiguration().getAdaptClassStrings();
        this.recordCfToCfRewriter = RecordCfToCfRewriter.create(appView);
        this.lens = lens;
    }

    private void adaptClassStrings(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), clazz -> {
            if (this.adaptClassStrings.matches(clazz.type)) {
                for (DexEncodedField field : clazz.staticFields()) {
                    this.adaptClassStringsInStaticField(field);
                }
                clazz.forEachMethod(this::adaptClassStringsInMethod);
            }
        }, executorService);
    }

    private void adaptClassStringsInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        DexValue staticValue = encodedField.getStaticValue();
        if (staticValue.isDexValueString()) {
            DexString original = (DexString)staticValue.asDexValueString().getValue();
            encodedField.setStaticValue(new DexValue.DexValueString(this.getRenamedStringLiteral(original)));
        }
    }

    private void adaptClassStringsInMethod(DexEncodedMethod encodedMethod) {
        if (encodedMethod.shouldNotHaveCode()) {
            return;
        }
        Code code = encodedMethod.getCode();
        if (code == null) {
            return;
        }
        if (code.isDexCode()) {
            for (Instruction instruction : code.asDexCode().instructions) {
                if (!instruction.isConstString()) continue;
                ConstString cnst = instruction.asConstString();
                cnst.BBBB = this.getRenamedStringLiteral(cnst.getString());
            }
        } else if (code.isCfCode()) {
            for (CfInstruction instruction : code.asCfCode().getInstructions()) {
                if (!instruction.isConstString()) continue;
                CfConstString cnst = instruction.asConstString();
                cnst.setString(this.getRenamedStringLiteral(cnst.getString()));
            }
        } else assert (code.isCfWritableCode() || code.isDexWritableCode());
    }

    private DexString getRenamedStringLiteral(DexString originalLiteral) {
        String descriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(originalLiteral.toString());
        if (descriptor == null) {
            return originalLiteral;
        }
        DexType type = this.appView.dexItemFactory().createType(descriptor);
        DexType originalType = this.appView.graphLens().getOriginalType(type);
        if (originalType != type) {
            return originalLiteral;
        }
        DexType rewrittenType = this.appView.graphLens().lookupType(type);
        DexClass clazz = this.appView.appInfo().definitionForWithoutExistenceAssert(rewrittenType);
        if (clazz == null || clazz.isNotProgramClass()) {
            return originalLiteral;
        }
        DexString rewrittenString = this.lens.lookupClassDescriptor(rewrittenType);
        return rewrittenString == null ? originalLiteral : this.appView.dexItemFactory().createString(DescriptorUtils.descriptorToJavaType(rewrittenString.toString()));
    }

    private void replaceDexItemBasedConstString(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), clazz -> {
            for (DexEncodedField field : clazz.staticFields()) {
                this.replaceDexItemBasedConstStringInStaticField(field);
            }
            clazz.forEachProgramMethodMatching(DexEncodedMethod::hasCode, this::replaceDexItemBasedConstStringInMethod);
        }, executorService);
    }

    private void replaceDexItemBasedConstStringInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        DexValue staticValue = encodedField.getStaticValue();
        if (staticValue instanceof DexValue.DexItemBasedValueString) {
            DexValue.DexItemBasedValueString cnst = (DexValue.DexItemBasedValueString)staticValue;
            DexString replacement = cnst.getNameComputationInfo().computeNameFor((DexReference)cnst.getValue(), this.appView, this.appView.graphLens(), this.lens);
            encodedField.setStaticValue(new DexValue.DexValueString(replacement));
        }
    }

    private void replaceDexItemBasedConstStringInMethod(ProgramMethod programMethod) {
        Code code = ((DexEncodedMethod)programMethod.getDefinition()).getCode();
        assert (code != null);
        if (code.isDexCode()) {
            Instruction[] instructions = code.asDexCode().instructions;
            for (int i2 = 0; i2 < instructions.length; ++i2) {
                Instruction instruction2 = instructions[i2];
                if (!instruction2.isDexItemBasedConstString()) continue;
                DexItemBasedConstString cnst = instruction2.asDexItemBasedConstString();
                DexString replacement = cnst.getNameComputationInfo().computeNameFor(cnst.getItem(), this.appView, this.appView.graphLens(), this.lens);
                ConstString constString = new ConstString((int)cnst.AA, replacement);
                constString.setOffset(instruction2.getOffset());
                instructions[i2] = constString;
            }
        } else if (code.isCfCode()) {
            List<CfInstruction> instructions = code.asCfCode().getInstructions();
            List<CfInstruction> newInstructions = ListUtils.mapOrElse(instructions, (i, instruction) -> {
                if (instruction.isDexItemBasedConstString()) {
                    CfDexItemBasedConstString cnst = instruction.asDexItemBasedConstString();
                    return new CfConstString(cnst.getNameComputationInfo().computeNameFor(cnst.getItem(), this.appView, this.appView.graphLens(), this.lens));
                }
                if (this.recordCfToCfRewriter != null && instruction.isInvokeDynamic()) {
                    return this.recordCfToCfRewriter.rewriteRecordInvokeDynamic(instruction.asInvokeDynamic(), programMethod, this.lens);
                }
                return instruction;
            }, instructions);
            code.asCfCode().setInstructions(newInstructions);
        } else assert (code.isDefaultInstanceInitializerCode() || code.isThrowNullCode());
    }

    void run(ExecutorService executorService) throws ExecutionException {
        if (!this.adaptClassStrings.isEmpty()) {
            this.adaptClassStrings(executorService);
        }
        this.replaceDexItemBasedConstString(executorService);
    }
}

