/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.naming.IdentifierNameStringUtils;
import com.android.tools.r8.naming.dexitembasedstring.ClassNameComputationInfo;
import com.android.tools.r8.naming.identifiernamestring.IdentifierNameStringLookupResult;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class IdentifierNameStringMarker {
    private final AppView<AppInfoWithLiveness> appView;
    private final Object2BooleanMap<DexMember<?, ?>> identifierNameStrings;

    public IdentifierNameStringMarker(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.identifierNameStrings = appView.appInfo().identifierNameStrings;
    }

    private void decoupleIdentifierNameStringInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        if (!this.identifierNameStrings.containsKey(encodedField.getReference())) {
            return;
        }
        DexValue.DexValueString staticValue = encodedField.getStaticValue().asDexValueString();
        if (staticValue == null) {
            return;
        }
        DexString original = (DexString)staticValue.getValue();
        DexReference itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
        if (itemBasedString != null) {
            encodedField.setStaticValue(new DexValue.DexItemBasedValueString(itemBasedString, ClassNameComputationInfo.none()));
        }
    }

    private InstructionListIterator decoupleIdentifierNameStringForFieldPutInstruction(IRCode code, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, FieldInstruction instruction) {
        BasicBlock blockWithFieldInstruction;
        assert (instruction.isInstancePut() || instruction.isStaticPut());
        FieldInstruction fieldPut = instruction.asFieldInstruction();
        DexField field = fieldPut.getField();
        if (!this.identifierNameStrings.containsKey(field)) {
            return iterator2;
        }
        Value in = instruction.value();
        if (in.isDexItemBasedConstString()) {
            return iterator2;
        }
        if (!in.isConstString()) {
            this.warnUndeterminedIdentifierIfNecessary(field, code.context(), instruction, null);
            return iterator2;
        }
        DexString original = in.getConstInstruction().asConstString().getValue();
        DexReference itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
        if (itemBasedString == null) {
            this.warnUndeterminedIdentifierIfNecessary(field, code.context(), instruction, original);
            return iterator2;
        }
        assert (iterator2.peekPrevious() == fieldPut);
        iterator2.previous();
        Value newIn = code.createValue(in.getType(), in.getLocalInfo());
        DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, itemBasedString, ClassNameComputationInfo.none());
        decoupled.setPosition(fieldPut.getPosition());
        BasicBlock block = instruction.getBlock();
        BasicBlock basicBlock = blockWithFieldInstruction = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
        if (blockWithFieldInstruction != block) {
            iterator2 = block.listIterator(code, block.getInstructions().size() - 1);
            iterator2.add(decoupled);
            iterator2 = blockWithFieldInstruction.listIterator(code);
            assert (iterator2.peekNext() == fieldPut);
            iterator2.next();
        } else {
            iterator2.add(decoupled);
            assert (iterator2.peekNext() == fieldPut);
            iterator2.next();
        }
        if (instruction.isStaticPut()) {
            iterator2.replaceCurrentInstruction(new StaticPut(newIn, field));
        } else {
            assert (instruction.isInstancePut());
            InstancePut instancePut = instruction.asInstancePut();
            iterator2.replaceCurrentInstruction(new InstancePut(field, instancePut.object(), newIn));
        }
        return iterator2;
    }

    private InstructionListIterator decoupleIdentifierNameStringForInvokeInstruction(IRCode code, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, InvokeMethod invoke) {
        DexMethod invokedMethod = invoke.getInvokedMethod();
        boolean isClassNameComparison = IdentifierNameStringUtils.isClassNameComparison(invoke, this.appView.dexItemFactory());
        if (!this.identifierNameStrings.containsKey(invokedMethod) && !isClassNameComparison) {
            return iterator2;
        }
        List<Value> ins = invoke.arguments();
        Value[] changes = new Value[ins.size()];
        if (IdentifierNameStringUtils.isReflectionMethod(this.appView.dexItemFactory(), invokedMethod) || isClassNameComparison) {
            IdentifierNameStringLookupResult<?> identifierLookupResult = IdentifierNameStringUtils.identifyIdentifier(invoke, this.appView, code.context());
            if (identifierLookupResult == null) {
                this.warnUndeterminedIdentifierIfNecessary(invokedMethod, code.context(), invoke, null);
                return iterator2;
            }
            int identifierPosition = this.getIdentifierPositionInArguments(invoke);
            assert (identifierPosition >= 0);
            Value in2 = invoke.arguments().get(identifierPosition);
            if (in2.definition.isDexItemBasedConstString()) {
                return iterator2;
            }
            Value newIn = code.createValue(in2.getType(), in2.getLocalInfo());
            DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, (DexReference)identifierLookupResult.getReference(), ClassNameComputationInfo.none());
            changes[identifierPosition] = newIn;
            if (in2.numberOfAllUsers() == 1) {
                ConstString constString = in2.definition.asConstString();
                if (constString.getBlock() == invoke.getBlock()) {
                    iterator2.previousUntil(instruction -> instruction == constString);
                    Instruction current = (Instruction)iterator2.next();
                    assert (current == constString);
                    iterator2.replaceCurrentInstruction(decoupled);
                    iterator2.nextUntil(instruction -> instruction == invoke);
                } else {
                    in2.definition.replace(decoupled, code);
                }
            } else {
                BasicBlock blockWithInvoke;
                decoupled.setPosition(invoke.getPosition());
                assert (iterator2.peekPrevious() == invoke);
                iterator2.previous();
                BasicBlock block = invoke.getBlock();
                BasicBlock basicBlock = blockWithInvoke = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                if (blockWithInvoke != block) {
                    iterator2 = block.listIterator(code, block.getInstructions().size());
                    iterator2.previous();
                    iterator2.add(decoupled);
                    iterator2 = blockWithInvoke.listIterator(code);
                    assert (iterator2.peekNext() == invoke);
                    iterator2.next();
                } else {
                    iterator2.add(decoupled);
                    assert (iterator2.peekNext() == invoke);
                    iterator2.next();
                }
            }
        } else {
            for (int i = 0; i < ins.size(); ++i) {
                BasicBlock blockWithInvoke;
                Value in3 = ins.get(i);
                if (!in3.isConstString()) {
                    this.warnUndeterminedIdentifierIfNecessary(invokedMethod, code.context(), invoke, null);
                    continue;
                }
                DexString original = in3.getConstInstruction().asConstString().getValue();
                DexReference itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
                if (itemBasedString == null) {
                    this.warnUndeterminedIdentifierIfNecessary(invokedMethod, code.context(), invoke, original);
                    continue;
                }
                assert (iterator2.peekPrevious() == invoke);
                iterator2.previous();
                Value newIn = code.createValue(in3.getType(), in3.getLocalInfo());
                DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, itemBasedString, ClassNameComputationInfo.none());
                decoupled.setPosition(invoke.getPosition());
                changes[i] = newIn;
                BasicBlock block = invoke.getBlock();
                BasicBlock basicBlock = blockWithInvoke = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                if (blockWithInvoke != block) {
                    iterator2 = block.listIterator(code, block.getInstructions().size());
                    iterator2.previous();
                    iterator2.add(decoupled);
                    iterator2 = blockWithInvoke.listIterator(code);
                    assert (iterator2.peekNext() == invoke);
                    iterator2.next();
                    continue;
                }
                iterator2.add(decoupled);
                assert (iterator2.peekNext() == invoke);
                iterator2.next();
            }
        }
        if (!Arrays.stream(changes).allMatch(Objects::isNull)) {
            List<Value> newIns = Streams.mapWithIndex(ins.stream(), (in, index) -> changes[(int)index] != null ? changes[(int)index] : in).collect(Collectors.toList());
            iterator2.replaceCurrentInstruction(Invoke.create(invoke.getType(), invokedMethod, invokedMethod.proto, invoke.outValue(), newIns));
        }
        return iterator2;
    }

    private int getIdentifierPositionInArguments(InvokeMethod invoke) {
        boolean isReferenceFieldUpdater;
        boolean isClassForName;
        DexType returnType = invoke.getReturnType();
        if (IdentifierNameStringUtils.isClassNameComparison(invoke, this.appView.dexItemFactory())) {
            return IdentifierNameStringUtils.getPositionOfFirstConstString(invoke);
        }
        boolean bl = isClassForName = returnType == this.appView.dexItemFactory().classType;
        if (isClassForName) {
            assert (this.appView.dexItemFactory().classMethods.isReflectiveClassLookup(invoke.getInvokedMethod()));
            return 0;
        }
        boolean bl2 = isReferenceFieldUpdater = returnType == this.appView.dexItemFactory().referenceFieldUpdaterType;
        if (isReferenceFieldUpdater) {
            assert (invoke.getInvokedMethod() == this.appView.dexItemFactory().atomicFieldUpdaterMethods.referenceUpdater);
            return 2;
        }
        return 1;
    }

    private void warnUndeterminedIdentifierIfNecessary(DexReference member, ProgramMethod method, Instruction instruction, DexString original) {
        assert (member.isDexField() || member.isDexMethod());
        boolean matchedByExplicitRule = this.identifierNameStrings.getBoolean(member);
        if (!matchedByExplicitRule) {
            return;
        }
        if (!this.appView.options().isMinifying()) {
            return;
        }
        Origin origin = method.getOrigin();
        String kind = member.isDexField() ? "field" : "method";
        String originalMessage = original == null ? "what identifier string flows to " : "what '" + original.toString() + "' refers to, which flows to ";
        String message = "Cannot determine " + originalMessage + member.toSourceString() + " that is specified in -identifiernamestring rules. Thus, not all identifier strings flowing to that " + kind + " are renamed, which can cause resolution failures at runtime.";
        StringDiagnostic diagnostic = instruction.getPosition().getLine() >= 1 ? new StringDiagnostic(message, origin, new TextPosition(0L, instruction.getPosition().getLine(), 1)) : new StringDiagnostic(message, origin);
        this.appView.options().reporter.warning(diagnostic);
    }

    public void decoupleIdentifierNameStringsInFields(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), clazz -> {
            for (DexEncodedField field : clazz.staticFields()) {
                this.decoupleIdentifierNameStringInStaticField(field);
            }
        }, executorService);
    }

    public void decoupleIdentifierNameStringsInMethod(IRCode code) {
        this.decoupleIdentifierNameStringsInBlocks(code, null);
    }

    public void decoupleIdentifierNameStringsInBlocks(IRCode code, Set<BasicBlock> blocks) {
        if (!code.metadata().mayHaveConstString()) {
            return;
        }
        BasicBlockIterator blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            if (blocks != null && !blocks.contains(block)) continue;
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Instruction instruction = (Instruction)iterator2.next();
                if (instruction.isStaticPut() || instruction.isInstancePut()) {
                    iterator2 = this.decoupleIdentifierNameStringForFieldPutInstruction(code, blockIterator, iterator2, instruction.asFieldInstruction());
                    continue;
                }
                if (!instruction.isInvokeMethod()) continue;
                iterator2 = this.decoupleIdentifierNameStringForInvokeInstruction(code, blockIterator, iterator2, instruction.asInvokeMethod());
            }
        }
    }
}

