/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.MethodNamingState;
import com.android.tools.r8.naming.MethodReservationState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.DisjointSets;
import com.android.tools.r8.utils.MethodJavaSignatureEquivalence;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

class InterfaceMethodNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final SubtypingInfo subtypingInfo;
    private final Equivalence<DexMethod> equivalence;
    private final Equivalence<DexEncodedMethod> definitionEquivalence;
    private final MethodNameMinifier.State minifierState;
    private final Map<Equivalence.Wrapper<DexEncodedMethod>, InterfaceMethodGroupState> globalStateMap = new HashMap<Equivalence.Wrapper<DexEncodedMethod>, InterfaceMethodGroupState>();
    private final Map<DexType, InterfaceReservationState> interfaceStateMap = new HashMap<DexType, InterfaceReservationState>();

    InterfaceMethodNameMinifier(AppView<AppInfoWithLiveness> appView, MethodNameMinifier.State minifierState, SubtypingInfo subtypingInfo) {
        this.appView = appView;
        this.minifierState = minifierState;
        this.subtypingInfo = subtypingInfo;
        this.equivalence = appView.options().getProguardConfiguration().isOverloadAggressively() ? MethodSignatureEquivalence.get() : MethodJavaSignatureEquivalence.get();
        this.definitionEquivalence = new Equivalence<DexEncodedMethod>(){

            @Override
            protected boolean doEquivalent(DexEncodedMethod method, DexEncodedMethod other) {
                return InterfaceMethodNameMinifier.this.equivalence.equivalent((DexMethod)method.getReference(), (DexMethod)other.getReference());
            }

            @Override
            protected int doHash(DexEncodedMethod method) {
                return InterfaceMethodNameMinifier.this.equivalence.hash((DexMethod)method.getReference());
            }
        };
    }

    private Comparator<Equivalence.Wrapper<DexEncodedMethod>> getDefaultInterfaceMethodOrdering() {
        return Comparator.comparing(this.globalStateMap::get);
    }

    private void reserveNamesInInterfaces(Iterable<DexClass> interfaces) {
        for (DexClass iface : interfaces) {
            assert (iface.isInterface());
            this.minifierState.allocateReservationStateAndReserve(iface.type, iface.type);
            InterfaceReservationState iFaceState = new InterfaceReservationState(iface);
            iFaceState.addReservationType(iface.type);
            this.interfaceStateMap.put(iface.type, iFaceState);
        }
    }

    private DexString assignNewName(DexEncodedMethod method, InterfaceMethodGroupState groupState) {
        assert (groupState.getReservedName() == null);
        assert (groupState.methodStates.containsKey(method));
        assert (groupState.containsReservation(method, method.getHolderType()));
        MethodNamingState<?> namingState = this.minifierState.getNamingState(method.getHolderType());
        DexString newName = namingState.newOrReservedNameFor(method, (candidate, ignore) -> groupState.isAvailable((DexString)candidate));
        groupState.addRenaming(newName, this.minifierState);
        return newName;
    }

    private DexString newNameInGroup(DexEncodedMethod method, MethodNamingState<?> namingState, InterfaceMethodGroupState groupState) {
        return namingState.nextName(method, (candidate, ignore) -> groupState.isAvailable((DexString)candidate));
    }

    private void patchUpChildrenInReservationStates() {
        for (Map.Entry<DexType, InterfaceReservationState> entry : this.interfaceStateMap.entrySet()) {
            for (DexType parent : entry.getValue().iface.interfaces.values) {
                InterfaceReservationState parentState = this.interfaceStateMap.get(parent);
                if (parentState == null) continue;
                parentState.children.add(entry.getKey());
            }
        }
    }

    private void computeReservationFrontiersForAllImplementingClasses(Iterable<DexClass> interfaces) {
        interfaces.forEach(iface -> this.subtypingInfo.subtypes(iface.getType()).forEach(subType -> {
            DexClass subClass = this.appView.contextIndependentDefinitionFor((DexType)subType);
            if (subClass == null || subClass.isInterface()) {
                return;
            }
            DexType frontierType = this.minifierState.getFrontier((DexType)subType);
            if (this.minifierState.getReservationState(frontierType) == null) {
                return;
            }
            InterfaceReservationState iState = this.interfaceStateMap.get(iface.getType());
            if (iState != null) {
                iState.addReservationType(frontierType);
            }
        }));
    }

    private boolean verifyAllCallSitesAreRepresentedIn(List<Equivalence.Wrapper<DexEncodedMethod>> groups2) {
        HashSet<Equivalence.Wrapper<DexEncodedMethod>> unifiedMethods = new HashSet<Equivalence.Wrapper<DexEncodedMethod>>(groups2);
        HashSet<DexCallSite> unifiedSeen = new HashSet<DexCallSite>();
        HashSet<DexCallSite> seen = new HashSet<DexCallSite>();
        for (Map.Entry<Equivalence.Wrapper<DexEncodedMethod>, InterfaceMethodGroupState> state : this.globalStateMap.entrySet()) {
            for (DexCallSite callSite : state.getValue().callSites) {
                seen.add(callSite);
                if (!unifiedMethods.contains(state.getKey())) continue;
                boolean added = unifiedSeen.add(callSite);
                assert (added);
            }
        }
        assert (seen.size() == unifiedSeen.size());
        assert (unifiedSeen.containsAll(seen));
        return true;
    }

    private boolean verifyAllMethodsAreRepresentedIn(List<Equivalence.Wrapper<DexEncodedMethod>> groups2) {
        HashSet<Equivalence.Wrapper<DexEncodedMethod>> unifiedMethods = new HashSet<Equivalence.Wrapper<DexEncodedMethod>>(groups2);
        Set<DexEncodedMethod> unifiedSeen = Sets.newIdentityHashSet();
        Set<DexEncodedMethod> seen = Sets.newIdentityHashSet();
        for (Map.Entry<Equivalence.Wrapper<DexEncodedMethod>, InterfaceMethodGroupState> state : this.globalStateMap.entrySet()) {
            for (DexEncodedMethod method : state.getValue().methodStates.keySet()) {
                seen.add(method);
                if (!unifiedMethods.contains(state.getKey())) continue;
                boolean added = unifiedSeen.add(method);
                assert (added);
            }
        }
        assert (seen.size() == unifiedSeen.size());
        assert (unifiedSeen.containsAll(seen));
        return true;
    }

    private void print(DexMethod method, Set<DexEncodedMethod> sourceMethods, PrintStream out) {
        out.println("-----------------------------------------------------------------------");
        out.println("assignNameToInterfaceMethod(`" + method.toSourceString() + "`)");
        out.println("-----------------------------------------------------------------------");
        out.println("Source methods:");
        for (DexEncodedMethod sourceMethod : sourceMethods) {
            out.println("  " + sourceMethod.toSourceString());
        }
        out.println("States:");
        out.println();
    }

    void assignNamesToInterfaceMethods(Timing timing, Iterable<DexClass> interfaces) {
        InterfaceMethodGroupState groupState;
        timing.begin("Interface minification");
        timing.begin("Reserve direct and compute hierarchy");
        this.reserveNamesInInterfaces(interfaces);
        this.patchUpChildrenInReservationStates();
        timing.end();
        timing.begin("Compute map");
        this.computeReservationFrontiersForAllImplementingClasses(interfaces);
        for (DexClass iface : interfaces) {
            InterfaceReservationState inheritanceState = this.interfaceStateMap.get(iface.type);
            assert (inheritanceState != null);
            for (DexEncodedMethod method : iface.methods()) {
                Equivalence.Wrapper<DexEncodedMethod> key = this.definitionEquivalence.wrap(method);
                this.globalStateMap.computeIfAbsent(key, k -> new InterfaceMethodGroupState()).addState(method, inheritanceState);
            }
        }
        timing.end();
        Set<DexCallSite> liveCallSites = this.appView.appInfo().callSites.keySet();
        timing.begin("Union-find");
        DisjointSets unification = new DisjointSets();
        liveCallSites.forEach(callSite -> {
            HashSet<Equivalence.Wrapper<DexEncodedMethod>> callSiteMethods = new HashSet<Equivalence.Wrapper<DexEncodedMethod>>();
            Set<DexEncodedMethod> implementedMethods = this.appView.appInfo().lookupLambdaImplementedMethods((DexCallSite)callSite);
            for (DexEncodedMethod method : implementedMethods) {
                Equivalence.Wrapper<DexEncodedMethod> wrapped = this.definitionEquivalence.wrap(method);
                InterfaceMethodGroupState groupState = this.globalStateMap.get(wrapped);
                assert (groupState != null) : wrapped;
                groupState.addCallSite((DexCallSite)callSite);
                callSiteMethods.add(wrapped);
            }
            if (callSiteMethods.isEmpty()) {
                return;
            }
            List<DexType> implementedInterfaces = LambdaDescriptor.getInterfaces(callSite, this.appView.appInfo());
            if (implementedInterfaces != null) {
                for (int i = 1; i < implementedInterfaces.size(); ++i) {
                    DexClass iface = this.appView.definitionFor(implementedInterfaces.get(i));
                    assert (iface.isInterface());
                    for (DexEncodedMethod dexEncodedMethod : implementedMethods) {
                        for (DexEncodedMethod virtualMethod : iface.virtualMethods()) {
                            boolean differentName = dexEncodedMethod.getName() != virtualMethod.getName();
                            if (!differentName || !MethodJavaSignatureEquivalence.getEquivalenceIgnoreName().equivalent((DexMethod)dexEncodedMethod.getReference(), (DexMethod)virtualMethod.getReference())) continue;
                            InterfaceMethodGroupState interfaceMethodGroupState = this.globalStateMap.computeIfAbsent(this.definitionEquivalence.wrap(dexEncodedMethod), k -> new InterfaceMethodGroupState());
                            interfaceMethodGroupState.callSiteCollidingMethods.add(virtualMethod);
                        }
                    }
                }
            }
            if (callSiteMethods.size() > 1) {
                Equivalence.Wrapper mainKey = (Equivalence.Wrapper)callSiteMethods.iterator().next();
                Equivalence.Wrapper representative = unification.findOrMakeSet(mainKey);
                for (Equivalence.Wrapper wrapper : callSiteMethods) {
                    unification.unionWithMakeSet(representative, wrapper);
                }
            }
        });
        timing.end();
        timing.begin("States for union");
        Map unions = unification.collectSets();
        for (Equivalence.Wrapper wrapped : unions.keySet()) {
            InterfaceMethodGroupState groupState2 = this.globalStateMap.get(wrapped);
            assert (groupState2 != null);
            for (Equivalence.Wrapper groupedMethod : unions.get(wrapped)) {
                DexEncodedMethod method = (DexEncodedMethod)groupedMethod.get();
                assert (method != null);
                groupState2.appendMethodGroupState(this.globalStateMap.get(groupedMethod));
            }
        }
        timing.end();
        timing.begin("Sort");
        List<Equivalence.Wrapper<DexEncodedMethod>> interfaceMethodGroups = this.globalStateMap.keySet().stream().filter(unification::isRepresentativeOrNotPresent).sorted(this.appView.options().testing.minifier.getInterfaceMethodOrderingOrDefault(this.getDefaultInterfaceMethodOrdering())).collect(Collectors.toList());
        timing.end();
        assert (this.verifyAllMethodsAreRepresentedIn(interfaceMethodGroups));
        assert (this.verifyAllCallSitesAreRepresentedIn(interfaceMethodGroups));
        timing.begin("Reserve in groups");
        ArrayList<Equivalence.Wrapper<DexEncodedMethod>> nonReservedMethodGroups = new ArrayList<Equivalence.Wrapper<DexEncodedMethod>>();
        for (Equivalence.Wrapper<DexEncodedMethod> interfaceMethodGroup : interfaceMethodGroups) {
            groupState = this.globalStateMap.get(interfaceMethodGroup);
            assert (groupState != null);
            DexString reservedName = groupState.getReservedName();
            if (reservedName == null) {
                nonReservedMethodGroups.add(interfaceMethodGroup);
                continue;
            }
            groupState.reserveName(reservedName);
        }
        timing.end();
        timing.begin("Rename in groups");
        for (Equivalence.Wrapper<DexEncodedMethod> interfaceMethodGroup : nonReservedMethodGroups) {
            groupState = this.globalStateMap.get(interfaceMethodGroup);
            assert (groupState != null);
            assert (groupState.getReservedName() == null);
            DexString newName = this.assignNewName(interfaceMethodGroup.get(), groupState);
            assert (newName != null);
            Set<String> loggingFilter = this.appView.options().extensiveInterfaceMethodMinifierLoggingFilter;
            if (loggingFilter.isEmpty()) continue;
            Set<DexEncodedMethod> sourceMethods = groupState.methodStates.keySet();
            if (!sourceMethods.stream().map(DexEncodedMethod::toSourceString).anyMatch(loggingFilter::contains)) continue;
            this.print((DexMethod)interfaceMethodGroup.get().getReference(), sourceMethods, System.out);
        }
        for (Equivalence.Wrapper<DexEncodedMethod> interfaceMethodGroup : nonReservedMethodGroups) {
            groupState = this.globalStateMap.get(interfaceMethodGroup);
            if (groupState.callSiteCollidingMethods.isEmpty()) continue;
            DexEncodedMethod key = interfaceMethodGroup.get();
            MethodNamingState<?> keyNamingState = this.minifierState.getNamingState(key.getHolderType());
            DexString existingRenaming = keyNamingState.newOrReservedNameFor(key);
            assert (existingRenaming != null);
            for (DexEncodedMethod collidingMethod : groupState.callSiteCollidingMethods) {
                DexString newNameInGroup = this.newNameInGroup(collidingMethod, keyNamingState, groupState);
                this.minifierState.putRenaming(collidingMethod, newNameInGroup);
                MethodNamingState<?> methodNamingState = this.minifierState.getNamingState(((DexMethod)collidingMethod.getReference()).holder);
                methodNamingState.addRenaming(newNameInGroup, collidingMethod);
                keyNamingState.addRenaming(newNameInGroup, collidingMethod);
            }
        }
        timing.end();
        timing.end();
    }

    class InterfaceMethodGroupState
    implements Comparable<InterfaceMethodGroupState> {
        private final Set<DexCallSite> callSites = new HashSet<DexCallSite>();
        private final Map<DexEncodedMethod, Set<InterfaceReservationState>> methodStates = new HashMap<DexEncodedMethod, Set<InterfaceReservationState>>();
        private final List<DexEncodedMethod> callSiteCollidingMethods = new ArrayList<DexEncodedMethod>();

        InterfaceMethodGroupState() {
        }

        void addState(DexEncodedMethod method, InterfaceReservationState interfaceState) {
            this.methodStates.computeIfAbsent(method, m3 -> new HashSet()).add(interfaceState);
        }

        void appendMethodGroupState(InterfaceMethodGroupState state) {
            this.callSites.addAll(state.callSites);
            this.callSiteCollidingMethods.addAll(state.callSiteCollidingMethods);
            for (DexEncodedMethod key : state.methodStates.keySet()) {
                this.methodStates.computeIfAbsent(key, k -> new HashSet()).addAll((Collection)state.methodStates.get(key));
            }
        }

        void addCallSite(DexCallSite callSite) {
            this.callSites.add(callSite);
        }

        DexString getReservedName() {
            if (this.methodStates.isEmpty()) {
                return null;
            }
            ArrayList<DexEncodedMethod> sortedMethods = Lists.newArrayList(this.methodStates.keySet());
            sortedMethods.sort((x, y) -> ((DexMethod)x.getReference()).compareTo((DexMethod)y.getReference()));
            DexString reservedName = null;
            for (DexEncodedMethod method : sortedMethods) {
                for (InterfaceReservationState state : this.methodStates.get(method)) {
                    DexString stateReserved = state.getReservedName(method);
                    if (stateReserved == method.getName()) {
                        return method.getName();
                    }
                    if (stateReserved == null) continue;
                    reservedName = stateReserved;
                }
            }
            return reservedName;
        }

        void reserveName(DexString reservedName) {
            this.forEachState((method, state) -> {
                DexString stateReserved = state.getReservedName((DexEncodedMethod)method);
                if (stateReserved != null) {
                    state.reserveName(stateReserved, (DexEncodedMethod)method);
                    InterfaceMethodNameMinifier.this.minifierState.putRenaming((DexEncodedMethod)method, stateReserved);
                } else {
                    state.reserveName(reservedName, (DexEncodedMethod)method);
                    InterfaceMethodNameMinifier.this.minifierState.putRenaming((DexEncodedMethod)method, reservedName);
                }
            });
        }

        boolean isAvailable(DexString candidate) {
            Boolean result = this.forAnyState((m3, s2) -> {
                if (!s2.isAvailable(candidate, (DexEncodedMethod)m3)) {
                    return false;
                }
                return null;
            });
            return result == null || result != false;
        }

        void addRenaming(DexString newName, MethodNameMinifier.State minifierState) {
            this.forEachState((m3, s2) -> {
                s2.addRenaming(newName, (DexEncodedMethod)m3);
                minifierState.putRenaming((DexEncodedMethod)m3, newName);
            });
        }

        void forEachState(BiConsumer<DexEncodedMethod, InterfaceReservationState> action) {
            this.forAnyState((s2, i) -> {
                action.accept((DexEncodedMethod)s2, (InterfaceReservationState)i);
                return null;
            });
        }

        <T> T forAnyState(BiFunction<DexEncodedMethod, InterfaceReservationState, T> callback) {
            for (Map.Entry<DexEncodedMethod, Set<InterfaceReservationState>> entry : this.methodStates.entrySet()) {
                for (InterfaceReservationState state : entry.getValue()) {
                    T returnValue = callback.apply(entry.getKey(), state);
                    if (returnValue == null) continue;
                    return returnValue;
                }
            }
            return null;
        }

        boolean containsReservation(DexEncodedMethod method, DexType reservationType) {
            Set<InterfaceReservationState> states = this.methodStates.get(method);
            if (states != null) {
                for (InterfaceReservationState state : states) {
                    if (!state.containsReservation(reservationType)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(InterfaceMethodGroupState o) {
            return o.methodStates.size() - this.methodStates.size();
        }
    }

    class InterfaceReservationState {
        final DexClass iface;
        final Set<DexType> children = new HashSet<DexType>();
        private final Set<DexType> reservationTypes = new HashSet<DexType>();

        InterfaceReservationState(DexClass iface) {
            this.iface = iface;
        }

        private <T> T forAny(Function<InterfaceReservationState, T> action) {
            T result = action.apply(this);
            if (result != null) {
                return result;
            }
            result = this.forChildren(action);
            if (result != null) {
                return result;
            }
            return this.forParents(action);
        }

        private <T> T forParents(Function<InterfaceReservationState, T> action) {
            for (DexType parent : this.iface.interfaces.values) {
                InterfaceReservationState parentState = (InterfaceReservationState)InterfaceMethodNameMinifier.this.interfaceStateMap.get(parent);
                if (parentState == null) continue;
                T returnValue = action.apply(parentState);
                if (returnValue != null) {
                    return returnValue;
                }
                returnValue = parentState.forParents(action);
                if (returnValue == null) continue;
                return returnValue;
            }
            return null;
        }

        private <T> T forChildren(Function<InterfaceReservationState, T> action) {
            for (DexType child : this.children) {
                InterfaceReservationState childState = (InterfaceReservationState)InterfaceMethodNameMinifier.this.interfaceStateMap.get(child);
                if (childState == null) continue;
                T returnValue = action.apply(childState);
                if (returnValue != null) {
                    return returnValue;
                }
                returnValue = childState.forChildren(action);
                if (returnValue == null) continue;
                return returnValue;
            }
            return null;
        }

        DexString getReservedName(DexEncodedMethod method) {
            DexString reservedName;
            if (InterfaceMethodNameMinifier.this.appView.options().getProguardConfiguration().hasApplyMappingFile() && (reservedName = InterfaceMethodNameMinifier.this.minifierState.getReservedName(method, this.iface)) != null) {
                return reservedName;
            }
            Boolean isReserved = this.forAny(s2 -> {
                for (DexType reservationType : s2.reservationTypes) {
                    Set<DexString> reservedNamesFor = InterfaceMethodNameMinifier.this.minifierState.getReservationState(reservationType).getReservedNamesFor((DexMethod)method.getReference());
                    assert (reservedNamesFor == null || !reservedNamesFor.isEmpty());
                    if (reservedNamesFor == null || !reservedNamesFor.contains(method.getName())) continue;
                    return true;
                }
                return null;
            });
            return isReserved == null ? null : method.getName();
        }

        void addReservationType(DexType type) {
            this.reservationTypes.add(type);
        }

        void reserveName(DexString reservedName, DexEncodedMethod method) {
            this.forAll(s2 -> s2.reservationTypes.forEach(resType -> {
                MethodReservationState<?> state = InterfaceMethodNameMinifier.this.minifierState.getReservationState((DexType)resType);
                state.reserveName(reservedName, method);
            }));
        }

        boolean isAvailable(DexString candidate, DexEncodedMethod method) {
            Boolean result = this.forAny(s2 -> {
                for (DexType resType : s2.reservationTypes) {
                    MethodNamingState<?> state = InterfaceMethodNameMinifier.this.minifierState.getNamingState(resType);
                    if (state.isAvailable(candidate, (DexMethod)method.getReference())) continue;
                    return false;
                }
                return null;
            });
            return result == null || result != false;
        }

        void addRenaming(DexString newName, DexEncodedMethod method) {
            this.forAll(s2 -> s2.reservationTypes.forEach(resType -> InterfaceMethodNameMinifier.this.minifierState.getNamingState((DexType)resType).addRenaming(newName, method)));
        }

        <T> void forAll(Consumer<InterfaceReservationState> action) {
            this.forAny(s2 -> {
                action.accept((InterfaceReservationState)s2);
                return null;
            });
        }

        boolean containsReservation(DexType reservationType) {
            return this.reservationTypes.contains(reservationType);
        }
    }
}

