/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessInfoCollection;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.naming.InterfaceMethodNameMinifier;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.MethodNamingState;
import com.android.tools.r8.naming.MethodReservationState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

class MethodNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final MemberNamingStrategy strategy;
    private final Map<DexMethod, DexString> renaming = new IdentityHashMap<DexMethod, DexString>();
    private final State minifierState = new State();
    private final BiMap<DexType, MethodReservationState<?>> reservationStates = HashBiMap.create();
    private final Map<DexType, MethodNamingState<?>> namingStates = new IdentityHashMap();
    private final Map<DexType, DexType> frontiers = new IdentityHashMap<DexType, DexType>();
    private final MethodNamingState<?> rootNamingState;
    private final MethodReservationState<?> rootReservationState;

    MethodNameMinifier(AppView<AppInfoWithLiveness> appView, MemberNamingStrategy strategy) {
        this.appView = appView;
        this.strategy = strategy;
        this.rootReservationState = MethodReservationState.createRoot(this.getReservationKeyTransform());
        this.reservationStates.put(null, this.rootReservationState);
        this.rootNamingState = MethodNamingState.createRoot(this.getNamingKeyTransform(), strategy, this.rootReservationState);
        this.namingStates.put(null, this.rootNamingState);
    }

    private Function<DexMethod, ?> getReservationKeyTransform() {
        if (this.appView.options().getProguardConfiguration().isOverloadAggressively() && this.appView.options().isGeneratingClassFiles()) {
            return method -> method.proto;
        }
        return method -> method.proto.parameters;
    }

    private Function<DexMethod, ?> getNamingKeyTransform() {
        return this.appView.options().isGeneratingClassFiles() ? this.getReservationKeyTransform() : method -> null;
    }

    private void assignNamesToClassesMethods() {
        ((TopDownClassHierarchyTraversal)TopDownClassHierarchyTraversal.forAllClasses(this.appView).excludeInterfaces()).visit(this.appView.appInfo().classes(), clazz -> {
            DexType type = clazz.type;
            MethodReservationState reservationState = (MethodReservationState)this.reservationStates.get(this.frontiers.getOrDefault(type, type));
            assert (reservationState != null) : "Could not find reservation state for " + type.toString();
            MethodNamingState namingState = this.namingStates.computeIfAbsent(type, ignore -> this.namingStates.getOrDefault(clazz.superType, this.rootNamingState).createChild(reservationState));
            DexClass holder = this.appView.definitionFor(type);
            if (holder != null && this.strategy.allowMemberRenaming(holder)) {
                for (DexEncodedMethod method : holder.allMethodsSorted()) {
                    this.assignNameToMethod(holder, method, namingState);
                }
            }
        });
    }

    private void renameMethodsInUnrelatedClasspathClasses() {
        if (this.appView.options().getProguardConfiguration().hasApplyMappingFile()) {
            this.appView.appInfo().forEachReferencedClasspathClass(clazz -> {
                for (DexEncodedMethod method : clazz.methods()) {
                    DexString reservedName = this.strategy.getReservedName(method, (DexClass)clazz);
                    if (reservedName == null || reservedName == ((DexMethod)method.getReference()).name) continue;
                    this.renaming.put((DexMethod)method.getReference(), reservedName);
                }
            });
        }
    }

    private void assignNameToMethod(DexClass holder, DexEncodedMethod method, MethodNamingState<?> state) {
        if (method.isInitializer()) {
            return;
        }
        DexString newName = this.strategy.getReservedName(method, holder);
        if (newName == null || newName == method.getName()) {
            newName = state.newOrReservedNameFor(method);
        }
        if (method.getName() != newName) {
            this.renaming.put((DexMethod)method.getReference(), newName);
        }
        state.addRenaming(newName, method);
    }

    private void reserveNamesInClasses() {
        this.allocateReservationStateAndReserve(this.appView.dexItemFactory().objectType, this.appView.dexItemFactory().objectType, this.rootReservationState);
        TopDownClassHierarchyTraversal.forAllClasses(this.appView).visit(this.appView.appInfo().classes(), clazz -> {
            DexType type = clazz.type;
            DexType frontier = this.frontiers.getOrDefault(clazz.superType, type);
            if (frontier != type || clazz.isProgramClass()) {
                DexType existingValue = this.frontiers.put(clazz.type, frontier);
                assert (existingValue == null);
            }
            this.allocateReservationStateAndReserve(type, frontier, this.reservationStates.getOrDefault(clazz.superType, this.rootReservationState));
        });
    }

    private void allocateReservationStateAndReserve(DexType type, DexType frontier, MethodReservationState<?> parent) {
        MethodReservationState state = this.reservationStates.computeIfAbsent(frontier, ignore -> parent.createChild());
        DexClass holder = this.appView.definitionFor(type);
        if (holder != null) {
            for (DexEncodedMethod method : MethodNameMinifier.shuffleMethods(holder.methods(), this.appView.options())) {
                DexString reservedName = this.strategy.getReservedName(method, holder);
                if (reservedName == null) continue;
                state.reserveName(reservedName, method);
            }
        }
    }

    private MethodNamingState<?> getOrAllocateMethodNamingStates(DexType type) {
        MethodNamingState<?> namingState = this.namingStates.get(type);
        if (namingState == null) {
            DexClass holder;
            MethodNamingState<?> parentState = type == this.appView.dexItemFactory().objectType ? this.rootNamingState : ((holder = this.appView.definitionFor(type)) == null ? this.getOrAllocateMethodNamingStates(this.appView.dexItemFactory().objectType) : this.getOrAllocateMethodNamingStates(holder.superType));
            MethodReservationState<?> reservationState = this.findReservationStateInHierarchy(type);
            assert (reservationState != null) : "Could not find reservation state for " + type.toString();
            namingState = parentState.createChild(reservationState);
            this.namingStates.put(type, namingState);
        }
        return namingState;
    }

    private MethodReservationState<?> findReservationStateInHierarchy(DexType type) {
        MethodReservationState reservationState = (MethodReservationState)this.reservationStates.get(type);
        if (reservationState != null) {
            return reservationState;
        }
        if (this.appView.definitionFor(type) == null) {
            return (MethodReservationState)this.reservationStates.get(this.appView.dexItemFactory().objectType);
        }
        assert (this.frontiers.containsKey(type));
        DexType frontierType = this.frontiers.get(type);
        reservationState = (MethodReservationState)this.reservationStates.get(frontierType);
        assert (reservationState != null) : "Could not find reservation state for frontier type " + frontierType.toString();
        return reservationState;
    }

    private void renameNonReboundReferences(ExecutorService executorService) throws ExecutionException {
        ConcurrentHashMap nonReboundRenamings = new ConcurrentHashMap();
        MethodAccessInfoCollection methodAccessInfoCollection = this.appView.appInfo().getMethodAccessInfoCollection();
        ThreadUtils.processItems(methodAccessInfoCollection::forEachMethodReference, method -> this.renameNonReboundMethodReference((DexMethod)method, nonReboundRenamings), executorService);
        this.renaming.putAll(nonReboundRenamings);
    }

    private void renameNonReboundMethodReference(DexMethod method, Map<DexMethod, DexString> nonReboundRenamings) {
        if (method.getHolderType().isArrayType()) {
            return;
        }
        DexClass holder = this.appView.contextIndependentDefinitionFor(method.getHolderType());
        if (holder == null) {
            return;
        }
        MethodResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOn(holder, method);
        if (resolutionResult.isSingleResolution()) {
            DexEncodedMethod resolvedMethod = resolutionResult.getSingleTarget();
            if (resolvedMethod.getReference() == method) {
                return;
            }
            DexString newName = this.renaming.get(resolvedMethod.getReference());
            if (newName != null) {
                assert (newName != resolvedMethod.getName());
                nonReboundRenamings.put(method, newName);
            }
            return;
        }
        assert (resolutionResult.isFailedResolution());
        ArrayList targets = new ArrayList();
        resolutionResult.asFailedResolution().forEachFailureDependency(targets::add);
        if (!targets.isEmpty()) {
            DexString newName = this.renaming.get(((DexEncodedMethod)targets.get(0)).getReference());
            assert (targets.stream().allMatch(target -> this.renaming.get(target.getReference()) == newName));
            if (newName != null) {
                assert (newName != ((DexEncodedMethod)targets.get(0)).getName());
                nonReboundRenamings.put(method, newName);
            }
        }
    }

    private static Iterable<DexEncodedMethod> shuffleMethods(Iterable<DexEncodedMethod> methods, InternalOptions options) {
        return options.testing.irOrdering.order(methods);
    }

    MethodRenaming computeRenaming(Iterable<DexClass> interfaces, SubtypingInfo subtypingInfo, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Phase 1");
        this.reserveNamesInClasses();
        timing.end();
        timing.begin("Phase 2");
        InterfaceMethodNameMinifier interfaceMethodNameMinifier = new InterfaceMethodNameMinifier(this.appView, this.minifierState, subtypingInfo);
        timing.end();
        timing.begin("Phase 3");
        interfaceMethodNameMinifier.assignNamesToInterfaceMethods(timing, interfaces);
        timing.end();
        timing.begin("Phase 4");
        this.assignNamesToClassesMethods();
        this.renameMethodsInUnrelatedClasspathClasses();
        timing.end();
        timing.begin("Phase 5: non-rebound references");
        this.renameNonReboundReferences(executorService);
        timing.end();
        return new MethodRenaming(this.renaming);
    }

    static class MethodRenaming {
        final Map<DexMethod, DexString> renaming;

        private MethodRenaming(Map<DexMethod, DexString> renaming) {
            this.renaming = renaming;
        }

        public static MethodRenaming empty() {
            return new MethodRenaming(ImmutableMap.of());
        }
    }

    class State {
        State() {
        }

        void putRenaming(DexEncodedMethod key, DexString newName) {
            if (newName != key.getName()) {
                MethodNameMinifier.this.renaming.put((DexMethod)key.getReference(), newName);
            }
        }

        MethodReservationState<?> getReservationState(DexType type) {
            return (MethodReservationState)MethodNameMinifier.this.reservationStates.get(type);
        }

        MethodNamingState<?> getNamingState(DexType type) {
            return MethodNameMinifier.this.getOrAllocateMethodNamingStates(type);
        }

        void allocateReservationStateAndReserve(DexType type, DexType frontier) {
            MethodNameMinifier.this.allocateReservationStateAndReserve(type, frontier, MethodNameMinifier.this.rootReservationState);
        }

        DexType getFrontier(DexType type) {
            return MethodNameMinifier.this.frontiers.getOrDefault(type, type);
        }

        DexString getReservedName(DexEncodedMethod method, DexClass holder) {
            return MethodNameMinifier.this.strategy.getReservedName(method, holder);
        }
    }
}

