/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.MethodNamingStateBase;
import com.android.tools.r8.naming.MethodReservationState;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;

class MethodNamingState<KeyType>
extends MethodNamingStateBase<KeyType, InternalNewNameState> {
    private final MethodReservationState<?> reservationState;
    private final MethodNamingState<KeyType> parentNamingState;
    private final MemberNamingStrategy namingStrategy;

    private MethodNamingState(MethodNamingState<KeyType> parentNamingState, Function<DexMethod, KeyType> keyTransform, MemberNamingStrategy strategy, MethodReservationState<?> reservationState) {
        super(keyTransform);
        this.parentNamingState = parentNamingState;
        this.namingStrategy = strategy;
        this.reservationState = reservationState;
    }

    static <KeyType> MethodNamingState<KeyType> createRoot(Function<DexMethod, KeyType> keyTransform, MemberNamingStrategy namingStrategy, MethodReservationState<?> reservationState) {
        return new MethodNamingState<KeyType>(null, keyTransform, namingStrategy, reservationState);
    }

    private Set<Equivalence.Wrapper<DexMethod>> getUsedBy(DexString name, DexMethod method) {
        InternalNewNameState internalState = (InternalNewNameState)this.getInternalState(method);
        Set<Equivalence.Wrapper<DexMethod>> nameUsedBy = null;
        if (internalState != null) {
            nameUsedBy = internalState.getUsedBy(name);
        }
        if (nameUsedBy == null && this.parentNamingState != null) {
            return super.getUsedBy(name, method);
        }
        return nameUsedBy;
    }

    private DexString getAssignedName(DexMethod method) {
        DexString assignedName = null;
        InternalNewNameState internalState = (InternalNewNameState)this.getInternalState(method);
        if (internalState != null) {
            assignedName = internalState.getAssignedName(method);
        }
        if (assignedName == null && this.parentNamingState != null) {
            assignedName = super.getAssignedName(method);
        }
        return assignedName;
    }

    MethodNamingState<KeyType> createChild(MethodReservationState<?> frontierReservationState) {
        return new MethodNamingState<KeyType>(this, this.keyTransform, this.namingStrategy, frontierReservationState);
    }

    DexString newOrReservedNameFor(DexEncodedMethod method) {
        return this.newOrReservedNameFor(method, this::isAvailable);
    }

    DexString newOrReservedNameFor(DexEncodedMethod method, BiPredicate<DexString, DexMethod> isAvailable) {
        DexString candidate;
        DexString newName = this.getAssignedName((DexMethod)method.getReference());
        if (newName != null) {
            return newName;
        }
        Set<DexString> reservedNamesFor = this.reservationState.getReservedNamesFor((DexMethod)method.getReference());
        if (reservedNamesFor != null && reservedNamesFor.size() == 1 && this.isAvailable(candidate = reservedNamesFor.iterator().next(), (DexMethod)method.getReference())) {
            return candidate;
        }
        return this.nextName(method, isAvailable);
    }

    DexString nextName(DexEncodedMethod method, BiPredicate<DexString, DexMethod> isAvailable) {
        InternalNewNameState internalState = (InternalNewNameState)this.getOrCreateInternalState((DexMethod)method.getReference());
        DexString newName = this.namingStrategy.next(method, (InternalNamingState)internalState, isAvailable);
        assert (newName != null);
        return newName;
    }

    void addRenaming(DexString newName, DexEncodedMethod method) {
        InternalNewNameState internalState = (InternalNewNameState)this.getOrCreateInternalState((DexMethod)method.getReference());
        internalState.addRenaming(newName, (DexMethod)method.getReference());
    }

    boolean isAvailable(DexString candidate, DexMethod method) {
        Set<Equivalence.Wrapper<DexMethod>> usedBy = this.getUsedBy(candidate, method);
        if (usedBy != null && usedBy.contains(MethodSignatureEquivalence.get().wrap(method))) {
            return true;
        }
        boolean isReserved = this.reservationState.isReserved(candidate, method);
        if (!isReserved && usedBy == null) {
            return true;
        }
        Set<DexString> methodReservedNames = this.reservationState.getReservedNamesFor(method);
        return methodReservedNames != null && methodReservedNames.contains(candidate);
    }

    @Override
    InternalNewNameState createInternalState(DexMethod method) {
        InternalNewNameState parentInternalState = null;
        if (this.parentNamingState != null) {
            parentInternalState = (InternalNewNameState)this.parentNamingState.getOrCreateInternalState(method);
        }
        return new InternalNewNameState(parentInternalState);
    }

    static class InternalNewNameState
    implements InternalNamingState {
        private static final int INITIAL_NAME_COUNT = 1;
        private static final int INITIAL_DICTIONARY_INDEX = 0;
        private final InternalNewNameState parentInternalState;
        private Map<Equivalence.Wrapper<DexMethod>, DexString> originalToRenamedNames = new HashMap<Equivalence.Wrapper<DexMethod>, DexString>();
        private Map<DexString, Set<Equivalence.Wrapper<DexMethod>>> usedBy = new HashMap<DexString, Set<Equivalence.Wrapper<DexMethod>>>();
        private int nameCount;
        private int dictionaryIndex;

        private InternalNewNameState(InternalNewNameState parentInternalState) {
            this.parentInternalState = parentInternalState;
            this.dictionaryIndex = parentInternalState == null ? 0 : parentInternalState.dictionaryIndex;
            this.nameCount = parentInternalState == null ? 1 : parentInternalState.nameCount;
        }

        private boolean checkParentPublicNameCountIsLessThanOrEqual() {
            int maxParentCount = 0;
            InternalNewNameState tmp = this.parentInternalState;
            while (tmp != null) {
                maxParentCount = Math.max(tmp.nameCount, maxParentCount);
                tmp = tmp.parentInternalState;
            }
            assert (maxParentCount <= this.nameCount);
            return true;
        }

        @Override
        public int getDictionaryIndex() {
            return this.dictionaryIndex;
        }

        @Override
        public int incrementDictionaryIndex() {
            return this.dictionaryIndex++;
        }

        Set<Equivalence.Wrapper<DexMethod>> getUsedBy(DexString name) {
            return this.usedBy.get(name);
        }

        DexString getAssignedName(DexMethod method) {
            return this.originalToRenamedNames.get(MethodSignatureEquivalence.get().wrap(method));
        }

        void addRenaming(DexString newName, DexMethod method) {
            Equivalence.Wrapper<DexMethod> wrappedMethod = MethodSignatureEquivalence.get().wrap(method);
            this.originalToRenamedNames.put(wrappedMethod, newName);
            this.usedBy.computeIfAbsent(newName, ignore -> new HashSet()).add(wrappedMethod);
        }

        @Override
        public int incrementNameIndex() {
            assert (this.checkParentPublicNameCountIsLessThanOrEqual());
            return this.nameCount++;
        }
    }
}

