/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.InternalOptions;

public class PrefixRewritingNamingLens
extends NamingLens.NonIdentityNamingLens {
    final NamingLens namingLens;
    final InternalOptions options;
    final AppView<?> appView;

    public static NamingLens createPrefixRewritingNamingLens(AppView<?> appView) {
        return PrefixRewritingNamingLens.createPrefixRewritingNamingLens(appView, NamingLens.getIdentityLens());
    }

    public static NamingLens createPrefixRewritingNamingLens(AppView<?> appView, NamingLens namingLens) {
        if (!appView.typeRewriter.isRewriting()) {
            return namingLens;
        }
        return new PrefixRewritingNamingLens(namingLens, appView);
    }

    public PrefixRewritingNamingLens(NamingLens namingLens, AppView<?> appView) {
        super(appView.dexItemFactory());
        this.appView = appView;
        this.namingLens = namingLens;
        this.options = appView.options();
    }

    private boolean isRenamed(DexType type) {
        return this.getRenaming(type) != null;
    }

    private DexString getRenaming(DexType type) {
        DexString descriptor = null;
        if (this.appView.typeRewriter.hasRewrittenType(type, this.appView)) {
            descriptor = this.appView.typeRewriter.rewrittenType((DexType)type, this.appView).descriptor;
        }
        return descriptor;
    }

    private boolean verifyNotPrefixRewrittenPackage(String packageName) {
        this.appView.typeRewriter.forAllRewrittenTypes(dexType -> {
            assert (!dexType.getPackageDescriptor().equals(packageName));
        });
        return true;
    }

    @Override
    public boolean hasPrefixRewritingLogic() {
        return true;
    }

    @Override
    public DexString prefixRewrittenType(DexType type) {
        return this.getRenaming(type);
    }

    @Override
    protected DexString internalLookupClassDescriptor(DexType type) {
        DexString renaming = this.getRenaming(type);
        return renaming != null ? renaming : this.namingLens.lookupDescriptor(type);
    }

    @Override
    public DexString lookupInnerName(InnerClassAttribute attribute, InternalOptions options) {
        if (this.isRenamed(attribute.getInner())) {
            return attribute.getInnerName();
        }
        return this.namingLens.lookupInnerName(attribute, options);
    }

    @Override
    public DexString lookupName(DexMethod method) {
        if (this.isRenamed(method.holder)) {
            return method.name;
        }
        return this.namingLens.lookupName(method);
    }

    @Override
    public DexString lookupName(DexField field) {
        if (this.isRenamed(field.holder)) {
            return field.name;
        }
        return this.namingLens.lookupName(field);
    }

    @Override
    public String lookupPackageName(String packageName) {
        assert (this.verifyNotPrefixRewrittenPackage(packageName));
        return this.namingLens.lookupPackageName(packageName);
    }

    @Override
    public boolean verifyRenamingConsistentWithResolution(DexMethod item) {
        return this.namingLens.verifyRenamingConsistentWithResolution(item);
    }
}

