/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.MapIdEnvironment;
import com.android.tools.r8.MapIdProvider;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.hash.Hasher;
import com.android.tools.r8.com.google.common.hash.Hashing;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.naming.mappinginformation.MapVersionMappingInformation;
import com.android.tools.r8.utils.ChainableStringConsumer;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.VersionProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class ProguardMapSupplier {
    public static final String MARKER_KEY_COMPILER = "compiler";
    public static final String MARKER_VALUE_COMPILER = "R8";
    public static final String MARKER_KEY_COMPILER_VERSION = "compiler_version";
    public static final String MARKER_KEY_COMPILER_HASH = "compiler_hash";
    public static final String MARKER_KEY_MIN_API = "min_api";
    public static final String MARKER_KEY_PG_MAP_ID = "pg_map_id";
    public static final String MARKER_KEY_PG_MAP_HASH = "pg_map_hash";
    public static final String SHA_256_KEY = "SHA-256";
    public static int PG_MAP_ID_LENGTH = 7;
    private final ClassNameMapper classNameMapper;
    private final StringConsumer consumer;
    private final InternalOptions options;
    private final Reporter reporter;

    private ProguardMapSupplier(ClassNameMapper classNameMapper, InternalOptions options) {
        assert (classNameMapper != null);
        this.classNameMapper = classNameMapper.sorted();
        this.consumer = options.proguardMapConsumer;
        this.options = options;
        this.reporter = options.reporter;
    }

    public static ProguardMapSupplier create(ClassNameMapper classNameMapper, InternalOptions options) {
        return new ProguardMapSupplier(classNameMapper, options);
    }

    private ProguardMapId computeProguardMapId() {
        ProguardMapIdBuilder builder = new ProguardMapIdBuilder();
        this.classNameMapper.write(builder);
        return builder.build(this.options.mapIdProvider);
    }

    private void writeBody() {
        this.classNameMapper.write(new ProguardMapWriter());
    }

    private void writeMarker(ProguardMapId id) {
        StringBuilder builder = new StringBuilder();
        builder.append("# compiler: R8\n# compiler_version: main\n");
        if (this.options.isGeneratingDex()) {
            builder.append("# min_api: " + this.options.getMinApiLevel().getLevel() + "\n");
        }
        if (Version.isDevelopmentVersion()) {
            builder.append("# compiler_hash: " + VersionProperties.INSTANCE.getSha() + "\n");
        }
        builder.append("# common_typos_disable\n");
        MapVersion mapVersion = this.options.getMapFileVersion();
        if (mapVersion.isGreaterThan(MapVersion.MAP_VERSION_NONE)) {
            builder.append("# ").append(new MapVersionMappingInformation(mapVersion, mapVersion.getName()).serialize()).append("\n");
        }
        builder.append("# pg_map_id: " + id.getId() + "\n");
        builder.append("# ").append(MARKER_KEY_PG_MAP_HASH).append(": ").append(SHA_256_KEY).append(" ").append(id.getHash()).append("\n");
        this.consumer.accept(builder.toString(), this.reporter);
    }

    public ProguardMapId writeProguardMap() {
        ProguardMapId id = this.computeProguardMapId();
        this.writeMarker(id);
        this.writeBody();
        ExceptionUtils.withFinishedResourceHandler(this.reporter, this.consumer);
        return id;
    }

    public static class ProguardMapChecker
    implements StringConsumer {
        private final StringConsumer inner;
        private final StringBuilder contents = new StringBuilder();

        ProguardMapChecker(StringConsumer inner) {
            if (!InternalOptions.assertionsEnabled()) {
                throw new Unreachable();
            }
            this.inner = inner;
        }

        private static boolean validateProguardMapParses(String content) {
            try {
                ClassNameMapper.mapperFromString(content);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public static VerifyMappingFileHashResult validateProguardMapHash(String content) {
            String headerLine;
            int lineEnd = -1;
            while (true) {
                int lineStart;
                if ((lineEnd = content.indexOf(10, lineStart = lineEnd + 1)) < 0) {
                    return VerifyMappingFileHashResult.createInfo("Failure to find map hash");
                }
                String line = content.substring(lineStart, lineEnd).trim();
                if (line.isEmpty()) continue;
                if (line.charAt(0) != '#') {
                    return VerifyMappingFileHashResult.createInfo("Failure to find map hash in header");
                }
                headerLine = line.substring(1).trim();
                if (headerLine.startsWith(ProguardMapSupplier.MARKER_KEY_PG_MAP_HASH)) break;
            }
            int shaIndex = headerLine.indexOf("SHA-256 ", ProguardMapSupplier.MARKER_KEY_PG_MAP_HASH.length());
            if (shaIndex < 0) {
                return VerifyMappingFileHashResult.createError("Unknown map hash function: '" + headerLine + "'");
            }
            String headerHash = headerLine.substring(shaIndex + ProguardMapSupplier.SHA_256_KEY.length()).trim();
            Hasher hasher = Hashing.sha256().newHasher();
            String hashedContent = content.substring(lineEnd + 1);
            hasher.putString(hashedContent, StandardCharsets.UTF_8);
            String computedHash = hasher.hash().toString();
            return headerHash.equals(computedHash) ? VerifyMappingFileHashResult.createOk() : VerifyMappingFileHashResult.createError("Mismatching map hash: '" + headerHash + "' != '" + computedHash + "'");
        }

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
            this.inner.accept(string, handler);
            this.contents.append(string);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            this.inner.finished(handler);
            String stringContent = this.contents.toString();
            assert (ProguardMapChecker.validateProguardMapParses(stringContent));
            assert (ProguardMapChecker.validateProguardMapHash(stringContent).isOk());
        }

        public static class VerifyMappingFileHashResult {
            private final boolean error;
            private final String message;

            public static VerifyMappingFileHashResult createOk() {
                return new VerifyMappingFileHashResult(false, null);
            }

            public static VerifyMappingFileHashResult createInfo(String message) {
                return new VerifyMappingFileHashResult(false, message);
            }

            public static VerifyMappingFileHashResult createError(String message) {
                return new VerifyMappingFileHashResult(true, message);
            }

            private VerifyMappingFileHashResult(boolean error, String message) {
                this.error = error;
                this.message = message;
            }

            public boolean isOk() {
                return !this.error && this.message == null;
            }

            public boolean isError() {
                return this.error;
            }

            public String getMessage() {
                assert (this.message != null);
                return this.message;
            }
        }
    }

    class ProguardMapWriter
    implements ChainableStringConsumer {
        ProguardMapWriter() {
        }

        @Override
        public ProguardMapWriter accept(String string) {
            ProguardMapSupplier.this.consumer.accept(string, ProguardMapSupplier.this.reporter);
            return this;
        }
    }

    static class ProguardMapIdBuilder
    implements ChainableStringConsumer {
        private final Hasher hasher = Hashing.sha256().newHasher();

        ProguardMapIdBuilder() {
        }

        private MapIdProvider getProviderOrDefault(MapIdProvider provider) {
            return provider != null ? provider : environment -> environment.getMapHash().substring(0, PG_MAP_ID_LENGTH);
        }

        private MapIdEnvironment getEnvironment(final String hash) {
            return new MapIdEnvironment(){

                @Override
                public String getMapHash() {
                    return hash;
                }
            };
        }

        @Override
        public ProguardMapIdBuilder accept(String string) {
            this.hasher.putString(string, StandardCharsets.UTF_8);
            return this;
        }

        public ProguardMapId build(MapIdProvider mapIdProvider) {
            String hash = this.hasher.hash().toString();
            String id = this.getProviderOrDefault(mapIdProvider).get(this.getEnvironment(hash));
            return new ProguardMapId(id, hash);
        }
    }

    public static class ProguardMapId {
        private final String id;
        private final String hash;

        private ProguardMapId(String id, String hash) {
            assert (id != null);
            assert (hash != null);
            this.id = id;
            this.hash = hash;
        }

        public String getId() {
            return this.id;
        }

        public String getHash() {
            return this.hash;
        }
    }
}

