/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.FieldNamingStateBase;
import java.util.IdentityHashMap;
import java.util.Map;

class ReservedFieldNamingState
extends FieldNamingStateBase<InternalState> {
    private ReservedFieldNamingState interfaceMinificationState = null;

    ReservedFieldNamingState(AppView<? extends AppInfoWithClassHierarchy> appView) {
        super(appView, new IdentityHashMap());
    }

    private DexString getReservedByName(DexString name, DexType type) {
        DexString reservedByNameInState = ReservedFieldNamingState.getReservedByNameInState((InternalState)this.getInternalState(type), name);
        if (reservedByNameInState != null) {
            return reservedByNameInState;
        }
        return this.getReservedByNameInInterfaces(name, type);
    }

    private DexString getReservedByNameInInterfaces(DexString name, DexType type) {
        return this.interfaceMinificationState == null ? null : ReservedFieldNamingState.getReservedByNameInState((InternalState)this.interfaceMinificationState.getInternalState(type), name);
    }

    private static DexString getReservedByNameInState(InternalState internalState, DexString name) {
        return internalState == null ? null : internalState.getReservedByName(name);
    }

    private void includeInterfaceReservationState(ReservedFieldNamingState reservedNames) {
        if (reservedNames.interfaceMinificationState != null) {
            assert (this.interfaceMinificationState == null || this.interfaceMinificationState == reservedNames.interfaceMinificationState);
            this.interfaceMinificationState = reservedNames.interfaceMinificationState;
        }
    }

    boolean isReserved(DexString name, DexType type) {
        return this.getReservedByName(name, type) != null || this.getReservedByNameInInterfaces(name, type) != null;
    }

    void markReserved(DexString name, DexString originalName, DexType type) {
        ((InternalState)this.getOrCreateInternalState(type)).markReserved(name, originalName);
    }

    void includeReservations(ReservedFieldNamingState reservedNames) {
        for (Map.Entry entry : reservedNames.internalStates.entrySet()) {
            ((InternalState)this.getOrCreateInternalState((DexType)entry.getKey())).includeReservations((InternalState)entry.getValue());
        }
        this.includeInterfaceReservationState(reservedNames);
    }

    void setInterfaceMinificationState(ReservedFieldNamingState namingState) {
        assert (namingState != null);
        assert (this.interfaceMinificationState == null || this.interfaceMinificationState == namingState);
        this.interfaceMinificationState = namingState;
    }

    @Override
    InternalState createInternalState() {
        return new InternalState();
    }

    static class InternalState {
        private final Map<DexString, DexString> reservedNames = new IdentityHashMap<DexString, DexString>();

        InternalState() {
        }

        DexString getReservedByName(DexString name) {
            DexString reservedBy = this.reservedNames.get(name);
            return reservedBy != null ? reservedBy : this.reservedNames.get(name);
        }

        void markReserved(DexString name, DexString originalName) {
            this.reservedNames.put(name, originalName);
        }

        void includeReservations(InternalState state) {
            this.reservedNames.putAll(state.reservedNames);
        }
    }
}

