/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNamingForMapApplier;
import com.android.tools.r8.naming.ProguardMap;
import com.android.tools.r8.naming.ProguardMapError;
import com.android.tools.r8.naming.ProguardMapReader;
import com.android.tools.r8.naming.mappinginformation.MapVersionMappingInformation;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Reporter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SeedMapper
implements ProguardMap {
    private final ImmutableMap<String, ClassNamingForMapApplier> mappings;
    private final Set<String> mappedToDescriptorNames;
    private final Reporter reporter;

    static Builder builder(Reporter reporter) {
        return new Builder(reporter);
    }

    private static SeedMapper seedMapperFromInputStream(Reporter reporter, InputStream in) throws IOException {
        SeedMapper seedMapper;
        block11: {
            ProguardMapReader proguardReader;
            block10: {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                proguardReader = new ProguardMapReader(reader, reporter, false, false);
                Throwable throwable = null;
                try {
                    Builder builder = SeedMapper.builder(reporter);
                    proguardReader.parse(builder);
                    seedMapper = builder.build();
                    if (throwable == null) break block10;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable != null) {
                            try {
                                proguardReader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            proguardReader.close();
                        }
                        throw throwable3;
                    }
                }
                try {
                    proguardReader.close();
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                break block11;
            }
            proguardReader.close();
        }
        return seedMapper;
    }

    public static SeedMapper seedMapperFromFile(Reporter reporter, Path path) throws IOException {
        return SeedMapper.seedMapperFromInputStream(reporter, Files.newInputStream(path, new OpenOption[0]));
    }

    private SeedMapper(Map<String, ClassNamingForMapApplier.Builder> mappings, Set<String> mappedToDescriptorNames, Reporter reporter) {
        this.reporter = reporter;
        ImmutableMap.Builder<String, ClassNamingForMapApplier> builder = ImmutableMap.builder();
        for (Map.Entry<String, ClassNamingForMapApplier.Builder> entry : mappings.entrySet()) {
            builder.put(entry.getKey(), entry.getValue().build());
        }
        this.mappings = builder.build();
        this.mappedToDescriptorNames = mappedToDescriptorNames;
        this.verifyMappingsAreConflictFree();
    }

    private void verifyMappingsAreConflictFree() {
        HashMap<String, String> seenMappings = new HashMap<String, String>();
        for (String key : this.mappings.keySet()) {
            ClassNamingForMapApplier classNaming = this.mappings.get(key);
            String existing = seenMappings.put(classNaming.renamedName, key);
            if (existing == null) continue;
            this.reporter.error(ProguardMapError.duplicateTargetClass(DescriptorUtils.descriptorToJavaType(key), DescriptorUtils.descriptorToJavaType(existing), DescriptorUtils.descriptorToInternalName(classNaming.renamedName), classNaming.position));
        }
        this.reporter.failIfPendingErrors();
    }

    @Override
    public boolean hasMapping(DexType type) {
        return this.mappings.containsKey(type.descriptor.toString());
    }

    @Override
    public ClassNamingForMapApplier getClassNaming(DexType type) {
        return this.mappings.get(type.descriptor.toString());
    }

    public Set<String> getKeyset() {
        return this.mappings.keySet();
    }

    public Set<String> getMappedToDescriptorNames() {
        return this.mappedToDescriptorNames;
    }

    public ClassNamingForMapApplier getMapping(String key) {
        return this.mappings.get(key);
    }

    static class Builder
    extends ProguardMap.Builder {
        final Map<String, ClassNamingForMapApplier.Builder> map = new HashMap<String, ClassNamingForMapApplier.Builder>();
        final Set<String> mappedToDescriptorNames = new HashSet<String>();
        private final Reporter reporter;

        private Builder(Reporter reporter) {
            this.reporter = reporter;
        }

        @Override
        ClassNamingForMapApplier.Builder classNamingBuilder(String renamedName, String originalName, Position position) {
            String originalDescriptor = DescriptorUtils.javaTypeToDescriptor(originalName);
            String renamedDescriptorName = DescriptorUtils.javaTypeToDescriptor(renamedName);
            this.mappedToDescriptorNames.add(renamedDescriptorName);
            ClassNamingForMapApplier.Builder classNamingBuilder = ClassNamingForMapApplier.builder(renamedDescriptorName, originalDescriptor, position, this.reporter);
            if (this.map.put(originalDescriptor, classNamingBuilder) != null) {
                this.reporter.error(ProguardMapError.duplicateSourceClass(originalName, position));
            }
            return classNamingBuilder;
        }

        @Override
        ProguardMap.Builder setCurrentMapVersion(MapVersionMappingInformation mapVersion) {
            return this;
        }

        @Override
        SeedMapper build() {
            this.reporter.failIfPendingErrors();
            return new SeedMapper(ImmutableMap.copyOf(this.map), this.mappedToDescriptorNames, this.reporter);
        }
    }
}

