/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.dexitembasedstring;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;

public abstract class RecordFieldNamesComputationInfo
extends NameComputationInfo<DexType> {
    final DexField[] fields;

    protected RecordFieldNamesComputationInfo(DexField[] fields) {
        this.fields = fields;
    }

    static DexString dexStringFromFieldNames(List<String> fieldNames, DexItemFactory factory) {
        return factory.createString(StringUtils.join(";", fieldNames));
    }

    public static RecordFieldNamesComputationInfo forFieldNamesAndFields(DexString fieldNames, DexField[] fields) {
        String[] fieldNamesSplit;
        String fieldNamesString = fieldNames.toString();
        String[] stringArray = fieldNamesSplit = fieldNamesString.isEmpty() ? new String[]{} : fieldNamesString.split(";");
        assert (fieldNamesSplit.length == fields.length);
        if (RecordFieldNamesComputationInfo.fieldsMatchNames(fieldNamesSplit, fields)) {
            return new MatchingRecordFieldNamesComputationInfo(fields);
        }
        return new MissMatchingRecordFieldNamesComputationInfo(fieldNamesSplit, fields);
    }

    private static boolean fieldsMatchNames(String[] fieldNames, DexField[] fields) {
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fields[i].name.toString().equals(fieldNames[i])) continue;
            return false;
        }
        return true;
    }

    public DexString internalComputeNameFor(DexType type, DexDefinitionSupplier definitions, GraphLens graphLens, IntFunction<String> nameSupplier) {
        assert (Arrays.stream(this.fields).allMatch(f -> f.holder == type));
        DexClass recordClass = definitions.contextIndependentDefinitionFor(type);
        assert (recordClass != null);
        ArrayList<String> names = new ArrayList<String>(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            DexEncodedField recordField = recordClass.lookupInstanceField(graphLens.getRenamedFieldSignature(this.fields[i]));
            if (recordField == null) continue;
            names.add(nameSupplier.apply(i));
        }
        return RecordFieldNamesComputationInfo.dexStringFromFieldNames(names, definitions.dexItemFactory());
    }

    @Override
    DexString internalComputeNameFor(DexType reference, DexDefinitionSupplier definitions, NamingLens namingLens) {
        throw new Unreachable();
    }

    public abstract DexString internalComputeNameFor(DexType var1, DexDefinitionSupplier var2, GraphLens var3, NamingLens var4);

    @Override
    public boolean needsToComputeName() {
        return true;
    }

    @Override
    public boolean needsToRegisterReference() {
        return false;
    }

    @Override
    public boolean isRecordFieldNamesComputationInfo() {
        return true;
    }

    @Override
    public RecordFieldNamesComputationInfo asRecordFieldNamesComputationInfo() {
        return this;
    }

    private static class MatchingRecordFieldNamesComputationInfo
    extends RecordFieldNamesComputationInfo {
        public MatchingRecordFieldNamesComputationInfo(DexField[] fields) {
            super(fields);
        }

        @Override
        public DexString internalComputeNameFor(DexType type, DexDefinitionSupplier definitions, GraphLens graphLens, NamingLens namingLens) {
            return this.internalComputeNameFor(type, definitions, graphLens, (int i) -> namingLens.lookupField((DexField)graphLens.getRenamedFieldSignature((DexField)this.fields[i]), (DexItemFactory)definitions.dexItemFactory()).name.toString());
        }
    }

    private static class MissMatchingRecordFieldNamesComputationInfo
    extends RecordFieldNamesComputationInfo {
        private final String[] fieldNames;

        private MissMatchingRecordFieldNamesComputationInfo(String[] fieldNames, DexField[] fields) {
            super(fields);
            this.fieldNames = fieldNames;
        }

        @Override
        public DexString internalComputeNameFor(DexType type, DexDefinitionSupplier definitions, GraphLens graphLens, NamingLens namingLens) {
            return this.internalComputeNameFor(type, definitions, graphLens, (int i) -> this.fieldNames[i]);
        }
    }
}

