/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.mappinginformation;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.naming.mappinginformation.CompilerSynthesizedMappingInformation;
import com.android.tools.r8.naming.mappinginformation.FileNameInformation;
import com.android.tools.r8.naming.mappinginformation.MapVersionMappingInformation;
import com.android.tools.r8.naming.mappinginformation.MappingInformationDiagnostics;
import com.android.tools.r8.naming.mappinginformation.OutlineCallsiteMappingInformation;
import com.android.tools.r8.naming.mappinginformation.OutlineMappingInformation;
import com.android.tools.r8.naming.mappinginformation.RewriteFrameMappingInformation;
import com.android.tools.r8.naming.mappinginformation.UnknownJsonMappingInformation;
import java.util.function.Consumer;

public abstract class MappingInformation {
    public static final String MAPPING_ID_KEY = "id";

    public static void fromJsonObject(MapVersion version, JsonObject object, DiagnosticsHandler diagnosticsHandler, int lineNumber, Consumer<MappingInformation> onMappingInfo) {
        if (object == null) {
            diagnosticsHandler.info(MappingInformationDiagnostics.notValidJson(lineNumber));
            return;
        }
        JsonElement id = object.get(MAPPING_ID_KEY);
        if (id == null) {
            diagnosticsHandler.info(MappingInformationDiagnostics.noKeyInJson(lineNumber, MAPPING_ID_KEY));
            return;
        }
        String idString = id.getAsString();
        if (idString == null) {
            diagnosticsHandler.info(MappingInformationDiagnostics.notValidString(lineNumber, MAPPING_ID_KEY));
            return;
        }
        MappingInformation.deserialize(idString, version, object, diagnosticsHandler, lineNumber, onMappingInfo);
    }

    private static void deserialize(String id, MapVersion version, JsonObject object, DiagnosticsHandler diagnosticsHandler, int lineNumber, Consumer<MappingInformation> onMappingInfo) {
        switch (id) {
            case "com.android.tools.r8.mapping": {
                MapVersionMappingInformation.deserialize(object, lineNumber, onMappingInfo);
                return;
            }
            case "sourceFile": {
                FileNameInformation.deserialize(version, object, diagnosticsHandler, lineNumber, onMappingInfo);
                return;
            }
            case "com.android.tools.r8.synthesized": {
                CompilerSynthesizedMappingInformation.deserialize(version, onMappingInfo);
                return;
            }
            case "com.android.tools.r8.rewriteFrame": {
                RewriteFrameMappingInformation.deserialize(version, object, onMappingInfo);
                return;
            }
            case "com.android.tools.r8.outline": {
                OutlineMappingInformation.deserialize(version, onMappingInfo);
                return;
            }
            case "com.android.tools.r8.outlineCallsite": {
                OutlineCallsiteMappingInformation.deserialize(version, object, onMappingInfo);
                return;
            }
        }
        diagnosticsHandler.info(MappingInformationDiagnostics.noHandlerFor(lineNumber, id));
        UnknownJsonMappingInformation.deserialize(id, object, onMappingInfo);
    }

    static JsonElement getJsonElementFromObject(JsonObject object, DiagnosticsHandler diagnosticsHandler, int lineNumber, String key, String id) {
        JsonElement element = object.get(key);
        if (element == null) {
            diagnosticsHandler.info(MappingInformationDiagnostics.noKeyForObjectWithId(lineNumber, key, MAPPING_ID_KEY, id));
        }
        return element;
    }

    public abstract String getId();

    public abstract String serialize();

    public boolean isMapVersionMappingInformation() {
        return false;
    }

    public boolean isUnknownJsonMappingInformation() {
        return false;
    }

    public boolean isFileNameInformation() {
        return false;
    }

    public boolean isRewriteFrameMappingInformation() {
        return false;
    }

    public boolean isOutlineCallsiteInformation() {
        return false;
    }

    public boolean isCompilerSynthesizedMappingInformation() {
        return false;
    }

    public boolean isOutlineMappingInformation() {
        return false;
    }

    public MapVersionMappingInformation asMapVersionMappingInformation() {
        return null;
    }

    public FileNameInformation asFileNameInformation() {
        return null;
    }

    public CompilerSynthesizedMappingInformation asCompilerSynthesizedMappingInformation() {
        return null;
    }

    public UnknownJsonMappingInformation asUnknownJsonMappingInformation() {
        return null;
    }

    public RewriteFrameMappingInformation asRewriteFrameMappingInformation() {
        return null;
    }

    public OutlineCallsiteMappingInformation asOutlineCallsiteInformation() {
        return null;
    }

    public boolean isGlobalMappingInformation() {
        return false;
    }

    public abstract boolean allowOther(MappingInformation var1);
}

