/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.signature;

import com.android.tools.r8.com.google.common.base.Predicate;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignatureContextBuilder;
import com.android.tools.r8.graph.GenericSignaturePartialTypeArgumentApplier;
import com.android.tools.r8.graph.GenericSignatureTypeRewriter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiPredicate;

public class GenericSignatureRewriter {
    private final AppView<?> appView;
    private final NamingLens namingLens;
    private final GenericSignatureContextBuilder contextBuilder;

    public GenericSignatureRewriter(AppView<?> appView, NamingLens namingLens) {
        this(appView, namingLens, null);
    }

    public GenericSignatureRewriter(AppView<?> appView, NamingLens namingLens, GenericSignatureContextBuilder contextBuilder) {
        this.appView = appView;
        this.namingLens = namingLens;
        this.contextBuilder = contextBuilder;
    }

    public void runForD8(Iterable<? extends DexProgramClass> classes, ExecutorService executorService) throws ExecutionException {
        if (this.namingLens.isIdentityLens()) {
            return;
        }
        this.run(classes, executorService);
    }

    public void run(Iterable<? extends DexProgramClass> classes, ExecutorService executorService) throws ExecutionException {
        if (this.namingLens.isIdentityLens() && !((AppInfo)this.appView.appInfo()).hasLiveness() && !this.appView.options().parseSignatureAttribute()) {
            return;
        }
        Predicate wasPruned = this.appView.hasLiveness() ? this.appView.withLiveness().appInfo()::wasPruned : Predicates.alwaysFalse();
        java.util.function.Predicate<DexType> hasGenericTypeVariables = type -> GenericSignatureContextBuilder.hasGenericTypeVariables(this.appView, type, wasPruned);
        BiPredicate<DexType, DexType> hasPrunedRelationship = (enclosing, enclosed) -> this.contextBuilder.hasPrunedRelationship(this.appView, (DexReference)enclosing, (DexType)enclosed, wasPruned);
        ThreadUtils.processItems(IterableUtils.filter(classes, clazz -> !wasPruned.test(clazz.getType())), clazz -> {
            GenericSignaturePartialTypeArgumentApplier classArgumentApplier = this.contextBuilder != null ? GenericSignaturePartialTypeArgumentApplier.build(this.appView, this.contextBuilder.computeTypeParameterContext(this.appView, clazz.getType(), wasPruned), hasPrunedRelationship, hasGenericTypeVariables) : null;
            GenericSignatureTypeRewriter genericSignatureTypeRewriter = new GenericSignatureTypeRewriter(this.appView, (DexProgramClass)clazz, hasGenericTypeVariables);
            clazz.setClassSignature(genericSignatureTypeRewriter.rewrite(classArgumentApplier != null ? classArgumentApplier.visitClassSignature(clazz.getClassSignature()) : clazz.getClassSignature()));
            clazz.forEachField(field -> field.setGenericSignature(genericSignatureTypeRewriter.rewrite(classArgumentApplier != null ? classArgumentApplier.visitFieldTypeSignature(field.getGenericSignature()) : field.getGenericSignature())));
            clazz.forEachMethod(method -> method.setGenericSignature(genericSignatureTypeRewriter.rewrite(classArgumentApplier != null ? classArgumentApplier.buildForMethod(method.getGenericSignature().getFormalTypeParameters()).visitMethodSignature(method.getGenericSignature()) : method.getGenericSignature())));
        }, executorService);
    }
}

