/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.ir.optimize.MemberPoolCollection;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.optimize.PublicizerLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.Timing;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public final class ClassAndMemberPublicizer {
    private final DexApplication application;
    private final AppView<AppInfoWithLiveness> appView;
    private final KeepInfoCollection keepInfo;
    private final SubtypingInfo subtypingInfo;
    private final MethodPoolCollection methodPoolCollection;
    private final PublicizerLens.PublicizedLensBuilder lensBuilder = PublicizerLens.createBuilder();

    private ClassAndMemberPublicizer(DexApplication application, AppView<AppInfoWithLiveness> appView, SubtypingInfo subtypingInfo) {
        this.application = application;
        this.appView = appView;
        this.keepInfo = appView.appInfo().getKeepInfo();
        this.subtypingInfo = subtypingInfo;
        this.methodPoolCollection = new MethodPoolCollection(appView, subtypingInfo, MethodPoolCollection::excludesPrivateInstanceMethod);
    }

    public static GraphLens run(ExecutorService executorService, Timing timing, DexApplication application, AppView<AppInfoWithLiveness> appView, SubtypingInfo subtypingInfo) throws ExecutionException {
        return new ClassAndMemberPublicizer(application, appView, subtypingInfo).run(executorService, timing);
    }

    private GraphLens run(ExecutorService executorService, Timing timing) throws ExecutionException {
        this.methodPoolCollection.buildAll(executorService, timing);
        timing.begin("Phase 2: promoteToPublic");
        this.appView.appInfo().forEachReachableInterface(clazz -> this.publicizeType(clazz.getType()));
        this.publicizeType(this.appView.dexItemFactory().objectType);
        timing.end();
        return this.lensBuilder.build(this.appView);
    }

    private void doPublicize(ProgramDefinition definition) {
        definition.getAccessFlags().promoteToPublic();
    }

    private void publicizeType(DexType type) {
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.application.definitionFor(type));
        if (clazz != null) {
            this.publicizeClass(clazz);
        }
        this.subtypingInfo.forAllImmediateExtendsSubtypes(type, this::publicizeType);
    }

    private void publicizeClass(DexProgramClass clazz) {
        InnerClassAttribute attr;
        if (this.appView.appInfo().isAccessModificationAllowed(clazz)) {
            this.doPublicize(clazz);
        }
        clazz.forEachProgramField(this::publicizeField);
        LinkedHashSet<DexEncodedMethod> privateInstanceMethods = new LinkedHashSet<DexEncodedMethod>();
        clazz.forEachProgramMethod(method -> {
            if (this.publicizeMethod((ProgramMethod)method)) {
                privateInstanceMethods.add((DexEncodedMethod)method.getDefinition());
            }
        });
        if (!privateInstanceMethods.isEmpty()) {
            clazz.virtualizeMethods(privateInstanceMethods);
        }
        if ((attr = clazz.getInnerClassAttributeForThisClass()) != null) {
            int accessFlags = (attr.getAccess() | 1) & 0xFFFFFFFD & 0xFFFFFFFB;
            clazz.replaceInnerClassAttributeForThisClass(new InnerClassAttribute(accessFlags, attr.getInner(), attr.getOuter(), attr.getInnerName()));
        }
    }

    private void publicizeField(ProgramField field) {
        DexEncodedField definition = (DexEncodedField)field.getDefinition();
        if (definition.isPublic()) {
            return;
        }
        if (!this.appView.appInfo().isAccessModificationAllowed(field) && definition.isPrivate()) {
            return;
        }
        this.doPublicize(field);
    }

    private boolean publicizeMethod(ProgramMethod method) {
        MethodAccessFlags accessFlags = method.getAccessFlags();
        if (accessFlags.isPublic()) {
            return false;
        }
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (!this.appView.appInfo().isAccessModificationAllowed(method) && definition.isPrivate()) {
            return false;
        }
        if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer() || accessFlags.isProtected()) {
            this.doPublicize(method);
            return false;
        }
        if (accessFlags.isPackagePrivate()) {
            Equivalence.Wrapper<DexMethod> methodKey;
            MemberPoolCollection.MemberPool memberPool = this.methodPoolCollection.get(method.getHolder());
            if (memberPool.below(methodKey = MethodSignatureEquivalence.get().wrap((DexMethod)method.getReference()), false, true, (clazz, ignored) -> !method.getContextType().getPackageName().equals(clazz.getType().getPackageName())).booleanValue()) {
                return false;
            }
            this.doPublicize(method);
            return false;
        }
        assert (accessFlags.isPrivate());
        if (accessFlags.isStatic()) {
            this.doPublicize(method);
            return false;
        }
        if (method.getHolder().isInterface() || accessFlags.isSynthetic()) {
            return false;
        }
        boolean wasSeen = this.methodPoolCollection.markIfNotSeen(method.getHolder(), (DexMethod)method.getReference());
        if (wasSeen) {
            if (!this.appView.appInfo().isMinificationAllowed(method.getReference())) {
                return false;
            }
            return false;
        }
        this.lensBuilder.add((DexMethod)method.getReference());
        accessFlags.promoteToFinal();
        this.doPublicize(method);
        definition.setLibraryMethodOverride(OptionalBool.FALSE);
        return true;
    }
}

