/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class InvokeSingleTargetExtractor
extends UseRegistry<ProgramMethod> {
    private InvokeKind kind = InvokeKind.NONE;
    private DexMethod target;

    public InvokeSingleTargetExtractor(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        super(appView, context);
    }

    private void setTarget(DexMethod target, InvokeKind kind) {
        if (this.kind != InvokeKind.NONE) {
            this.kind = InvokeKind.ILLEGAL;
            this.target = null;
        } else {
            assert (this.target == null);
            this.target = target;
            this.kind = kind;
        }
    }

    private void invalid() {
        this.kind = InvokeKind.ILLEGAL;
    }

    public DexMethod getTarget() {
        return this.target;
    }

    public InvokeKind getKind() {
        return this.kind;
    }

    @Override
    public void registerInitClass(DexType clazz) {
        this.invalid();
    }

    @Override
    public void registerInvokeVirtual(DexMethod method) {
        this.setTarget(method, InvokeKind.VIRTUAL);
    }

    @Override
    public void registerInvokeDirect(DexMethod method) {
        this.invalid();
    }

    @Override
    public void registerInvokeStatic(DexMethod method) {
        this.setTarget(method, InvokeKind.STATIC);
    }

    @Override
    public void registerInvokeInterface(DexMethod method) {
        this.invalid();
    }

    @Override
    public void registerInvokeSuper(DexMethod method) {
        this.setTarget(method, InvokeKind.SUPER);
    }

    @Override
    public void registerInstanceFieldWrite(DexField field) {
        this.invalid();
    }

    @Override
    public void registerInstanceFieldRead(DexField field) {
        this.invalid();
    }

    @Override
    public void registerNewInstance(DexType type) {
        this.invalid();
    }

    @Override
    public void registerStaticFieldRead(DexField field) {
        this.invalid();
    }

    @Override
    public void registerStaticFieldWrite(DexField field) {
        this.invalid();
    }

    @Override
    public void registerTypeReference(DexType type) {
        this.invalid();
    }

    @Override
    public void registerInstanceOf(DexType type) {
        this.invalid();
    }

    public static enum InvokeKind {
        VIRTUAL,
        STATIC,
        SUPER,
        ILLEGAL,
        NONE;

    }
}

