/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfo;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import java.util.IdentityHashMap;
import java.util.Map;

public class MemberRebindingIdentityLens
extends GraphLens.NonIdentityGraphLens {
    private final Map<DexField, DexField> nonReboundFieldReferenceToDefinitionMap;
    private final Map<DexMethod, DexMethod> nonReboundMethodReferenceToDefinitionMap;

    private MemberRebindingIdentityLens(Map<DexField, DexField> nonReboundFieldReferenceToDefinitionMap, Map<DexMethod, DexMethod> nonReboundMethodReferenceToDefinitionMap, DexItemFactory dexItemFactory, GraphLens previousLens) {
        super(dexItemFactory, previousLens);
        assert (!previousLens.hasCodeRewritings());
        this.nonReboundFieldReferenceToDefinitionMap = nonReboundFieldReferenceToDefinitionMap;
        this.nonReboundMethodReferenceToDefinitionMap = nonReboundMethodReferenceToDefinitionMap;
    }

    public static Builder builder(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return MemberRebindingIdentityLens.builder(appView, appView.graphLens());
    }

    public static Builder builder(AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens previousLens) {
        return new Builder(appView, previousLens);
    }

    private DexField getReboundFieldReference(DexField field) {
        return this.nonReboundFieldReferenceToDefinitionMap.getOrDefault(field, field);
    }

    private DexMethod getReboundMethodReference(DexMethod method) {
        return this.nonReboundMethodReferenceToDefinitionMap.getOrDefault(method, method);
    }

    @Override
    public boolean hasCodeRewritings() {
        return false;
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        assert (!previous.hasReadCastType());
        assert (!previous.hasReboundReference());
        return ((GraphLens.FieldLookupResult.Builder)((GraphLens.FieldLookupResult.Builder)GraphLens.FieldLookupResult.builder(this).setReference((DexField)previous.getReference())).setReboundReference(this.getReboundFieldReference((DexField)previous.getReference()))).build();
    }

    @Override
    public GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        assert (previous.getReboundReference() == null);
        return ((GraphLens.MethodLookupResult.Builder)((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setReference((DexMethod)previous.getReference())).setReboundReference(this.getReboundMethodReference((DexMethod)previous.getReference()))).setPrototypeChanges(previous.getPrototypeChanges()).setType(previous.getType()).build();
    }

    @Override
    public DexType getOriginalType(DexType type) {
        return this.getPrevious().getOriginalType(type);
    }

    @Override
    public Iterable<DexType> getOriginalTypes(DexType type) {
        return this.getPrevious().getOriginalTypes(type);
    }

    @Override
    public DexField getOriginalFieldSignature(DexField field) {
        return this.getPrevious().getOriginalFieldSignature(field);
    }

    @Override
    public DexField getRenamedFieldSignature(DexField originalField, GraphLens codeLens) {
        if (this == codeLens) {
            return originalField;
        }
        return this.getPrevious().getRenamedFieldSignature(originalField);
    }

    @Override
    public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
        return this.getPrevious().getRenamedMethodSignature(originalMethod, applied);
    }

    @Override
    public final DexType internalDescribeLookupClassType(DexType previous) {
        return previous;
    }

    @Override
    public DexMethod getPreviousMethodSignature(DexMethod method) {
        return method;
    }

    @Override
    public DexMethod getNextMethodSignature(DexMethod method) {
        return method;
    }

    @Override
    public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
        if (this == codeLens) {
            return MemberRebindingIdentityLens.getIdentityLens().lookupPrototypeChangesForMethodDefinition(method, codeLens);
        }
        return this.getPrevious().lookupPrototypeChangesForMethodDefinition(method, codeLens);
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.getPrevious().isContextFreeForMethods();
    }

    @Override
    public boolean isMemberRebindingIdentityLens() {
        return true;
    }

    @Override
    public MemberRebindingIdentityLens asMemberRebindingIdentityLens() {
        return this;
    }

    public MemberRebindingIdentityLens toRewrittenMemberRebindingIdentityLens(AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens lens) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        Builder builder = MemberRebindingIdentityLens.builder(appView, MemberRebindingIdentityLens.getIdentityLens());
        this.nonReboundFieldReferenceToDefinitionMap.forEach((nonReboundFieldReference, reboundFieldReference) -> {
            DexField rewrittenReboundFieldReference = lens.lookupField((DexField)reboundFieldReference);
            DexField rewrittenNonReboundFieldReference = rewrittenReboundFieldReference.withHolder(lens.lookupType(nonReboundFieldReference.getHolderType()), dexItemFactory);
            builder.recordNonReboundFieldAccess(rewrittenNonReboundFieldReference, rewrittenReboundFieldReference);
        });
        this.nonReboundMethodReferenceToDefinitionMap.forEach((nonReboundMethodReference, reboundMethodReference) -> {
            DexMethod rewrittenReboundMethodReference = lens.getRenamedMethodSignature((DexMethod)reboundMethodReference);
            DexMethod rewrittenNonReboundMethodReference = rewrittenReboundMethodReference.withHolder(lens.lookupType(nonReboundMethodReference.getHolderType()), dexItemFactory);
            builder.recordNonReboundMethodAccess(rewrittenNonReboundMethodReference, rewrittenReboundMethodReference);
        });
        return builder.build();
    }

    public static class Builder {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        private final GraphLens previousLens;
        private final Map<DexField, DexField> nonReboundFieldReferenceToDefinitionMap = new IdentityHashMap<DexField, DexField>();
        private final Map<DexMethod, DexMethod> nonReboundMethodReferenceToDefinitionMap = new IdentityHashMap<DexMethod, DexMethod>();

        private Builder(AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens previousLens) {
            this.appView = appView;
            this.previousLens = previousLens;
        }

        private void recordNonReboundFieldAccess(DexField nonReboundFieldReference, DexField reboundFieldReference) {
            this.nonReboundFieldReferenceToDefinitionMap.put(nonReboundFieldReference, reboundFieldReference);
        }

        private void recordNonReboundMethodAccess(DexMethod nonReboundMethodReference, DexMethod reboundMethodReference) {
            this.nonReboundMethodReferenceToDefinitionMap.put(nonReboundMethodReference, reboundMethodReference);
        }

        void recordNonReboundFieldAccesses(FieldAccessInfo fieldAccessInfo) {
            fieldAccessInfo.forEachIndirectAccess(nonReboundFieldReference -> this.recordNonReboundFieldAccess((DexField)nonReboundFieldReference, fieldAccessInfo.getField()));
        }

        void recordMethodAccess(DexMethod reference) {
            MethodResolutionResult.SingleResolutionResult resolutionResult;
            if (reference.getHolderType().isArrayType()) {
                return;
            }
            DexClass holder = this.appView.contextIndependentDefinitionFor(reference.getHolderType());
            if (holder != null && (resolutionResult = this.appView.appInfo().resolveMethodOn(holder, reference).asSingleResolution()) != null && resolutionResult.getResolvedHolder() != holder) {
                this.recordNonReboundMethodAccess(reference, (DexMethod)resolutionResult.getResolvedMethod().getReference());
            }
        }

        MemberRebindingIdentityLens build() {
            return new MemberRebindingIdentityLens(this.nonReboundFieldReferenceToDefinitionMap, this.nonReboundMethodReferenceToDefinitionMap, this.appView.dexItemFactory(), this.previousLens);
        }
    }
}

