/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfo;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.optimize.FieldRebindingIdentityLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

public class MemberRebindingLens
extends GraphLens.NonIdentityGraphLens {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<Invoke.Type, Map<DexMethod, DexMethod>> methodMaps;
    private final Map<DexField, DexField> nonReboundFieldReferenceToDefinitionMap;

    public MemberRebindingLens(AppView<AppInfoWithLiveness> appView, Map<Invoke.Type, Map<DexMethod, DexMethod>> methodMaps, Map<DexField, DexField> nonReboundFieldReferenceToDefinitionMap) {
        super(appView.dexItemFactory(), appView.graphLens());
        this.appView = appView;
        this.methodMaps = methodMaps;
        this.nonReboundFieldReferenceToDefinitionMap = nonReboundFieldReferenceToDefinitionMap;
    }

    public static Builder builder(AppView<AppInfoWithLiveness> appView) {
        return new Builder(appView);
    }

    private DexField getReboundFieldReference(DexField field) {
        return this.nonReboundFieldReferenceToDefinitionMap.getOrDefault(field, field);
    }

    @Override
    public boolean isMemberRebindingLens() {
        return true;
    }

    @Override
    public MemberRebindingLens asMemberRebindingLens() {
        return this;
    }

    @Override
    public DexType getOriginalType(DexType type) {
        return this.getPrevious().getOriginalType(type);
    }

    @Override
    public Iterable<DexType> getOriginalTypes(DexType type) {
        return this.getPrevious().getOriginalTypes(type);
    }

    @Override
    public DexField getOriginalFieldSignature(DexField field) {
        return this.getPrevious().getOriginalFieldSignature(field);
    }

    @Override
    public DexField getRenamedFieldSignature(DexField originalField, GraphLens codeLens) {
        if (this == codeLens) {
            return originalField;
        }
        return this.getPrevious().getRenamedFieldSignature(originalField);
    }

    @Override
    public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
        return this != applied ? this.getPrevious().getRenamedMethodSignature(originalMethod, applied) : originalMethod;
    }

    @Override
    public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
        if (this == codeLens) {
            return MemberRebindingLens.getIdentityLens().lookupPrototypeChangesForMethodDefinition(method, codeLens);
        }
        return this.getPrevious().lookupPrototypeChangesForMethodDefinition(method, codeLens);
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.getPrevious().isContextFreeForMethods();
    }

    @Override
    protected DexType internalDescribeLookupClassType(DexType previous) {
        return previous;
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        assert (!previous.hasReadCastType());
        assert (!previous.hasReboundReference());
        return ((GraphLens.FieldLookupResult.Builder)((GraphLens.FieldLookupResult.Builder)GraphLens.FieldLookupResult.builder(this).setReference((DexField)previous.getReference())).setReboundReference(this.getReboundFieldReference((DexField)previous.getReference()))).build();
    }

    @Override
    public GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        Map methodMap = this.methodMaps.getOrDefault((Object)previous.getType(), Collections.emptyMap());
        DexMethod newMethod = (DexMethod)methodMap.get(previous.getReference());
        if (newMethod == null) {
            return previous;
        }
        return ((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setReference(newMethod)).setPrototypeChanges(previous.getPrototypeChanges()).setType(NestedGraphLens.mapVirtualInterfaceInvocationTypes(this.appView, newMethod, (DexMethod)previous.getReference(), previous.getType())).build();
    }

    @Override
    public DexMethod getPreviousMethodSignature(DexMethod method) {
        return method;
    }

    @Override
    public DexMethod getNextMethodSignature(DexMethod method) {
        return method;
    }

    public FieldRebindingIdentityLens toRewrittenFieldRebindingLens(AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens lens) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        FieldRebindingIdentityLens.Builder builder = FieldRebindingIdentityLens.builder();
        this.nonReboundFieldReferenceToDefinitionMap.forEach((nonReboundFieldReference, reboundFieldReference) -> {
            DexField rewrittenReboundFieldReference = lens.getRenamedFieldSignature((DexField)reboundFieldReference);
            DexField rewrittenNonReboundFieldReference = rewrittenReboundFieldReference.withHolder(lens.lookupType(nonReboundFieldReference.getHolderType()), dexItemFactory);
            builder.recordDefinitionForNonReboundFieldReference(rewrittenNonReboundFieldReference, rewrittenReboundFieldReference);
        });
        return builder.build(dexItemFactory);
    }

    public static class Builder {
        private final AppView<AppInfoWithLiveness> appView;
        private final Map<Invoke.Type, Map<DexMethod, DexMethod>> methodMaps = new IdentityHashMap<Invoke.Type, Map<DexMethod, DexMethod>>();
        private final Map<DexField, DexField> nonReboundFieldReferenceToDefinitionMap = new IdentityHashMap<DexField, DexField>();

        private Builder(AppView<AppInfoWithLiveness> appView) {
            this.appView = appView;
        }

        private void recordNonReboundFieldAccess(DexField nonReboundFieldReference, DexField reboundFieldReference) {
            this.nonReboundFieldReferenceToDefinitionMap.put(nonReboundFieldReference, reboundFieldReference);
        }

        public void map(DexMethod from, DexMethod to, Invoke.Type type) {
            if (from == to) {
                assert (!this.methodMaps.containsKey((Object)type) || this.methodMaps.get((Object)type).getOrDefault(from, to) == to);
                return;
            }
            Map methodMap = this.methodMaps.computeIfAbsent(type, ignore -> new IdentityHashMap());
            assert (methodMap.getOrDefault(from, to) == to);
            methodMap.put(from, to);
        }

        void recordNonReboundFieldAccesses(FieldAccessInfo info) {
            DexField reboundFieldReference = info.getField();
            info.forEachIndirectAccess(nonReboundFieldReference -> this.recordNonReboundFieldAccess((DexField)nonReboundFieldReference, reboundFieldReference));
        }

        public MemberRebindingLens build() {
            return new MemberRebindingLens(this.appView, this.methodMaps, this.nonReboundFieldReferenceToDefinitionMap);
        }
    }
}

