/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.TreeFixerBase;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfoFixer;
import com.android.tools.r8.ir.optimize.info.MutableFieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MutableMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorGraphLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class ArgumentPropagatorApplicationFixer
extends TreeFixerBase {
    private final AppView<AppInfoWithLiveness> appView;
    private final ArgumentPropagatorGraphLens graphLens;

    public ArgumentPropagatorApplicationFixer(AppView<AppInfoWithLiveness> appView, ArgumentPropagatorGraphLens graphLens) {
        super(appView);
        this.appView = appView;
        this.graphLens = graphLens;
    }

    private void fixupClass(DexProgramClass clazz) {
        this.fixupFields(clazz);
        this.fixupMethods(clazz);
    }

    private void fixupFields(DexProgramClass clazz) {
        clazz.setInstanceFields(this.fixupFields(clazz.instanceFields(), builder -> builder.setGenericSignature(GenericSignature.FieldTypeSignature.noSignature())));
        clazz.setStaticFields(this.fixupFields(clazz.staticFields(), builder -> builder.setGenericSignature(GenericSignature.FieldTypeSignature.noSignature())));
    }

    private void fixupMethods(DexProgramClass clazz) {
        MethodCollection methodCollection = clazz.getMethodCollection();
        methodCollection.replaceMethods(method -> {
            DexMethod methodReferenceBeforeParameterRemoval = (DexMethod)method.getReference();
            DexMethod methodReferenceAfterParameterRemoval = this.graphLens.getNextMethodSignature(methodReferenceBeforeParameterRemoval);
            if (methodReferenceAfterParameterRemoval == methodReferenceBeforeParameterRemoval && !this.graphLens.hasPrototypeChanges(methodReferenceAfterParameterRemoval)) {
                return method;
            }
            return method.toTypeSubstitutedMethod(methodReferenceAfterParameterRemoval, builder -> {
                if (this.graphLens.hasPrototypeChanges(methodReferenceAfterParameterRemoval)) {
                    RewrittenPrototypeDescription prototypeChanges = this.graphLens.getPrototypeChanges(methodReferenceAfterParameterRemoval);
                    builder.apply(prototypeChanges.createParameterAnnotationsRemover((DexEncodedMethod)method)).setGenericSignature(GenericSignature.MethodTypeSignature.noSignature());
                    if (method.isInstance() && prototypeChanges.getArgumentInfoCollection().isArgumentRemoved(0)) {
                        builder.modifyAccessFlags(flags -> ((MethodAccessFlags)flags.demoteFromFinal()).promoteToStatic()).unsetIsLibraryMethodOverride();
                    }
                }
            });
        });
    }

    private void fixupOptimizationInfos(ExecutorService executorService) throws ExecutionException {
        final GraphLens codeLens = this.graphLens.getPrevious();
        final PrunedItems prunedItems = PrunedItems.empty(this.appView.app());
        OptimizationFeedback.getSimpleFeedback().fixupOptimizationInfos(this.appView, executorService, new OptimizationFeedback.OptimizationInfoFixer(){

            @Override
            public void fixup(DexEncodedField field, MutableFieldOptimizationInfo optimizationInfo) {
                optimizationInfo.fixupAbstractValue(ArgumentPropagatorApplicationFixer.this.appView, ArgumentPropagatorApplicationFixer.this.graphLens, codeLens);
            }

            @Override
            public void fixup(DexEncodedMethod method, MutableMethodOptimizationInfo optimizationInfo) {
                optimizationInfo.fixupAbstractReturnValue(ArgumentPropagatorApplicationFixer.this.appView, ArgumentPropagatorApplicationFixer.this.graphLens, codeLens).fixupInstanceInitializerInfo(ArgumentPropagatorApplicationFixer.this.appView, ArgumentPropagatorApplicationFixer.this.graphLens, codeLens, prunedItems);
                if (ArgumentPropagatorApplicationFixer.this.graphLens.hasPrototypeChanges((DexMethod)method.getReference())) {
                    RewrittenPrototypeDescription prototypeChanges = ArgumentPropagatorApplicationFixer.this.graphLens.getPrototypeChanges((DexMethod)method.getReference());
                    MethodOptimizationInfoFixer fixer = prototypeChanges.createMethodOptimizationInfoFixer();
                    optimizationInfo.fixup(ArgumentPropagatorApplicationFixer.this.appView, fixer);
                }
            }
        });
    }

    public void fixupApplication(Set<DexProgramClass> affectedClasses, ExecutorService executorService, Timing timing) throws ExecutionException {
        if (this.graphLens == null) {
            assert (affectedClasses.isEmpty());
            return;
        }
        assert (!affectedClasses.isEmpty());
        timing.begin("Fixup application");
        ThreadUtils.processItems(affectedClasses, this::fixupClass, executorService);
        timing.end();
        timing.time("Fixup optimization info", () -> this.fixupOptimizationInfos(executorService));
        timing.begin("Rewrite AppView");
        this.appView.rewriteWithLens(this.graphLens);
        timing.end();
    }

    @Override
    public DexField fixupFieldReference(DexField field) {
        return this.graphLens.internalGetNextFieldSignature(field);
    }

    @Override
    public DexMethod fixupMethodReference(DexMethod method) {
        throw new Unreachable();
    }

    @Override
    public DexType fixupType(DexType type) {
        throw new Unreachable();
    }

    @Override
    public DexType mapClassType(DexType type) {
        return type;
    }

    @Override
    public void recordFieldChange(DexField from, DexField to) {
    }

    @Override
    public void recordMethodChange(DexMethod from, DexMethod to) {
    }

    @Override
    public void recordClassChange(DexType from, DexType to) {
        throw new Unreachable();
    }
}

