/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.ConcreteCallSiteOptimizationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.LinkedList;
import java.util.Set;

public class ArgumentPropagatorIROptimizer {
    public static void optimize(AppView<AppInfoWithLiveness> appView, IRCode code, ConcreteCallSiteOptimizationInfo optimizationInfo) {
        Argument argument;
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        LinkedList<Assume> assumeInstructions = new LinkedList<Assume>();
        LinkedList<Instruction> instructionsToAdd = new LinkedList<Instruction>();
        InstructionListIterator iterator2 = code.entryBlock().listIterator(code);
        while (iterator2.hasNext() && (argument = ((Instruction)iterator2.next()).asArgument()) != null) {
            Value specializedArg;
            DynamicType dynamicType;
            SingleValue singleValue;
            Value argumentValue = argument.asArgument().outValue();
            if (argumentValue.hasLocalInfo()) continue;
            AbstractValue abstractValue = optimizationInfo.getAbstractArgumentValue(argument.getIndex());
            if (abstractValue.isSingleValue() && (singleValue = abstractValue.asSingleValue()).isMaterializableInContext(appView, code.context())) {
                Instruction replacement = singleValue.createMaterializingInstruction(appView, code, argument);
                replacement.setPosition(argument.getPosition());
                affectedValues.addAll(argumentValue.affectedValues());
                argumentValue.replaceUsers(replacement.outValue());
                instructionsToAdd.add(replacement);
                continue;
            }
            if (!argumentValue.getType().isReferenceType() || (dynamicType = optimizationInfo.getDynamicType(argument.getIndex())).isUnknown()) continue;
            if (dynamicType.isBottom()) {
                assert (false);
                continue;
            }
            if (dynamicType.getNullability().isDefinitelyNull()) {
                ConstNumber nullInstruction = code.createConstNull();
                nullInstruction.setPosition(argument.getPosition());
                affectedValues.addAll(argumentValue.affectedValues());
                argumentValue.replaceUsers(nullInstruction.outValue());
                instructionsToAdd.add(nullInstruction);
                continue;
            }
            if (dynamicType.isNotNullType()) {
                if (argumentValue.getType().isDefinitelyNotNull()) continue;
                Value nonNullValue = code.createValue(argumentValue.getType().asReferenceType().asMeetWithNotNull());
                argumentValue.replaceUsers(nonNullValue, affectedValues);
                Assume assumeNotNull = Assume.createAssumeNonNullInstruction(nonNullValue, argumentValue, argument, appView);
                assumeNotNull.setPosition(argument.getPosition());
                assumeInstructions.add(assumeNotNull);
                continue;
            }
            DynamicTypeWithUpperBound dynamicTypeWithUpperBound = dynamicType.asDynamicTypeWithUpperBound();
            if (dynamicTypeWithUpperBound.strictlyLessThan(argumentValue.getType(), appView)) {
                specializedArg = code.createValue(argumentValue.getType());
                affectedValues.addAll(argumentValue.affectedValues());
                argumentValue.replaceUsers(specializedArg);
                Assume assumeType = Assume.createAssumeDynamicTypeInstruction(dynamicTypeWithUpperBound, specializedArg, argumentValue, argument, appView);
                assumeType.setPosition(argument.getPosition());
                assumeInstructions.add(assumeType);
            } else {
                specializedArg = argumentValue;
            }
            assert (specializedArg != null && specializedArg.getType().isReferenceType());
            if (!dynamicType.getNullability().isDefinitelyNotNull() || specializedArg.getType().isDefinitelyNotNull()) continue;
            Value nonNullArg = code.createValue(specializedArg.getType().asReferenceType().asMeetWithNotNull());
            affectedValues.addAll(specializedArg.affectedValues());
            specializedArg.replaceUsers(nonNullArg);
            Assume assumeNotNull = Assume.createAssumeNonNullInstruction(nonNullArg, specializedArg, argument, appView);
            assumeNotNull.setPosition(argument.getPosition());
            assumeInstructions.add(assumeNotNull);
        }
        assert (!iterator2.peekPrevious().isArgument());
        iterator2.previous();
        assert (iterator2.peekPrevious().isArgument());
        assumeInstructions.forEach(iterator2::add);
        instructionsToAdd.forEach(iterator2::add);
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(appView).narrowing(affectedValues);
        }
    }
}

