/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.PostMethodProcessor;
import com.android.tools.r8.ir.optimize.info.ConcreteCallSiteOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteClassTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionByReference;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.StateCloner;
import com.android.tools.r8.optimize.argumentpropagation.propagation.InParameterFlowPropagator;
import com.android.tools.r8.optimize.argumentpropagation.propagation.InterfaceMethodArgumentPropagator;
import com.android.tools.r8.optimize.argumentpropagation.propagation.VirtualDispatchMethodArgumentPropagator;
import com.android.tools.r8.optimize.argumentpropagation.utils.WideningUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;

public class ArgumentPropagatorOptimizationInfoPopulator {
    private final AppView<AppInfoWithLiveness> appView;
    private final IRConverter converter;
    private final MethodStateCollectionByReference methodStates;
    private final InternalOptions options;
    private final PostMethodProcessor.Builder postMethodProcessorBuilder;
    private final ImmediateProgramSubtypingInfo immediateSubtypingInfo;
    private final List<Set<DexProgramClass>> stronglyConnectedProgramComponents;
    private final BiConsumer<Set<DexProgramClass>, DexMethodSignature> interfaceDispatchOutsideProgram;

    ArgumentPropagatorOptimizationInfoPopulator(AppView<AppInfoWithLiveness> appView, IRConverter converter, ImmediateProgramSubtypingInfo immediateSubtypingInfo, MethodStateCollectionByReference methodStates, PostMethodProcessor.Builder postMethodProcessorBuilder, List<Set<DexProgramClass>> stronglyConnectedProgramComponents, BiConsumer<Set<DexProgramClass>, DexMethodSignature> interfaceDispatchOutsideProgram) {
        this.appView = appView;
        this.converter = converter;
        this.immediateSubtypingInfo = immediateSubtypingInfo;
        this.methodStates = methodStates;
        this.options = appView.options();
        this.postMethodProcessorBuilder = postMethodProcessorBuilder;
        this.stronglyConnectedProgramComponents = stronglyConnectedProgramComponents;
        this.interfaceDispatchOutsideProgram = interfaceDispatchOutsideProgram;
    }

    private void processStronglyConnectedComponent(Set<DexProgramClass> stronglyConnectedComponent) {
        new InterfaceMethodArgumentPropagator(this.appView, this.immediateSubtypingInfo, this.methodStates, signature -> this.interfaceDispatchOutsideProgram.accept(stronglyConnectedComponent, (DexMethodSignature)signature)).run(stronglyConnectedComponent);
        new VirtualDispatchMethodArgumentPropagator(this.appView, this.immediateSubtypingInfo, this.methodStates).run(stronglyConnectedComponent);
    }

    private void setOptimizationInfo(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), this::setOptimizationInfo, executorService);
    }

    private void setOptimizationInfo(DexProgramClass clazz) {
        clazz.forEachProgramMethod(this::setOptimizationInfo);
    }

    private void setOptimizationInfo(ProgramMethod method) {
        MethodOptimizationInfo optimizationInfo;
        MethodState methodState = this.methodStates.remove(method);
        if (methodState.isBottom()) {
            if (((DexEncodedMethod)method.getDefinition()).hasCode() && !((DexEncodedMethod)method.getDefinition()).isClassInitializer()) {
                method.convertToAbstractOrThrowNullMethod(this.appView);
                this.converter.onMethodCodePruned(method);
                this.postMethodProcessorBuilder.remove(method, this.appView.graphLens());
            }
            return;
        }
        if (!this.appView.getKeepInfo(method).isConstantArgumentOptimizationAllowed(this.options)) {
            methodState = MethodState.unknown();
        }
        if ((methodState = this.getMethodStateAfterUninstantiatedParameterRemoval(method, methodState)).isUnknown()) {
            return;
        }
        ConcreteMethodState concreteMethodState = methodState.asConcrete();
        if (concreteMethodState.isPolymorphic()) {
            assert (false);
            return;
        }
        ConcreteMonomorphicMethodState monomorphicMethodState = concreteMethodState.asMonomorphic();
        if (!this.widenDynamicTypes(method, monomorphicMethodState)) {
            return;
        }
        assert (monomorphicMethodState.getParameterStates().stream().noneMatch(ParameterState::isBottom));
        assert (monomorphicMethodState.getParameterStates().stream().filter(ParameterState::isConcrete).map(ParameterState::asConcrete).noneMatch(ConcreteParameterState::hasInParameters));
        if (monomorphicMethodState.size() > 0) {
            OptimizationFeedback.getSimpleFeedback().setArgumentInfos(method, ConcreteCallSiteOptimizationInfo.fromMethodState(this.appView, method, monomorphicMethodState));
        }
        if (!monomorphicMethodState.isReturnValueUsed()) {
            OptimizationFeedback.getSimpleFeedback().setIsReturnValueUsed(OptionalBool.FALSE, method);
        }
        if ((optimizationInfo = method.getOptimizationInfo()).returnsArgument()) {
            ParameterState returnedArgumentState = monomorphicMethodState.getParameterState(optimizationInfo.getReturnedArgument());
            OptimizationFeedback.getSimple().methodReturnsAbstractValue((DexEncodedMethod)method.getDefinition(), this.appView, returnedArgumentState.getAbstractValue(this.appView));
        }
    }

    private MethodState getMethodStateAfterUninstantiatedParameterRemoval(ProgramMethod method, MethodState methodState) {
        List<ParameterState> parameterStates;
        boolean isReturnValueUsed;
        assert (methodState.isMonomorphic() || methodState.isUnknown());
        if (!this.appView.getKeepInfo(method).isConstantArgumentOptimizationAllowed(this.options)) {
            return methodState;
        }
        int numberOfArguments = ((DexEncodedMethod)method.getDefinition()).getNumberOfArguments();
        if (methodState.isMonomorphic()) {
            ConcreteMonomorphicMethodState monomorphicMethodState = methodState.asMonomorphic();
            isReturnValueUsed = monomorphicMethodState.isReturnValueUsed();
            parameterStates = monomorphicMethodState.getParameterStates();
        } else {
            assert (methodState.isUnknown());
            isReturnValueUsed = true;
            parameterStates = ListUtils.newInitializedArrayList(numberOfArguments, ParameterState.unknown());
        }
        List<ParameterState> narrowedParameterStates = ListUtils.mapOrElse(parameterStates, (argumentIndex, parameterState) -> {
            if (!((DexEncodedMethod)method.getDefinition()).isStatic() && argumentIndex == 0) {
                return parameterState;
            }
            DexType argumentType = method.getArgumentType(argumentIndex);
            if (!argumentType.isAlwaysNull(this.appView)) {
                return parameterState;
            }
            return new ConcreteClassTypeParameterState(this.appView.abstractValueFactory().createNullValue(), DynamicType.definitelyNull());
        }, null);
        return narrowedParameterStates != null ? new ConcreteMonomorphicMethodState(isReturnValueUsed, narrowedParameterStates) : methodState;
    }

    private boolean widenDynamicTypes(ProgramMethod method, ConcreteMonomorphicMethodState methodState) {
        for (int argumentIndex = 0; argumentIndex < methodState.getParameterStates().size(); ++argumentIndex) {
            DexType staticType;
            DynamicType dynamicType;
            ConcreteParameterState parameterState = methodState.getParameterState(argumentIndex).asConcrete();
            if (parameterState == null || !parameterState.isClassParameter() || !this.shouldWidenDynamicTypeToUnknown(dynamicType = parameterState.asClassParameter().getDynamicType(), staticType = method.getArgumentType(argumentIndex))) continue;
            methodState.setParameterState(argumentIndex, parameterState.mutableJoin(this.appView, new ConcreteClassTypeParameterState(AbstractValue.bottom(), DynamicType.unknown()), staticType, StateCloner.getIdentity()));
        }
        return !methodState.isEffectivelyUnknown();
    }

    private boolean shouldWidenDynamicTypeToUnknown(DynamicType dynamicType, DexType staticType) {
        if (dynamicType.isUnknown()) {
            return false;
        }
        if (WideningUtils.widenDynamicNonReceiverType(this.appView, dynamicType, staticType).isUnknown()) {
            return true;
        }
        TypeElement staticTypeElement = staticType.toTypeElement(this.appView);
        TypeElement dynamicUpperBoundType = dynamicType.getDynamicUpperBoundType(staticTypeElement);
        return !dynamicUpperBoundType.lessThanOrEqual(staticTypeElement, this.appView);
    }

    void populateOptimizationInfo(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Propagate argument information for virtual methods");
        ThreadUtils.processItems(this.stronglyConnectedProgramComponents, this::processStronglyConnectedComponent, executorService);
        timing.end();
        timing.begin("Solve flow constraints");
        new InParameterFlowPropagator(this.appView, this.converter, this.methodStates).run(executorService);
        timing.end();
        timing.begin("Set optimization info");
        this.setOptimizationInfo(executorService);
        timing.end();
        assert (this.methodStates.isEmpty());
    }
}

