/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionByReference;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.UnknownMethodState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.classhierarchy.MethodOverridesCollector;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Collection;

public class ArgumentPropagatorUnoptimizableMethods {
    private final AppView<AppInfoWithLiveness> appView;
    private final ImmediateProgramSubtypingInfo immediateSubtypingInfo;
    private final MethodStateCollectionByReference methodStates;

    public ArgumentPropagatorUnoptimizableMethods(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo, MethodStateCollectionByReference methodStates) {
        this.appView = appView;
        this.immediateSubtypingInfo = immediateSubtypingInfo;
        this.methodStates = methodStates;
    }

    private void disableArgumentPropagationForMethod(ProgramMethod method) {
        this.methodStates.set(method, UnknownMethodState.get());
    }

    private boolean isUnoptimizableMethod(ProgramMethod method) {
        assert (!((DexEncodedMethod)method.getDefinition()).belongsToVirtualPool() || !((DexEncodedMethod)method.getDefinition()).isLibraryMethodOverride().isUnknown()) : "Unexpected virtual method without library method override information: " + method.toSourceString();
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        InternalOptions options = this.appView.options();
        return ((DexEncodedMethod)method.getDefinition()).isLibraryMethodOverride().isPossiblyTrue() || !appInfo.getKeepInfo().getMethodInfo(method).isArgumentPropagationAllowed(options);
    }

    public void initializeUnoptimizableMethodStates(Collection<DexProgramClass> stronglyConnectedComponent) {
        ProgramMethodSet unoptimizableVirtualMethods = MethodOverridesCollector.findAllMethodsAndOverridesThatMatches(this.appView, this.immediateSubtypingInfo, stronglyConnectedComponent, method -> {
            if (this.isUnoptimizableMethod((ProgramMethod)method)) {
                if (((DexEncodedMethod)method.getDefinition()).belongsToVirtualPool() && !method.getHolder().isFinal() && !method.getAccessFlags().isFinal()) {
                    return true;
                }
                this.disableArgumentPropagationForMethod((ProgramMethod)method);
            }
            return false;
        });
        unoptimizableVirtualMethods.forEach(this::disableArgumentPropagationForMethod);
    }
}

