/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.codescanner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteReferenceTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameter;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.SetUtils;
import java.util.Collections;
import java.util.Set;

public class ConcreteArrayTypeParameterState
extends ConcreteReferenceTypeParameterState {
    private Nullability nullability;

    public ConcreteArrayTypeParameterState(MethodParameter inParameter) {
        this(Nullability.bottom(), SetUtils.newHashSet(inParameter));
    }

    public ConcreteArrayTypeParameterState(Nullability nullability) {
        this(nullability, Collections.emptySet());
    }

    public ConcreteArrayTypeParameterState(Nullability nullability, Set<MethodParameter> inParameters) {
        super(inParameters);
        this.nullability = nullability;
        assert (!this.isEffectivelyBottom()) : "Must use BottomArrayTypeParameterState instead";
        assert (!this.isEffectivelyUnknown()) : "Must use UnknownParameterState instead";
    }

    @Override
    public ParameterState clearInParameters() {
        if (this.hasInParameters()) {
            if (this.nullability.isBottom()) {
                return ConcreteArrayTypeParameterState.bottomArrayTypeParameter();
            }
            this.internalClearInParameters();
        }
        assert (!this.isEffectivelyBottom());
        return this;
    }

    @Override
    public AbstractValue getAbstractValue(AppView<AppInfoWithLiveness> appView) {
        if (this.getNullability().isDefinitelyNull()) {
            return appView.abstractValueFactory().createNullValue();
        }
        return AbstractValue.unknown();
    }

    @Override
    public DynamicType getDynamicType() {
        return DynamicType.unknown();
    }

    @Override
    public ConcreteParameterState.ConcreteParameterStateKind getKind() {
        return ConcreteParameterState.ConcreteParameterStateKind.ARRAY;
    }

    @Override
    public Nullability getNullability() {
        return this.nullability;
    }

    @Override
    public boolean isArrayParameter() {
        return true;
    }

    @Override
    public ConcreteArrayTypeParameterState asArrayParameter() {
        return this;
    }

    public boolean isEffectivelyBottom() {
        return this.nullability.isBottom() && !this.hasInParameters();
    }

    public boolean isEffectivelyUnknown() {
        return this.nullability.isMaybeNull();
    }

    @Override
    public ParameterState mutableCopy() {
        return new ConcreteArrayTypeParameterState(this.nullability, this.copyInParameters());
    }

    @Override
    public ParameterState mutableJoin(AppView<AppInfoWithLiveness> appView, ConcreteReferenceTypeParameterState parameterState, DexType parameterType, Action onChangedAction) {
        assert (parameterType.isArrayType());
        assert (!this.nullability.isUnknown());
        this.nullability = this.nullability.join(parameterState.getNullability());
        if (this.nullability.isUnknown()) {
            return ConcreteArrayTypeParameterState.unknown();
        }
        boolean inParametersChanged = this.mutableJoinInParameters(parameterState);
        if (this.widenInParameters(appView)) {
            return ConcreteArrayTypeParameterState.unknown();
        }
        if (inParametersChanged) {
            onChangedAction.execute();
        }
        return this;
    }
}

