/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.codescanner;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodStateOrBottom;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodStateOrUnknown;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.StateCloner;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayList;
import java.util.List;

public class ConcreteMonomorphicMethodState
extends ConcreteMethodState
implements ConcreteMonomorphicMethodStateOrBottom,
ConcreteMonomorphicMethodStateOrUnknown {
    boolean isReturnValueUsed;
    List<ParameterState> parameterStates;

    public ConcreteMonomorphicMethodState(boolean isReturnValueUsed, List<ParameterState> parameterStates) {
        assert (Streams.stream(Iterables.skip(parameterStates, 1)).noneMatch(x -> x.isConcrete() && x.asConcrete().isReceiverParameter()));
        this.isReturnValueUsed = isReturnValueUsed;
        this.parameterStates = parameterStates;
        assert (!this.isEffectivelyUnknown()) : "Must use UnknownMethodState instead";
    }

    public static ConcreteMonomorphicMethodStateOrUnknown create(boolean isReturnValueUsed, List<ParameterState> parameterStates) {
        return ConcreteMonomorphicMethodState.isEffectivelyUnknown(isReturnValueUsed, parameterStates) ? ConcreteMonomorphicMethodState.unknown() : new ConcreteMonomorphicMethodState(isReturnValueUsed, parameterStates);
    }

    private static boolean isEffectivelyUnknown(boolean isReturnValueUsed, List<ParameterState> parameterStates) {
        return isReturnValueUsed && Iterables.all(parameterStates, ParameterState::isUnknown);
    }

    public ParameterState getParameterState(int index) {
        return this.parameterStates.get(index);
    }

    public List<ParameterState> getParameterStates() {
        return this.parameterStates;
    }

    public boolean isReturnValueUsed() {
        return this.isReturnValueUsed;
    }

    public boolean isEffectivelyBottom() {
        return Iterables.any(this.parameterStates, ParameterState::isBottom);
    }

    public boolean isEffectivelyUnknown() {
        return ConcreteMonomorphicMethodState.isEffectivelyUnknown(this.isReturnValueUsed, this.parameterStates);
    }

    @Override
    public ConcreteMonomorphicMethodState mutableCopy() {
        ArrayList<ParameterState> copiedParametersStates = new ArrayList<ParameterState>(this.size());
        for (ParameterState parameterState : this.getParameterStates()) {
            copiedParametersStates.add(parameterState.mutableCopy());
        }
        return new ConcreteMonomorphicMethodState(this.isReturnValueUsed, copiedParametersStates);
    }

    public ConcreteMonomorphicMethodStateOrUnknown mutableJoin(AppView<AppInfoWithLiveness> appView, DexMethodSignature methodSignature, ConcreteMonomorphicMethodState methodState, StateCloner cloner) {
        if (this.size() != methodState.size()) {
            assert (false);
            return ConcreteMonomorphicMethodState.unknown();
        }
        if (methodState.isReturnValueUsed()) {
            this.isReturnValueUsed = true;
        }
        int argumentIndex = 0;
        if (this.size() > methodSignature.getArity()) {
            assert (this.size() == methodSignature.getArity() + 1);
            ParameterState parameterState = this.parameterStates.get(0);
            ParameterState otherParameterState = methodState.parameterStates.get(0);
            DexType parameterType = null;
            this.parameterStates.set(0, parameterState.mutableJoin(appView, otherParameterState, parameterType, cloner));
            ++argumentIndex;
        }
        int parameterIndex = 0;
        while (argumentIndex < this.size()) {
            ParameterState parameterState = this.parameterStates.get(argumentIndex);
            ParameterState otherParameterState = methodState.parameterStates.get(argumentIndex);
            DexType parameterType = methodSignature.getParameter(parameterIndex);
            this.parameterStates.set(argumentIndex, parameterState.mutableJoin(appView, otherParameterState, parameterType, cloner));
            assert (!this.parameterStates.get(argumentIndex).isConcrete() || !this.parameterStates.get(argumentIndex).asConcrete().isReceiverParameter());
            ++argumentIndex;
            ++parameterIndex;
        }
        return this.isEffectivelyUnknown() ? ConcreteMonomorphicMethodState.unknown() : this;
    }

    @Override
    public boolean isMonomorphic() {
        return true;
    }

    @Override
    public ConcreteMonomorphicMethodState asMonomorphic() {
        return this;
    }

    @Override
    public ConcreteMonomorphicMethodStateOrBottom asMonomorphicOrBottom() {
        return this;
    }

    public void setParameterState(int index, ParameterState parameterState) {
        assert (index == 0 || !parameterState.isConcrete() || !parameterState.asConcrete().isReceiverParameter());
        this.parameterStates.set(index, parameterState);
    }

    public int size() {
        return this.parameterStates.size();
    }
}

